/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.qa.diff.MatchFeature;
import com.vividsolutions.jump.qa.diff.MatchGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MatchCollection {
    private FeatureCollection inputFC;
    private Collection matchFeatures = new ArrayList();
    private Collection matchGeometries = new ArrayList();

    public MatchCollection(FeatureCollection fc, boolean splitIntoComponents) {
        this.inputFC = fc;
        this.init(fc, splitIntoComponents);
    }

    private void init(FeatureCollection fc, boolean splitIntoComponents) {
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature feat = (Feature)i.next();
            MatchFeature matchFeat = new MatchFeature(feat);
            this.matchFeatures.add(matchFeat);
            Geometry geom = feat.getGeometry();
            Collection list = MatchGeometry.splitGeometry(geom, splitIntoComponents);
            for (Geometry g : list) {
                MatchGeometry matchGeom = new MatchGeometry(matchFeat, g);
                this.matchGeometries.add(matchGeom);
            }
        }
    }

    public Iterator geometryIterator() {
        return this.matchGeometries.iterator();
    }

    public Iterator iterator() {
        return this.matchFeatures.iterator();
    }

    public int size() {
        return this.matchFeatures.size();
    }

    public int geometrySize() {
        return this.matchGeometries.size();
    }

    public void computeFeatureMatches() {
        for (MatchFeature mf : this.matchFeatures) {
            mf.setMatched(true);
        }
        for (MatchGeometry mg : this.matchGeometries) {
            if (mg.isMatched()) continue;
            mg.getFeature().setMatched(false);
        }
    }

    public void propagateUnmatchedFeatures() {
        for (MatchGeometry mg : this.matchGeometries) {
            MatchGeometry mgOpposite;
            if (mg.getFeature().isMatched() || (mgOpposite = mg.getMatch()) == null) continue;
            mgOpposite.getFeature().setMatched(false);
        }
    }

    public FeatureCollection getUnmatchedFeatures() {
        FeatureDataset noMatch = new FeatureDataset(this.inputFC.getFeatureSchema());
        for (MatchFeature mf : this.matchFeatures) {
            if (mf.isMatched()) continue;
            noMatch.add(mf.getFeature());
        }
        return noMatch;
    }
}

