/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.LineSegmentUtil;
import com.vividsolutions.jump.qa.diff.UniqueSegmentsWithToleranceFinder;
import java.util.ArrayList;
import java.util.List;

public class DiffSegmentsWithTolerance {
    private static GeometryFactory geomFactory = new GeometryFactory();
    private FeatureCollection[] inputFC = new FeatureCollection[2];
    private double tolerance;
    private List[] diffGeom = new ArrayList[2];

    public DiffSegmentsWithTolerance(FeatureCollection fc0, FeatureCollection fc1, double tolerance) {
        this.inputFC[0] = fc0;
        this.inputFC[1] = fc1;
        this.tolerance = tolerance;
    }

    public FeatureCollection[] diff() {
        this.compute(this.inputFC[0], this.inputFC[1]);
        FeatureCollection[] diffFC = new FeatureCollection[]{FeatureDatasetFactory.createFromGeometry(this.diffGeom[0]), FeatureDatasetFactory.createFromGeometry(this.diffGeom[1])};
        return diffFC;
    }

    private void compute(FeatureCollection fc0, FeatureCollection fc1) {
        this.diffGeom[0] = this.findUniqueSegmentGeometries(fc0, fc1);
        this.diffGeom[1] = this.findUniqueSegmentGeometries(fc1, fc0);
    }

    private List findUniqueSegmentGeometries(FeatureCollection fc0, FeatureCollection fc1) {
        ArrayList<LineString> segGeomList = new ArrayList<LineString>();
        UniqueSegmentsWithToleranceFinder finder = new UniqueSegmentsWithToleranceFinder(fc0, fc1);
        List segs = finder.findUniqueSegments(this.tolerance);
        for (LineSegment seg : segs) {
            segGeomList.add(LineSegmentUtil.asGeometry(geomFactory, seg));
        }
        return segGeomList;
    }
}

