/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FeatureDataset
implements FeatureCollection,
Serializable {
    private static final long serialVersionUID = 5573446944516446540L;
    private FeatureSchema featureSchema;
    private ArrayList features;
    private Envelope envelope = null;

    public FeatureDataset(Collection newFeatures, FeatureSchema featureSchema) {
        this.features = new ArrayList(newFeatures);
        this.featureSchema = featureSchema;
    }

    public FeatureDataset(FeatureSchema featureSchema) {
        this(new ArrayList(), featureSchema);
    }

    public Feature getFeature(int index) {
        return (Feature)this.features.get(index);
    }

    public FeatureSchema getFeatureSchema() {
        return this.featureSchema;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = new Envelope();
            for (Feature feature : this.features) {
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
        return this.envelope;
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List query(Envelope envelope) {
        if (!envelope.intersects(this.getEnvelope())) {
            return new ArrayList();
        }
        ArrayList<Feature> queryResult = new ArrayList<Feature>();
        for (Feature feature : this.features) {
            if (!feature.getGeometry().getEnvelopeInternal().intersects(envelope)) continue;
            queryResult.add(feature);
        }
        return queryResult;
    }

    public void add(Feature feature) {
        this.features.add(feature);
        if (this.envelope != null) {
            this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
        }
    }

    public boolean contains(Feature feature) {
        return this.features.contains(feature);
    }

    public Collection remove(Envelope env) {
        List features = this.query(env);
        this.removeAll(features);
        return features;
    }

    public void remove(Feature feature) {
        this.features.remove(feature);
        this.invalidateEnvelope();
    }

    public void clear() {
        this.invalidateEnvelope();
        this.features.clear();
    }

    public int size() {
        return this.features.size();
    }

    public Iterator iterator() {
        return this.features.iterator();
    }

    public void invalidateEnvelope() {
        this.envelope = null;
    }

    public void addAll(Collection features) {
        this.features.addAll(features);
        if (this.envelope != null) {
            for (Feature feature : features) {
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
    }

    public void removeAll(Collection c) {
        HashMap<Integer, Feature> map = new HashMap<Integer, Feature>();
        for (Feature f : this.features) {
            map.put(f.getID(), f);
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            map.remove(((Feature)i.next()).getID());
        }
        this.features = new ArrayList();
        this.features.addAll(map.values());
        this.invalidateEnvelope();
    }
}

