/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.jdbc.JDBCUtil;
import com.vividsolutions.jump.datastore.jdbc.ResultSetBlock;
import com.vividsolutions.jump.datastore.postgis.PostgisDSConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostgisDSMetadata
implements DataStoreMetadata {
    private final WKBReader reader = new WKBReader();
    private PostgisDSConnection conn;
    private Map sridMap = new HashMap();

    public PostgisDSMetadata(PostgisDSConnection conn) {
        this.conn = conn;
    }

    public String[] getDatasetNames() {
        final ArrayList datasetNames = new ArrayList();
        JDBCUtil.execute(this.conn.getConnection(), "SELECT DISTINCT f_table_schema, f_table_name FROM geometry_columns", new ResultSetBlock(){

            public void yield(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    String schema = resultSet.getString(1);
                    String table = resultSet.getString(2);
                    if (!schema.equalsIgnoreCase("public")) {
                        table = schema + "." + table;
                    }
                    datasetNames.add(table);
                }
            }
        });
        return datasetNames.toArray(new String[0]);
    }

    public Envelope getExtents(String datasetName, String attributeName) {
        final Envelope[] e = new Envelope[]{null};
        String sql = "";
        if (datasetName.indexOf(46) != -1) {
            String[] parts = datasetName.split("\\.", 2);
            sql = "SELECT AsBinary(find_extent( '" + parts[0] + "', '" + parts[1] + "', '" + attributeName + "' ))";
        } else {
            sql = "SELECT AsBinary(find_extent( '" + datasetName + "', '" + attributeName + "' ))";
        }
        JDBCUtil.execute(this.conn.getConnection(), sql, new ResultSetBlock(){

            public void yield(ResultSet resultSet) throws Exception {
                Geometry geom;
                byte[] bytes;
                if (resultSet.next() && (bytes = (byte[])resultSet.getObject(1)) != null && (geom = PostgisDSMetadata.this.reader.read(bytes)) != null) {
                    e[0] = geom.getEnvelopeInternal();
                }
            }
        });
        return e[0];
    }

    public SpatialReferenceSystemID getSRID(String tableName, String colName) throws SQLException {
        Object srid;
        String key = tableName + "#" + colName;
        if (!this.sridMap.containsKey(key)) {
            srid = this.querySRID(tableName, colName);
            this.sridMap.put(key, new SpatialReferenceSystemID((String)srid));
        }
        srid = (SpatialReferenceSystemID)this.sridMap.get(key);
        return srid;
    }

    private String querySRID(String tableName, String colName) {
        final StringBuffer srid = new StringBuffer();
        String[] tokens = tableName.split("\\.", 2);
        String schema = tokens.length == 2 ? tokens[0] : "public";
        String table = tokens.length == 2 ? tokens[1] : tableName;
        String sql = "SELECT srid FROM geometry_columns where (f_table_schema = '" + schema + "' and f_table_name = '" + table + "')";
        JDBCUtil.execute(this.conn.getConnection(), sql, new ResultSetBlock(){

            public void yield(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    srid.append(resultSet.getString(1));
                }
            }
        });
        return srid.toString();
    }

    public String[] getGeometryAttributeNames(String datasetName) {
        final ArrayList geometryAttributeNames = new ArrayList();
        String sql = "SELECT f_geometry_column FROM geometry_columns " + this.geomColumnMetadataWhereClause("f_table_schema", "f_table_name", datasetName);
        JDBCUtil.execute(this.conn.getConnection(), sql, new ResultSetBlock(){

            public void yield(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    geometryAttributeNames.add(resultSet.getString(1));
                }
            }
        });
        return geometryAttributeNames.toArray(new String[0]);
    }

    public String[] getColumnNames(String datasetName) {
        String sql = "SELECT column_name FROM information_schema.columns " + this.geomColumnMetadataWhereClause("table_schema", "table_name", datasetName);
        ColumnNameBlock block = new ColumnNameBlock();
        JDBCUtil.execute(this.conn.getConnection(), sql, block);
        return block.colName;
    }

    private String geomColumnMetadataWhereClause(String schemaCol, String tableCol, String tableName) {
        int dotPos = tableName.indexOf(".");
        String schema = "public";
        String table = tableName.toLowerCase();
        if (dotPos != -1) {
            schema = tableName.substring(0, dotPos).toLowerCase();
            table = tableName.substring(dotPos + 1).toLowerCase();
        }
        return "WHERE lower(" + schemaCol + ") = '" + schema + "'" + " AND lower(" + tableCol + ") = '" + table + "'";
    }

    private static class ColumnNameBlock
    implements ResultSetBlock {
        List colList = new ArrayList();
        String[] colName;

        private ColumnNameBlock() {
        }

        public void yield(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.colList.add(resultSet.getString(1));
            }
            this.colName = this.colList.toArray(new String[0]);
        }
    }
}

