/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.geom.LineSegmentEnvelopeIntersector;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CoordinateArrays;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.IncrementChooser;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.MetricSystem;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.ScaleBarRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicSliderUI;

public class ZoomBar
extends JPanel
implements Java2DConverter.PointConverter {
    private Envelope lastGoodEnvelope = null;
    private WorkbenchFrame frame;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JSlider slider = new JSlider();
    private JLabel label = new JLabel();
    private IncrementChooser incrementChooser = new IncrementChooser();
    private Collection metricUnits = new MetricSystem(1.0).createUnits();
    private Java2DConverter java2DConverter;
    private AffineTransform affineTransform;
    private Timer componentUpdateTimer = GUIUtil.createRestartableSingleEventTimer(200, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            try {
                ZoomBar.this.updateComponents();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    });
    private Stroke stroke = new BasicStroke(1.0f);
    private static final String SEGMENT_CACHE_KEY = ZoomBar.class.getName() + " - SEGMENT CACHE";
    private LineSegmentEnvelopeIntersector lineSegmentEnvelopeIntersector = new LineSegmentEnvelopeIntersector();
    private static final int LARGE_GEOMETRIES = 100;
    private static final int LARGE_ONSCREEN_GEOMETRIES = 200;
    static final Comparator MAX_SIZE_COMPARATOR = new Comparator(){

        public int compare(Object f1, Object f2) {
            double size2;
            Envelope env1 = ((Feature)f1).getGeometry().getEnvelopeInternal();
            Envelope env2 = ((Feature)f2).getGeometry().getEnvelopeInternal();
            double size1 = Math.max(env1.getWidth(), env1.getHeight());
            return size1 < (size2 = Math.max(env2.getWidth(), env2.getHeight())) ? 1 : (size1 > size2 ? -1 : 0);
        }
    };
    private static final String SCALE_KEY = ZoomBar.class.getName() + " - SCALE";
    private static final String CENTRE_KEY = ZoomBar.class.getName() + " - CENTRE";
    private static final String CENTRE_LOCKED_KEY = ZoomBar.class.getName() + " - CENTRE LOCKED";
    private static final String MIN_EXTENT_KEY = ZoomBar.class.getName() + " - MIN EXTENT";
    private static final String USER_DEFINED_MIN_SCALE = ZoomBar.class.getName() + " - USER DEFINED MIN SCALE";
    private static final String USER_DEFINED_MAX_SCALE = ZoomBar.class.getName() + " - USER DEFINED MAX SCALE";
    private static final String MAX_EXTENT_KEY = ZoomBar.class.getName() + " - MAX EXTENT";
    private final LayerViewPanel dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(){

        public void setStatusMessage(String message) {
        }

        public void warnUser(String warning) {
        }

        public void handleThrowable(Throwable t) {
        }
    });
    private Font sliderLabelFont = new Font("Dialog", 0, 10);
    private boolean showingSliderLabels;

    private int totalGeometries() {
        int totalGeometries = 0;
        for (Layer layer : this.layerViewPanel().getLayerManager().getVisibleLayers(true)) {
            totalGeometries += layer.getFeatureCollectionWrapper().size();
        }
        return totalGeometries;
    }

    public ZoomBar(boolean showingSliderLabels, boolean showingRightSideLabel, WorkbenchFrame frame) throws NoninvertibleTransformException {
        this.frame = frame;
        this.showingSliderLabels = showingSliderLabels;
        this.slider.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        if (showingSliderLabels) {
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(0), new JLabel(" "));
            this.slider.setLabelTable(labelTable);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!showingRightSideLabel) {
            this.remove(this.label);
        }
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 3 && SwingUtilities.isRightMouseButton(e)) {
                    ZoomBar.this.viewBlackboard().put(USER_DEFINED_MIN_SCALE, null);
                    ZoomBar.this.viewBlackboard().put(USER_DEFINED_MAX_SCALE, null);
                    ZoomBar.this.clearModelCaches();
                }
            }
        });
        this.slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                try {
                    ZoomBar.this.layerViewPanel().erase((Graphics2D)ZoomBar.this.layerViewPanel().getGraphics());
                    ZoomBar.this.drawWireframe();
                    ScaleBarRenderer scaleBarRenderer = (ScaleBarRenderer)ZoomBar.this.layerViewPanel().getRenderingManager().getRenderer(ScaleBarRenderer.CONTENT_ID);
                    if (scaleBarRenderer != null) {
                        scaleBarRenderer.paint((Graphics2D)ZoomBar.this.layerViewPanel().getGraphics(), ZoomBar.this.getScale());
                    }
                    ZoomBar.this.updateLabel();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        if (this.slider.getUI() instanceof BasicSliderUI) {
            this.slider.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    if (ZoomBar.this.layerViewPanel() == ZoomBar.this.dummyLayerViewPanel) {
                        return;
                    }
                    try {
                        ZoomBar.this.slider.setToolTipText(I18N.get((String)"ui.zoom.ZoomBar.zoom-to") + " " + ZoomBar.this.chooseGoodIncrement(ZoomBar.this.toScale(((BasicSliderUI)ZoomBar.this.slider.getUI()).valueForXPosition(e.getX()))).toString());
                    }
                    catch (NoninvertibleTransformException x) {
                        ZoomBar.this.slider.setToolTipText(I18N.get((String)"ui.zoom.ZoomBar.zoom"));
                    }
                }
            });
        }
        this.label.setPreferredSize(new Dimension(50, this.label.getHeight()));
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        ZoomBar.this.gestureFinished();
                    }
                }
                catch (NoninvertibleTransformException t) {
                    ZoomBar.this.layerViewPanel().getContext().handleThrowable(t);
                }
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!ZoomBar.this.slider.isEnabled()) {
                    return;
                }
                ZoomBar.this.layerViewPanel().getRenderingManager().setPaintingEnabled(false);
            }

            public void mouseReleased(MouseEvent e) {
                try {
                    ZoomBar.this.gestureFinished();
                }
                catch (NoninvertibleTransformException t) {
                    ZoomBar.this.layerViewPanel().getContext().handleThrowable(t);
                }
            }
        });
        GUIUtil.addInternalFrameListener(frame.getDesktopPane(), GUIUtil.toInternalFrameListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZoomBar.this.installListenersOnCurrentPanel();
                try {
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }));
        this.java2DConverter = new Java2DConverter(this, 2.0);
        this.installListenersOnCurrentPanel();
        this.updateComponents();
    }

    private void installListenersOnCurrentPanel() {
        this.installViewListeners();
        this.installModelListeners();
    }

    private void installViewListeners() {
        String VIEW_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - VIEW LISTENERS INSTALLED";
        if (this.viewBlackboard().get(VIEW_LISTENERS_INSTALLED_KEY) != null) {
            return;
        }
        if (this.layerViewPanel() == null) {
            return;
        }
        this.layerViewPanel().getViewport().addListener(new ViewportListener(){

            public void zoomChanged(Envelope modelEnvelope) {
                if (!ZoomBar.this.viewBlackboard().get(CENTRE_LOCKED_KEY, false)) {
                    ZoomBar.this.viewBlackboard().put(CENTRE_KEY, null);
                }
                ZoomBar.this.viewBlackboard().put(SCALE_KEY, null);
                try {
                    if (ZoomBar.this.layerViewPanel().getViewport().getScale() < ZoomBar.this.getMinScale()) {
                        ZoomBar.this.viewBlackboard().put(USER_DEFINED_MIN_SCALE, ZoomBar.this.layerViewPanel().getViewport().getScale());
                    }
                    if (ZoomBar.this.layerViewPanel().getViewport().getScale() > ZoomBar.this.getMaxScale()) {
                        ZoomBar.this.viewBlackboard().put(USER_DEFINED_MAX_SCALE, ZoomBar.this.layerViewPanel().getViewport().getScale());
                    }
                    ZoomBar.this.updateComponents();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        });
        this.viewBlackboard().put(VIEW_LISTENERS_INSTALLED_KEY, new Object());
    }

    private void installModelListeners() {
        String MODEL_LISTENERS_INSTALLED_KEY = Integer.toHexString(this.hashCode()) + " - MODEL LISTENERS INSTALLED";
        if (this.viewBlackboard().get(MODEL_LISTENERS_INSTALLED_KEY) != null) {
            return;
        }
        if (this.layerViewPanel() == null) {
            return;
        }
        this.layerViewPanel().getLayerManager().addLayerListener(new LayerListener(){

            public void categoryChanged(CategoryEvent e) {
            }

            public void featuresChanged(FeatureEvent e) {
                if (e.getType() == FeatureEventType.ADDED || e.getType() == FeatureEventType.DELETED || e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                    ZoomBar.this.clearModelCaches();
                }
            }

            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                    ZoomBar.this.clearModelCaches();
                }
            }
        });
        this.viewBlackboard().put(MODEL_LISTENERS_INSTALLED_KEY, new Object());
    }

    private void queueComponentUpdate() {
        this.componentUpdateTimer.restart();
    }

    public void updateComponents() throws NoninvertibleTransformException {
        LayerViewPanel layerViewPanel = this.layerViewPanel();
        if (layerViewPanel == this.dummyLayerViewPanel || layerViewPanel == null) {
            this.setComponentsEnabled(false);
            return;
        }
        this.setComponentsEnabled(true);
        this.slider.setValue(this.toSliderValue(this.viewBlackboard().get(SCALE_KEY, layerViewPanel.getViewport().getScale())));
        this.updateLabel();
        this.updateSliderLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gestureFinished() throws NoninvertibleTransformException {
        if (!this.slider.isEnabled()) {
            return;
        }
        try {
            this.viewBlackboard().put(CENTRE_LOCKED_KEY, true);
            try {
                this.layerViewPanel().getViewport().zoom(this.proposedModelEnvelope());
            }
            finally {
                this.viewBlackboard().put(CENTRE_LOCKED_KEY, false);
            }
        }
        finally {
            this.layerViewPanel().getRenderingManager().setPaintingEnabled(true);
        }
    }

    private Envelope proposedModelEnvelope() throws NoninvertibleTransformException {
        double height;
        Coordinate centre = (Coordinate)this.viewBlackboard().get(CENTRE_KEY, (Object)EnvelopeUtil.centre((Envelope)this.layerViewPanel().getViewport().getEnvelopeInModelCoordinates()));
        double width = (double)this.layerViewPanel().getWidth() / this.getScale();
        Envelope proposedModelEnvelope = new Envelope(centre.x - width / 2.0, centre.x + width / 2.0, centre.y - (height = (double)this.layerViewPanel().getHeight() / this.getScale()) / 2.0, centre.y + height / 2.0);
        if (proposedModelEnvelope.getWidth() == 0.0 || proposedModelEnvelope.getHeight() == 0.0) {
            proposedModelEnvelope = this.lastGoodEnvelope;
        } else {
            this.lastGoodEnvelope = proposedModelEnvelope;
        }
        return proposedModelEnvelope;
    }

    public double getScale() throws NoninvertibleTransformException {
        return this.toScale(this.slider.getValue());
    }

    private void drawWireframe() throws NoninvertibleTransformException {
        Graphics2D g = (Graphics2D)this.layerViewPanel().getGraphics();
        g.setColor(Color.lightGray);
        g.setStroke(this.stroke);
        g.draw(this.getWireFrame());
    }

    private void clearModelCaches() {
        this.modelBlackboard().put(SEGMENT_CACHE_KEY, null);
        this.modelBlackboard().put(MIN_EXTENT_KEY, null);
        this.modelBlackboard().put(MAX_EXTENT_KEY, null);
        this.queueComponentUpdate();
    }

    private Shape getWireFrame() throws NoninvertibleTransformException {
        this.affineTransform = Viewport.modelToViewTransform(this.getScale(), new Point2D.Double(this.proposedModelEnvelope().getMinX(), this.proposedModelEnvelope().getMinY()), this.layerViewPanel().getSize().getHeight());
        Rectangle2D.Double view2D = new Rectangle2D.Double(0.0, 0.0, this.layerViewPanel().getWidth(), this.layerViewPanel().getWidth());
        GeneralPath wireFrame = new GeneralPath();
        ArrayList segments = new ArrayList(this.getSegmentCache());
        segments.addAll(this.toSegments(this.largeOnScreenGeometries()));
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            Coordinate[] coordinates = this.java2DConverter.toViewCoordinates((Coordinate[])i.next());
            boolean drawing = false;
            for (int j = 1; j < coordinates.length; ++j) {
                if (!view2D.intersectsLine(coordinates[j - 1].x, coordinates[j - 1].y, coordinates[j].x, coordinates[j].y)) {
                    drawing = false;
                    continue;
                }
                if (!drawing) {
                    wireFrame.moveTo((float)coordinates[j - 1].x, (float)coordinates[j - 1].y);
                }
                wireFrame.lineTo((float)coordinates[j].x, (float)coordinates[j].y);
                drawing = true;
            }
        }
        return wireFrame;
    }

    private Collection getSegmentCache() throws NoninvertibleTransformException {
        if (this.modelBlackboard().get(SEGMENT_CACHE_KEY) == null) {
            this.modelBlackboard().put(SEGMENT_CACHE_KEY, (Object)this.toSegments(this.largeGeometries()));
            this.frame.getActiveInternalFrame().addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    ZoomBar.this.modelBlackboard().put(SEGMENT_CACHE_KEY, null);
                }
            });
        }
        return (Collection)this.modelBlackboard().get(SEGMENT_CACHE_KEY);
    }

    private Collection toSegments(Collection geometries) {
        ArrayList segments = new ArrayList();
        for (Geometry geometry : geometries) {
            segments.addAll(CoordinateArrays.toCoordinateArrays((Geometry)geometry, (boolean)false));
        }
        return segments;
    }

    private Collection largeGeometries(int maxSize, List features) {
        Collections.sort(features, MAX_SIZE_COMPARATOR);
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        int max = Math.min(maxSize, features.size());
        for (int i = 0; i < max; ++i) {
            geometries.add(((Feature)features.get(i)).getGeometry());
        }
        return geometries;
    }

    private Collection largeOnScreenGeometries() {
        Envelope modelEnvelope;
        ArrayList onScreenFeatures = new ArrayList();
        if (this.totalGeometries() == 0) {
            return onScreenFeatures;
        }
        try {
            modelEnvelope = this.proposedModelEnvelope();
        }
        catch (NoninvertibleTransformException e) {
            modelEnvelope = this.layerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        }
        for (Layer layer : this.layerViewPanel().getLayerManager().getVisibleLayers(true)) {
            List visibleFeatures = layer.getFeatureCollectionWrapper().query(modelEnvelope);
            if (visibleFeatures.size() < 1000) {
                onScreenFeatures.addAll(layer.getFeatureCollectionWrapper().query(modelEnvelope));
                continue;
            }
            int step = visibleFeatures.size() / 1000;
            int max = visibleFeatures.size();
            for (int i = 0; i < max; i += step) {
                onScreenFeatures.add(visibleFeatures.get(i));
            }
        }
        return this.largeGeometries(200, onScreenFeatures);
    }

    private Collection largeGeometries() {
        ArrayList largeGeometries = new ArrayList();
        if (this.totalGeometries() == 0) {
            return largeGeometries;
        }
        Envelope modelEnvelope = this.layerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        for (Layer layer : this.layerViewPanel().getLayerManager().getVisibleLayers(true)) {
            List visibleFeatures = layer.getFeatureCollectionWrapper().query(modelEnvelope);
            largeGeometries.addAll(layer.getFeatureCollectionWrapper().getFeatures());
        }
        return this.largeGeometries(100, largeGeometries);
    }

    private int toSliderValue(double scale) throws NoninvertibleTransformException {
        return this.slider.getMaximum() - (int)((double)this.slider.getMaximum() * (MathUtil.base10Log((double)scale) - MathUtil.base10Log((double)this.getMinScale())) / (MathUtil.base10Log((double)this.getMaxScale()) - MathUtil.base10Log((double)this.getMinScale())));
    }

    private double getMinExtent() throws NoninvertibleTransformException {
        if (this.modelBlackboard().get(MIN_EXTENT_KEY) == null) {
            double smallSegmentLength = this.chooseSmallSegmentLength(this.getSegmentCache());
            if (smallSegmentLength == -1.0) {
                return -1.0;
            }
            this.modelBlackboard().put(MIN_EXTENT_KEY, smallSegmentLength);
        }
        Assert.isTrue((this.modelBlackboard().getDouble(MIN_EXTENT_KEY) > 0.0 ? 1 : 0) != 0);
        return this.modelBlackboard().getDouble(MIN_EXTENT_KEY);
    }

    private double chooseSmallSegmentLength(Collection segmentCache) {
        int segmentsChecked = 0;
        double smallSegmentLength = -1.0;
        for (Coordinate[] coordinates : segmentCache) {
            for (int j = 1; j < coordinates.length; ++j) {
                double segmentLength = coordinates[j].distance(coordinates[j - 1]);
                ++segmentsChecked;
                if (segmentLength > 0.0 && (smallSegmentLength == -1.0 || segmentLength < smallSegmentLength)) {
                    smallSegmentLength = segmentLength;
                }
                if (segmentsChecked > 100) break;
            }
            if (segmentsChecked <= 100) continue;
            break;
        }
        return smallSegmentLength;
    }

    private double getMaxExtent() throws NoninvertibleTransformException {
        if (this.modelBlackboard().get(MAX_EXTENT_KEY) == null) {
            if (this.getSegmentCache().isEmpty()) {
                return -1.0;
            }
            this.modelBlackboard().put(MAX_EXTENT_KEY, this.layerViewPanel().getLayerManager().getEnvelopeOfAllLayers().getWidth());
        }
        return this.modelBlackboard().getDouble(MAX_EXTENT_KEY);
    }

    private double getMaxScale() throws NoninvertibleTransformException {
        double maxScale;
        double d = maxScale = this.getMinExtent() == -1.0 || this.getMinExtent() == 0.0 ? 1000.0 : (double)(1000 * this.layerViewPanel().getWidth()) / this.getMinExtent();
        if (this.viewBlackboard().get(USER_DEFINED_MAX_SCALE) != null) {
            return Math.max(maxScale, this.viewBlackboard().getDouble(USER_DEFINED_MAX_SCALE));
        }
        return maxScale;
    }

    private double getMinScale() throws NoninvertibleTransformException {
        double minScale;
        double d = minScale = this.getMaxExtent() == -1.0 || this.getMaxExtent() == 0.0 ? 0.001 : 0.001 * (double)this.layerViewPanel().getWidth() / this.getMaxExtent();
        if (this.viewBlackboard().get(USER_DEFINED_MIN_SCALE) != null) {
            return Math.min(minScale, this.viewBlackboard().getDouble(USER_DEFINED_MIN_SCALE));
        }
        return minScale;
    }

    private double toScale(int sliderValue) throws NoninvertibleTransformException {
        return Math.pow(10.0, (double)(this.slider.getMaximum() - sliderValue) * (MathUtil.base10Log((double)this.getMaxScale()) - MathUtil.base10Log((double)this.getMinScale())) / (double)this.slider.getMaximum() + MathUtil.base10Log((double)this.getMinScale()));
    }

    private void setComponentsEnabled(boolean componentsEnabled) {
        this.slider.setEnabled(componentsEnabled);
        this.label.setEnabled(componentsEnabled);
    }

    private Blackboard viewBlackboard() {
        return this.layerViewPanel() != null ? this.layerViewPanel().getBlackboard() : new Blackboard();
    }

    private Blackboard modelBlackboard() {
        return this.layerViewPanel().getLayerManager().getBlackboard();
    }

    private LayerViewPanel layerViewPanel() {
        if (!(this.frame.getActiveInternalFrame() instanceof LayerViewPanelProxy)) {
            return this.dummyLayerViewPanel;
        }
        return ((LayerViewPanelProxy)((Object)this.frame.getActiveInternalFrame())).getLayerViewPanel();
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.label.setText(" ");
        this.slider.setPaintLabels(true);
        this.slider.setToolTipText(I18N.get((String)"ui.zoom.ZoomBar.zoom"));
        this.slider.setMaximum(1000);
        this.add((Component)this.slider, "Center");
        this.add((Component)this.label, "East");
    }

    private void updateLabel() throws NoninvertibleTransformException {
        this.label.setText(this.chooseGoodIncrement(this.getScale()).toString());
    }

    private RoundQuantity chooseGoodIncrement(double scale) {
        return this.incrementChooser.chooseGoodIncrement(this.metricUnits, (double)this.layerViewPanel().getWidth() / scale);
    }

    private void updateSliderLabels() throws NoninvertibleTransformException {
        if (!this.showingSliderLabels) {
            return;
        }
        if (!(this.slider.getUI() instanceof BasicSliderUI)) {
            return;
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int LABEL_WIDTH = 60;
        int lastLabelPosition = -120;
        for (int i = 0; i < this.slider.getWidth(); ++i) {
            if (i < lastLabelPosition + 60) continue;
            int sliderValue = ((BasicSliderUI)this.slider.getUI()).valueForXPosition(i);
            JLabel label = new JLabel(this.chooseGoodIncrement(this.toScale(sliderValue)).toString());
            label.setFont(this.sliderLabelFont);
            labelTable.put(new Integer(sliderValue), label);
            lastLabelPosition = i;
        }
        if (labelTable.isEmpty()) {
            return;
        }
        this.slider.setLabelTable(labelTable);
    }

    public Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        Point2D.Double pt = new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
        return this.affineTransform.transform(pt, pt);
    }
}

