/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.wizard;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.CancelNextException;
import com.vividsolutions.jump.workbench.ui.wizard.WizardContext;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openjump.swing.listener.InvokeMethodActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardDialog
extends JDialog
implements WizardContext,
InputChangedListener {
    private List<WizardPanel> completedWizardPanels = new ArrayList<WizardPanel>();
    private JButton cancelButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton backButton = new JButton();
    private JPanel centerPanel = new JPanel();
    private JLabel titleLabel = new JLabel();
    private CardLayout cardLayout = new CardLayout();
    private WizardPanel currentWizardPanel;
    private List<WizardPanel> allWizardPanels = new ArrayList<WizardPanel>();
    private ErrorHandler errorHandler;
    private JTextArea instructionTextArea = new JTextArea();
    private boolean finishPressed = false;
    private HashMap dataMap = new HashMap();

    public WizardDialog(Frame frame, String title, ErrorHandler errorHandler) {
        super(frame, title, true);
        this.errorHandler = errorHandler;
        this.jbInit();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WizardDialog.this.cancel();
            }
        });
    }

    private void checkIDs(Collection wizardPanels) {
        ArrayList<String> ids = new ArrayList<String>();
        for (WizardPanel panel : wizardPanels) {
            ids.add(panel.getID());
        }
        for (WizardPanel panel : wizardPanels) {
            if (panel.getNextID() == null) continue;
            Assert.isTrue((boolean)ids.contains(panel.getNextID()), (String)(I18N.get((String)"ui.wizard.WizardDialog.required-panel-missing") + " " + panel.getNextID()));
        }
    }

    private void setCurrentWizardPanel(WizardPanel wizardPanel) {
        if (this.currentWizardPanel != null) {
            this.currentWizardPanel.remove(this);
        }
        this.titleLabel.setText(wizardPanel.getTitle());
        this.cardLayout.show(this.centerPanel, wizardPanel.getID());
        this.currentWizardPanel = wizardPanel;
        this.updateButtons();
        this.currentWizardPanel.add(this);
        this.instructionTextArea.setText(this.currentWizardPanel.getInstructions());
    }

    public WizardPanel setCurrentWizardPanel(String id) {
        WizardPanel panel = this.find(id);
        panel.enteredFromLeft(this.dataMap);
        this.setCurrentWizardPanel(panel);
        return panel;
    }

    private WizardPanel getCurrentWizardPanel() {
        return this.currentWizardPanel;
    }

    private void updateButtons() {
        this.backButton.setEnabled(!this.completedWizardPanels.isEmpty());
        this.nextButton.setEnabled(this.getCurrentWizardPanel().isInputValid());
        this.nextButton.setText(this.getCurrentWizardPanel().getNextID() == null ? I18N.get((String)"ui.wizard.WizardDialog.finish") : I18N.get((String)"ui.wizard.WizardDialog.next") + " >");
    }

    @Override
    public void inputChanged() {
        this.updateButtons();
    }

    public void init(WizardPanel[] wizardPanels) {
        List<WizardPanel> panels = Arrays.asList(wizardPanels);
        this.init(panels);
    }

    protected void setPanels(List<WizardPanel> wizardPanels) {
        this.allWizardPanels.clear();
        this.allWizardPanels.addAll(wizardPanels);
        this.completedWizardPanels.clear();
        this.checkIDs(this.allWizardPanels);
        for (WizardPanel wizardPanel : wizardPanels) {
            this.centerPanel.add((Component)((Object)wizardPanel), wizardPanel.getID());
        }
    }

    public void init(List<WizardPanel> wizardPanels) {
        this.setPanels(wizardPanels);
        WizardPanel firstPanel = wizardPanels.get(0);
        firstPanel.enteredFromLeft(this.dataMap);
        this.setCurrentWizardPanel(firstPanel);
        this.pack();
    }

    private void jbInit() {
        Container contentPane = this.getContentPane();
        JPanel titlePanel = new JPanel(new GridLayout(2, 1));
        titlePanel.setBackground(Color.white);
        titlePanel.setForeground(Color.black);
        this.add((Component)titlePanel, "North");
        this.titleLabel.setFont(new Font("Dialog", 1, 12));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.titleLabel.setOpaque(false);
        this.titleLabel.setText("Title");
        titlePanel.add(this.titleLabel);
        this.instructionTextArea.setFont(new JLabel().getFont());
        this.instructionTextArea.setEnabled(false);
        this.instructionTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 3, 5));
        this.instructionTextArea.setOpaque(false);
        this.instructionTextArea.setToolTipText("");
        this.instructionTextArea.setDisabledTextColor(this.instructionTextArea.getForeground());
        this.instructionTextArea.setEditable(false);
        this.instructionTextArea.setLineWrap(true);
        this.instructionTextArea.setWrapStyleWord(true);
        this.instructionTextArea.setText("instructionTextArea");
        titlePanel.add(this.instructionTextArea);
        this.centerPanel.setLayout(this.cardLayout);
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        contentPane.add((Component)this.centerPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 3, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        contentPane.add((Component)buttonPanel, "South");
        this.backButton.setText("< " + I18N.get((String)"ui.wizard.WizardDialog.back"));
        this.backButton.addActionListener((ActionListener)new InvokeMethodActionListener((Object)this, "previous"));
        buttonPanel.add(this.backButton);
        this.nextButton.setText(I18N.get((String)"ui.wizard.WizardDialog.next") + " >");
        this.nextButton.addActionListener((ActionListener)new InvokeMethodActionListener((Object)this, "next"));
        buttonPanel.add(this.nextButton);
        this.getRootPane().setDefaultButton(this.nextButton);
        JLabel spacer = new JLabel();
        spacer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        buttonPanel.add(spacer);
        this.cancelButton.setText(I18N.get((String)"ui.wizard.WizardDialog.cancel"));
        this.cancelButton.addActionListener((ActionListener)new InvokeMethodActionListener((Object)this, "cancel"));
        buttonPanel.add(this.cancelButton);
        this.setDefaultCloseOperation(0);
    }

    public void cancel() {
        this.finishPressed = false;
        this.setVisible(false);
    }

    public void next() {
        try {
            this.getCurrentWizardPanel().exitingToRight();
            if (this.getCurrentWizardPanel().getNextID() == null) {
                this.finishPressed = true;
                this.setVisible(false);
                return;
            }
            this.completedWizardPanels.add(this.getCurrentWizardPanel());
            WizardPanel nextWizardPanel = this.find(this.getCurrentWizardPanel().getNextID());
            nextWizardPanel.enteredFromLeft(this.dataMap);
            this.setCurrentWizardPanel(nextWizardPanel);
        }
        catch (CancelNextException e) {
        }
        catch (Throwable x) {
            this.errorHandler.handleThrowable(x);
        }
    }

    private WizardPanel find(String id) {
        for (WizardPanel wizardPanel : this.allWizardPanels) {
            if (!wizardPanel.getID().equals(id)) continue;
            return wizardPanel;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public boolean wasFinishPressed() {
        return this.finishPressed;
    }

    public void previous() {
        WizardPanel prevPanel = this.completedWizardPanels.remove(this.completedWizardPanels.size() - 1);
        this.setCurrentWizardPanel(prevPanel);
    }

    @Override
    public void setData(String name, Object value) {
        this.dataMap.put(name, value);
    }

    @Override
    public Object getData(String name) {
        return this.dataMap.get(name);
    }
}

