/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.snap.GridRenderer;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SnapOptionsPanel
extends JPanel
implements OptionsPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel jPanel2 = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TitledBorder titledBorder1;
    private JCheckBox snapToFeaturesCheckBox = new JCheckBox();
    private JCheckBox snapToVerticesCheckBox = new JCheckBox();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JCheckBox snapToGridCheckBox = new JCheckBox();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel jPanel5 = new JPanel();
    private Border border2;
    private TitledBorder titledBorder2;
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JTextField gridSizeTextField = new JTextField(7);
    private JPanel jPanel7 = new JPanel();
    private JRadioButton showGridDotsRadioButton = new JRadioButton();
    private JRadioButton showGridLinesRadioButton = new JRadioButton();
    private JPanel jPanel6 = new JPanel();
    private Blackboard blackboard;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ValidatingTextField toleranceTextField = new ValidatingTextField("", 3, 4, new ValidatingTextField.BoundedIntValidator(0, 100), ValidatingTextField.DUMMY_CLEANER);
    private JCheckBox showGridCheckBox = new JCheckBox();
    private JPanel tolerancePanel = new JPanel();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private JLabel toleranceLabel = new JLabel();
    private JLabel toleranceUnitsLabel = new JLabel();
    private JLabel showGridUnitsLabel = new JLabel();

    public SnapOptionsPanel(Blackboard blackboard) {
        this.blackboard = blackboard;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        this.buttonGroup.add(this.showGridDotsRadioButton);
        this.buttonGroup.add(this.showGridLinesRadioButton);
        this.snapToFeaturesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnapOptionsPanel.this.updateEnabled();
            }
        });
    }

    private void updateEnabled() {
        this.snapToVerticesCheckBox.setEnabled(!this.snapToFeaturesCheckBox.isSelected());
        this.gridSizeTextField.setEnabled(this.showGridCheckBox.isSelected());
        this.showGridDotsRadioButton.setEnabled(this.showGridCheckBox.isSelected());
        this.showGridLinesRadioButton.setEnabled(this.showGridCheckBox.isSelected());
    }

    public String validateInput() {
        String errorMessage = "\"" + this.gridSizeTextField.getText() + "\" " + I18N.get((String)"ui.snap.SnapOptionsPanel.is-not-a-valid-grid-size");
        try {
            if (Double.parseDouble(this.gridSizeTextField.getText()) <= 0.0) {
                return errorMessage;
            }
        }
        catch (NumberFormatException e) {
            return errorMessage;
        }
        return null;
    }

    public void okPressed() {
        this.blackboard.put(SnapToVerticesPolicy.ENABLED_KEY, this.snapToVerticesCheckBox.isSelected());
        SnapManager.setToleranceInPixels(this.toleranceTextField.getInteger(), this.blackboard);
        this.blackboard.put(SnapToFeaturesPolicy.ENABLED_KEY, this.snapToFeaturesCheckBox.isSelected());
        this.blackboard.put(SnapToGridPolicy.ENABLED_KEY, this.snapToGridCheckBox.isSelected());
        this.blackboard.put(SnapToGridPolicy.GRID_SIZE_KEY, Double.parseDouble(this.gridSizeTextField.getText()));
        this.blackboard.put(GridRenderer.DOTS_ENABLED_KEY, this.showGridDotsRadioButton.isSelected());
        this.blackboard.put(GridRenderer.LINES_ENABLED_KEY, this.showGridLinesRadioButton.isSelected());
        this.blackboard.put(GridRenderer.ENABLED_KEY, this.showGridCheckBox.isSelected());
    }

    public void init() {
        this.snapToVerticesCheckBox.setSelected(this.blackboard.get(SnapToVerticesPolicy.ENABLED_KEY, false));
        this.toleranceTextField.setText("" + SnapManager.getToleranceInPixels(this.blackboard));
        this.snapToFeaturesCheckBox.setSelected(this.blackboard.get(SnapToFeaturesPolicy.ENABLED_KEY, false));
        this.snapToGridCheckBox.setSelected(this.blackboard.get(SnapToGridPolicy.ENABLED_KEY, false));
        this.gridSizeTextField.setText("" + this.blackboard.get(SnapToGridPolicy.GRID_SIZE_KEY, 20.0));
        this.showGridCheckBox.setSelected(this.blackboard.get(GridRenderer.ENABLED_KEY, false));
        this.showGridDotsRadioButton.setSelected(this.blackboard.get(GridRenderer.DOTS_ENABLED_KEY, false));
        this.showGridLinesRadioButton.setSelected(this.blackboard.get(GridRenderer.LINES_ENABLED_KEY, true));
        this.updateEnabled();
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), I18N.get((String)"ui.snap.SnapOptionsPanel.snapping"));
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border2, I18N.get((String)"ui.snap.SnapOptionsPanel.grid-display"));
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel2.setBorder(this.titledBorder1);
        this.snapToFeaturesCheckBox.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.snap-to-vertices-and-lines"));
        this.snapToVerticesCheckBox.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.snap-to-vertices"));
        this.snapToGridCheckBox.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.snap-to-grid"));
        this.jPanel4.setLayout(this.gridBagLayout3);
        this.jPanel5.setBorder(this.titledBorder2);
        this.jPanel5.setLayout(this.gridBagLayout4);
        this.gridSizeTextField.setText("20");
        this.gridSizeTextField.setHorizontalAlignment(11);
        this.jPanel7.setLayout(this.gridBagLayout6);
        this.showGridDotsRadioButton.setSelected(true);
        this.showGridDotsRadioButton.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.show-grid-as-dots"));
        this.showGridLinesRadioButton.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.show-grid-as-lines"));
        this.showGridCheckBox.setToolTipText("");
        this.showGridCheckBox.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.show-grid-size"));
        this.showGridCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SnapOptionsPanel.this.showGridCheckBox_actionPerformed(e);
            }
        });
        this.tolerancePanel.setLayout(this.gridBagLayout5);
        this.toleranceLabel.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.tolerance"));
        this.toleranceUnitsLabel.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.pixels"));
        this.showGridUnitsLabel.setText(I18N.get((String)"ui.snap.SnapOptionsPanel.model-units"));
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanel2.add((Component)this.snapToFeaturesCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.snapToVerticesCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.snapToGridCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tolerancePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tolerancePanel.add((Component)this.toleranceLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.tolerancePanel.add((Component)this.toleranceTextField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.tolerancePanel.add((Component)this.toleranceUnitsLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.jPanel5.add((Component)this.jPanel7, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.gridSizeTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel7.add((Component)this.showGridCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.showGridDotsRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.showGridLinesRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.showGridUnitsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void showGridCheckBox_actionPerformed(ActionEvent e) {
        this.updateEnabled();
    }
}

