/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style.attributeclassifications;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RangeColorThemingState
implements ColorThemingStylePanel.State {
    private ColorThemingStylePanel stylePanel;
    private static final String RANGE_COUNT_KEY = RangeColorThemingState.class.getName() + " - RANGE COUNT";
    private JPanel panel = new JPanel(new GridBagLayout()){

        public void setEnabled(boolean enabled) {
            RangeColorThemingState.this.comboBox.setEnabled(enabled);
            RangeColorThemingState.this.label.setEnabled(enabled);
            RangeColorThemingState.this.reverseButton.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    };
    private JButton reverseButton = new JButton(I18N.get((String)"ui.renderer.style.RangeColorThemingState.reverse-colors"));
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private JComboBox comboBox = new JComboBox(this.comboBoxModel);
    private JLabel label = new JLabel(I18N.get((String)"ui.renderer.style.RangeColorThemingState.range-count"));
    private TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e instanceof ColorThemingTableModel.AttributeValueTableModelEvent) {
                RangeColorThemingState.this.stylePanel.tableModel().sort(RangeColorThemingState.this.stylePanel.tableModel().wasLastSortAscending());
            }
        }
    };
    private boolean reversingColorScheme = false;

    public String getAllOtherValuesDescription() {
        return I18N.get((String)"ui.renderer.style.RangeColorThemingState.values-below-these-values");
    }

    public String getAttributeValueColumnTitle() {
        return I18N.get((String)"ui.renderer.style.RangeColorThemingState.minimum-attribute-values");
    }

    private int getRangeCount() {
        return (Integer)this.comboBox.getSelectedItem();
    }

    public Collection filterAttributeValues(SortedSet attributeValues) {
        int maxFilteredSize = this.getRangeCount() - 1;
        ArrayList attributeValueList = new ArrayList(attributeValues);
        TreeSet<Number> filteredValues = new TreeSet<Number>();
        double min = ((Number)attributeValues.first()).doubleValue();
        double max = ((Number)attributeValues.last()).doubleValue();
        double range = max - min;
        for (int i = 0; i < maxFilteredSize; ++i) {
            double threshold = min + range * (double)i / (double)maxFilteredSize;
            if (attributeValues.first() instanceof Double) {
                filteredValues.add(attributeValues.tailSet(new Double(threshold)).first());
                continue;
            }
            if (!(attributeValues.first() instanceof Integer)) continue;
            filteredValues.add(attributeValues.tailSet(new Integer((int)threshold)).first());
        }
        return filteredValues;
    }

    public RangeColorThemingState(final ColorThemingStylePanel stylePanel) {
        this.stylePanel = stylePanel;
        this.addComboBoxItems();
        this.comboBox.setSelectedItem(stylePanel.getLayer().getLayerManager().getBlackboard().get(RANGE_COUNT_KEY, (Object)new Integer(5)));
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                stylePanel.populateTable();
                stylePanel.getLayer().getLayerManager().getBlackboard().put(RANGE_COUNT_KEY, RangeColorThemingState.this.comboBox.getSelectedItem());
            }
        });
        this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.comboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.reverseButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.reverseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RangeColorThemingState.this.reversingColorScheme = !RangeColorThemingState.this.reversingColorScheme;
                stylePanel.applyColorScheme();
            }
        });
    }

    private void addComboBoxItems() {
        int maxColorSchemeSize = -1;
        for (String rangeColorSchemeName : ColorScheme.rangeColorSchemeNames()) {
            maxColorSchemeSize = Math.max(maxColorSchemeSize, ColorScheme.create(rangeColorSchemeName).getColors().size());
        }
        for (int i = 3; i <= maxColorSchemeSize; ++i) {
            this.comboBoxModel.addElement(new Integer(i));
        }
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public Map fromExternalFormat(Map attributeValueToObjectMap) {
        TreeMap newMap = new TreeMap();
        for (Range range : attributeValueToObjectMap.keySet()) {
            newMap.put(range.getMin(), attributeValueToObjectMap.get(range));
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map toExternalFormat(Map attributeValueToObjectMap) {
        if (attributeValueToObjectMap.isEmpty()) {
            return attributeValueToObjectMap;
        }
        Assert.isTrue((boolean)(attributeValueToObjectMap instanceof SortedMap));
        Range.RangeTreeMap newMap = new Range.RangeTreeMap();
        Object previousValue = null;
        for (Object value : attributeValueToObjectMap.keySet()) {
            try {
                if (previousValue == null) continue;
                newMap.put(new Range(previousValue, true, value, false), attributeValueToObjectMap.get(previousValue));
            }
            finally {
                previousValue = value;
            }
        }
        newMap.put(new Range(previousValue, true, (Object)new Range.PositiveInfinity(), false), attributeValueToObjectMap.get(previousValue));
        return newMap;
    }

    public void applyColorScheme(ColorScheme colorScheme) {
        this.stylePanel.tableModel().apply(new ColorScheme(null, CollectionUtil.stretch((Collection)colorScheme.getColors(), new ArrayList(), (int)this.stylePanel.tableModel().getRowCount())), false);
    }

    public Collection getColorSchemeNames() {
        return ColorScheme.rangeColorSchemeNames();
    }

    private int row(Object attributeValue) {
        for (int i = 0; i < this.stylePanel.tableModel().getRowCount(); ++i) {
            Object otherAttributeValue = this.stylePanel.tableModel().getValueAt(i, 1);
            if (attributeValue == null && otherAttributeValue == null) {
                return i;
            }
            if (attributeValue == null || !attributeValue.equals(otherAttributeValue)) continue;
            return i;
        }
        Assert.shouldNeverReachHere();
        return -1;
    }

    public void activate() {
        this.stylePanel.tableModel().addTableModelListener(this.tableModelListener);
    }

    public void deactivate() {
        this.stylePanel.tableModel().removeTableModelListener(this.tableModelListener);
    }

    public ColorScheme filterColorScheme(ColorScheme colorScheme) {
        if (!this.reversingColorScheme) {
            return colorScheme;
        }
        ArrayList colors = new ArrayList(colorScheme.getColors());
        Collections.reverse(colors);
        return new ColorScheme(colorScheme.getName(), colors);
    }
}

