/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;

public class WMSLayerRenderer
extends ImageCachingRenderer {
    public WMSLayerRenderer(WMSLayer layer, LayerViewPanel panel) {
        super(layer, panel);
    }

    public ThreadSafeImage getImage() {
        if (!this.getLayer().isVisible()) {
            return null;
        }
        return super.getImage();
    }

    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.getLayer(), this.panel)) {
            return null;
        }
        return super.createRunnable();
    }

    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.getLayer(), this.panel)) {
            return;
        }
        super.copyTo(graphics);
    }

    private WMSLayer getLayer() {
        return (WMSLayer)this.getContentID();
    }

    protected void renderHook(ThreadSafeImage image) throws Exception {
        if (!this.getLayer().isVisible()) {
            return;
        }
        final Image sourceImage = this.getLayer().createImage(this.panel);
        if (this.cancelled) {
            return;
        }
        image.draw(new ThreadSafeImage.Drawer(){

            public void draw(Graphics2D g) throws Exception {
                g.setComposite(AlphaComposite.getInstance(3, (float)WMSLayerRenderer.this.getLayer().getAlpha() / 255.0f));
                g.drawImage(sourceImage, 0, 0, null);
            }
        });
    }
}

