/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AddDatastoreLayerPanel
extends ConnectionPanel {
    private JTextArea whereTextArea = null;
    private JComboBox geometryAttributeComboBox = null;
    private JComboBox datasetComboBox = null;
    private Map connectionDescriptorToDatasetNamesMap = new HashMap();
    private JCheckBox cachingCheckBox = null;

    public AddDatastoreLayerPanel() {
        super((WorkbenchContext)null);
    }

    public AddDatastoreLayerPanel(WorkbenchContext context) {
        super(context);
        this.initialize();
        this.getConnectionComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddDatastoreLayerPanel.this.getDatasetComboBox().setSelectedItem(null);
            }
        });
    }

    public static Object runInKillableThread(final String description, WorkbenchContext context, final Block block) {
        final Object[] result = new Object[]{null};
        AbstractPlugIn.toActionListener(new ThreadedBasePlugIn(){

            public String getName() {
                return description;
            }

            public boolean execute(PlugInContext context) throws Exception {
                return true;
            }

            public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
                monitor.report(description);
                result[0] = block.yield();
            }
        }, context, new TaskMonitorManager()).actionPerformed(null);
        return result[0];
    }

    public String getDatasetName() {
        return this.datasetComboBox.getSelectedItem() != null ? ((String)this.datasetComboBox.getSelectedItem()).trim() : null;
    }

    public String getGeometryAttributeName() {
        return this.geometryAttributeComboBox.getSelectedItem() != null ? ((String)this.geometryAttributeComboBox.getSelectedItem()).trim() : null;
    }

    public String getWhereClause() {
        return this.getWhereClauseProper().toLowerCase().startsWith("where") ? this.getWhereClauseProper().substring("where".length()).trim() : this.getWhereClauseProper();
    }

    public String getWhereClauseProper() {
        return this.whereTextArea.getText().trim();
    }

    public boolean isCaching() {
        return this.getCachingCheckBox().isSelected();
    }

    public void setCaching(boolean caching) {
        this.getCachingCheckBox().setSelected(caching);
    }

    public String validateInput() {
        if (super.validateInput() != null) {
            return super.validateInput();
        }
        if (((String)LangUtil.ifNull((Object)this.getDatasetName(), (Object)"")).length() == 0) {
            return I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Required-field-missing-Dataset");
        }
        if (((String)LangUtil.ifNull((Object)this.getGeometryAttributeName(), (Object)"")).length() == 0) {
            return I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Required-field-missing-Geometry");
        }
        return null;
    }

    private JTextArea getWhereTextArea() {
        if (this.whereTextArea == null) {
            this.whereTextArea = new JTextArea();
        }
        return this.whereTextArea;
    }

    private JComboBox getDatasetComboBox() {
        if (this.datasetComboBox == null) {
            this.datasetComboBox = new JComboBox();
            this.datasetComboBox.setPreferredSize(new Dimension(400, (int)this.datasetComboBox.getPreferredSize().getHeight()));
            this.datasetComboBox.setEditable(true);
            this.datasetComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AddDatastoreLayerPanel.this.populateGeometryAttributeComboBox();
                    if (AddDatastoreLayerPanel.this.geometryAttributeComboBox.getItemCount() > 0) {
                        AddDatastoreLayerPanel.this.geometryAttributeComboBox.setSelectedIndex(0);
                    }
                }
            });
            this.addSafePopupListener(this.datasetComboBox, new Block(){

                public Object yield() throws Exception {
                    AddDatastoreLayerPanel.this.populateDatasetComboBox();
                    return null;
                }
            });
        }
        return this.datasetComboBox;
    }

    private JComboBox getGeometryAttributeComboBox() {
        if (this.geometryAttributeComboBox == null) {
            this.geometryAttributeComboBox = new JComboBox();
            this.geometryAttributeComboBox.setPreferredSize(new Dimension(400, (int)this.geometryAttributeComboBox.getPreferredSize().getHeight()));
            this.geometryAttributeComboBox.setEditable(true);
            this.addSafePopupListener(this.geometryAttributeComboBox, new Block(){

                public Object yield() throws Exception {
                    AddDatastoreLayerPanel.this.populateGeometryAttributeComboBox();
                    return null;
                }
            });
        }
        return this.geometryAttributeComboBox;
    }

    private JCheckBox getCachingCheckBox() {
        if (this.cachingCheckBox == null) {
            this.cachingCheckBox = new JCheckBox();
            this.cachingCheckBox.setText(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Cache-features"));
            String s1 = I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Prevents-unnecessary-queries-to-the-datastore");
            String s2 = I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.The-recommended-setting-is-to-leave-this-checked");
            this.cachingCheckBox.setToolTipText("<html>" + s1 + "<br>" + s2 + "</html>");
            this.cachingCheckBox.setSelected(true);
        }
        return this.cachingCheckBox;
    }

    private void populateGeometryAttributeComboBox() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        if (this.getDatasetName() == null) {
            return;
        }
        if (this.getDatasetName().length() == 0) {
            return;
        }
        try {
            String selectedGeometryAttributeName = this.getGeometryAttributeName();
            this.geometryAttributeComboBox.setModel(new DefaultComboBoxModel<Object>(this.sortByString(this.geometryAttributeNames(this.getDatasetName(), this.getConnectionDescriptor()))));
            this.geometryAttributeComboBox.setSelectedItem(selectedGeometryAttributeName);
        }
        catch (Exception e) {
            this.getContext().getErrorHandler().handleThrowable(e);
            this.geometryAttributeComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private void populateDatasetComboBox() {
        if (this.getConnectionDescriptor() == null) {
            return;
        }
        try {
            String selectedDatasetName = this.getDatasetName();
            this.datasetComboBox.setModel(new DefaultComboBoxModel<Object>(this.sortByString(this.datasetNames(this.getConnectionDescriptor()))));
            this.datasetComboBox.setSelectedItem(selectedDatasetName);
        }
        catch (Exception e) {
            this.getContext().getErrorHandler().handleThrowable(e);
            this.datasetComboBox.setModel(new DefaultComboBoxModel());
        }
    }

    private String[] geometryAttributeNames(final String datasetName, final ConnectionDescriptor connectionDescriptor) throws Exception {
        new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
        return (String[])AddDatastoreLayerPanel.runInKillableThread(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Retrieving-list-of-geometry-attributes"), this.getContext(), new Block(){

            public Object yield() throws Exception {
                try {
                    return new PasswordPrompter().getOpenConnection(AddDatastoreLayerPanel.this.connectionManager(), connectionDescriptor, AddDatastoreLayerPanel.this).getMetadata().getGeometryAttributeNames(datasetName);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    return new String[0];
                }
            }
        });
    }

    private String[] datasetNames(final ConnectionDescriptor connectionDescriptor) throws Exception {
        if (!this.connectionDescriptorToDatasetNamesMap.containsKey(connectionDescriptor)) {
            new PasswordPrompter().getOpenConnection(this.connectionManager(), connectionDescriptor, this);
            String[] datasetNames = (String[])AddDatastoreLayerPanel.runInKillableThread(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Retrieving-list-of-datasets"), this.getContext(), new Block(){

                public Object yield() throws Exception {
                    return new PasswordPrompter().getOpenConnection(AddDatastoreLayerPanel.this.connectionManager(), connectionDescriptor, AddDatastoreLayerPanel.this).getMetadata().getDatasetNames();
                }
            });
            if (datasetNames.length != 0) {
                this.connectionDescriptorToDatasetNamesMap.put(connectionDescriptor, datasetNames);
            }
        }
        return (String[])this.connectionDescriptorToDatasetNamesMap.get(connectionDescriptor);
    }

    private void initialize() {
        JScrollPane sp = new JScrollPane(this.getWhereTextArea());
        sp.setPreferredSize(new Dimension(400, 100));
        this.addRow(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Dataset"), this.getDatasetComboBox(), null, false);
        this.addRow(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Geometry"), this.getGeometryAttributeComboBox(), null, false);
        this.addRow(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Where"), sp, null, true);
        this.addRow(I18N.get((String)"jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Caching"), this.getCachingCheckBox(), null, false);
    }

    private void addSafePopupListener(final JComboBox comboBox, final Block listener) {
        comboBox.addPopupMenuListener(new PopupMenuListener(){
            private boolean ignoringPopupEvent = false;

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (this.ignoringPopupEvent) {
                    this.ignoringPopupEvent = false;
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        comboBox.hidePopup();
                        try {
                            listener.yield();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            ignoringPopupEvent = true;
                            comboBox.showPopup();
                        }
                    }
                });
            }
        });
    }

    public static interface Block {
        public Object yield() throws Exception;
    }
}

