/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.linemerge.LineSequencer;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jump.I18N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class GeometryFunction {
    private static GeometryFunction[] method = new GeometryFunction[]{new IntersectionFunction(), new UnionFunction(), new DifferenceABFunction(), new DifferenceBAFunction(), new SymDifferenceFunction(), new CentroidFunction(), new InteriorPointFunction(), new BufferFunction(), new SimplifyFunction(), new SimplifyTopologyFunction(), new ConvexHullFunction(), new BoundaryFunction(), new EnvelopeFunction(), new LineMergeFunction(), new LineSequenceFunction(), new PolygonizeFunction(), new ReverseLinestringFunction()};
    private String name;
    private int nArguments;
    private int nParams;
    private boolean isAggregate = false;
    private String description;

    public static List getNames() {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (int i = 0; i < method.length; ++i) {
            methodNames.add(GeometryFunction.method[i].name);
        }
        return methodNames;
    }

    public static List getNames(Collection functions) {
        ArrayList<String> names = new ArrayList<String>();
        for (GeometryFunction func : functions) {
            names.add(func.name);
        }
        return names;
    }

    public static GeometryFunction getFunction(String name) {
        for (int i = 0; i < method.length; ++i) {
            if (!GeometryFunction.method[i].name.equals(name)) continue;
            return method[i];
        }
        return null;
    }

    public static GeometryFunction getFunction(Collection functions, String name) {
        for (GeometryFunction func : functions) {
            if (!func.name.equals(name)) continue;
            return func;
        }
        return null;
    }

    public static GeometryFunction[] getFunctions() {
        return method;
    }

    public String getName() {
        return this.name;
    }

    public int getGeometryArgumentCount() {
        return this.nArguments;
    }

    public int getParameterCount() {
        return this.nParams;
    }

    public GeometryFunction(String name, int nArgs, int nParams) {
        this(name, nArgs, nParams, name + " " + I18N.get((String)"ui.plugin.analysis.GeometryFunctionPlugIn.function"));
    }

    public GeometryFunction(String name, int nArgs, int nParams, String description) {
        this.name = name;
        this.nArguments = nArgs;
        this.nParams = nParams;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract Geometry execute(Geometry[] var1, double[] var2);

    public String toString() {
        return this.name;
    }

    private static class ReverseLinestringFunction
    extends GeometryFunction {
        public ReverseLinestringFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Reverse-Line-Direction"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            if (geom[0] instanceof LineString) {
                Coordinate[] a = geom[0].getCoordinates();
                CoordinateArrays.reverse((Coordinate[])a);
                LineString invLine = new GeometryFactory().createLineString(a);
                return invLine;
            }
            if (geom[0] instanceof Polygon) {
                Polygon p = (Polygon)geom[0];
                Coordinate[] outer = p.getExteriorRing().getCoordinates();
                CoordinateArrays.reverse((Coordinate[])outer);
                LinearRing outLine = new GeometryFactory().createLinearRing(outer);
                LinearRing[] innerR = null;
                if (p.getNumInteriorRing() > 0) {
                    innerR = new LinearRing[p.getNumInteriorRing()];
                    for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                        Coordinate[] inner = p.getInteriorRingN(i).getCoordinates();
                        CoordinateArrays.reverse((Coordinate[])inner);
                        innerR[i] = new GeometryFactory().createLinearRing(inner);
                    }
                }
                Polygon pout = new GeometryFactory().createPolygon(outLine, innerR);
                return pout;
            }
            return geom[0];
        }
    }

    private static class PolygonizeFunction
    extends GeometryFunction {
        public PolygonizeFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Polygonize"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            Polygonizer polygonizer = new Polygonizer();
            polygonizer.add(geom[0]);
            Collection polyColl = polygonizer.getPolygons();
            return geom[0].getFactory().buildGeometry(polyColl);
        }
    }

    private static class LineSequenceFunction
    extends GeometryFunction {
        public LineSequenceFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Line-Sequence"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            LineSequencer sequencer = new LineSequencer();
            sequencer.add(geom[0]);
            return sequencer.getSequencedLineStrings();
        }
    }

    private static class LineMergeFunction
    extends GeometryFunction {
        public LineMergeFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Line-Merge"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            LineMerger merger = new LineMerger();
            merger.add(geom[0]);
            Collection lines = merger.getMergedLineStrings();
            return geom[0].getFactory().buildGeometry(lines);
        }
    }

    private static class EnvelopeFunction
    extends GeometryFunction {
        public EnvelopeFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Envelope"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getEnvelope();
        }
    }

    private static class BoundaryFunction
    extends GeometryFunction {
        public BoundaryFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Boundary"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getBoundary();
        }
    }

    private static class ConvexHullFunction
    extends GeometryFunction {
        public ConvexHullFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Convex-Hull"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            ConvexHull hull = new ConvexHull(geom[0]);
            return hull.getConvexHull();
        }
    }

    private static class SimplifyTopologyFunction
    extends GeometryFunction {
        public SimplifyTopologyFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Simplify-(preserve-topology)"), 1, 1);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return TopologyPreservingSimplifier.simplify((Geometry)geom[0], (double)param[0]);
        }
    }

    private static class SimplifyFunction
    extends GeometryFunction {
        public SimplifyFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.Simplify-(D-P)"), 1, 1, I18N.get((String)"ui.plugin.analysis.GeometryFunction.Simplifies-a-geometry-using-the-Douglas-Peucker-algorithm"));
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return DouglasPeuckerSimplifier.simplify((Geometry)geom[0], (double)param[0]);
        }
    }

    private static class BufferFunction
    extends GeometryFunction {
        public BufferFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.buffer"), 1, 1);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].buffer(param[0]);
        }
    }

    private static class InteriorPointFunction
    extends GeometryFunction {
        public InteriorPointFunction() {
            super("Interior Point", 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getInteriorPoint();
        }
    }

    private static class CentroidFunction
    extends GeometryFunction {
        public CentroidFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.centroid-of-a"), 1, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].getCentroid();
        }
    }

    private static class SymDifferenceFunction
    extends GeometryFunction {
        public SymDifferenceFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.symetric-difference"), 2, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].symDifference(geom[1]);
        }
    }

    private static class DifferenceBAFunction
    extends GeometryFunction {
        public DifferenceBAFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.difference-b-a"), 2, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[1].difference(geom[0]);
        }
    }

    private static class DifferenceABFunction
    extends GeometryFunction {
        public DifferenceABFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.difference-a-b"), 2, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].difference(geom[1]);
        }
    }

    private static class UnionFunction
    extends GeometryFunction {
        public UnionFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.union"), 2, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].union(geom[1]);
        }
    }

    private static class IntersectionFunction
    extends GeometryFunction {
        public IntersectionFunction() {
            super(I18N.get((String)"ui.plugin.analysis.GeometryFunction.intersection"), 2, 0);
        }

        public Geometry execute(Geometry[] geom, double[] param) {
            return geom[0].intersection(geom[1]);
        }
    }
}

