/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ShortcutKeysPlugIn
extends AbstractPlugIn {
    private static Logger LOG = Logger.getLogger(ShortcutKeysPlugIn.class);
    private static String html = null;

    private HTMLFrame frame(WorkbenchContext context) {
        String key = this.getClass().getName() + " - " + I18N.get((String)"ui.plugin.ShortcutKeyPlugIn.frame");
        if (context.getWorkbench().getBlackboard().get(key) == null) {
            HTMLFrame frame = new HTMLFrame(context.getWorkbench().getFrame());
            frame.setRecordNavigationControlVisible(false);
            frame.createNewDocument();
            try {
                this.append(frame);
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere();
            }
            frame.setTitle(I18N.get((String)"ui.plugin.ShortcutKeyPlugIn.shortcut-keys"));
            frame.setSize(420, 290);
            context.getWorkbench().getBlackboard().put(key, (Object)frame);
        }
        return (HTMLFrame)context.getWorkbench().getBlackboard().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String html() throws IOException {
        if (html == null) {
            html = "";
            LOG.debug((Object)("com.vividsolutions.jump.workbench.ui.plugin.KeyboardPlugIn_" + I18N.getLanguage() + ".html"));
            InputStream inputStream = ShortcutKeysPlugIn.class.getResourceAsStream("KeyboardPlugIn_" + I18N.getLanguage() + ".html");
            if (inputStream == null) {
                LOG.error((Object)("No com.vividsolutions.jump.workbench.ui.plugin.KeyboardPlugIn_" + I18N.getLanguage() + ".html file. Use default instead."));
                inputStream = ShortcutKeysPlugIn.class.getResourceAsStream("KeyboardPlugIn_.html");
            } else {
                try {
                    for (String line : FileUtil.getContents((InputStream)inputStream)) {
                        html = html + line;
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        return html;
    }

    private void append(HTMLFrame frame) throws IOException {
        frame.append(this.removeHTMLTags(ShortcutKeysPlugIn.html()));
    }

    private String removeHTMLTags(String s) {
        return StringUtil.replaceAll((String)StringUtil.replaceAll((String)s, (String)"<html>", (String)""), (String)"</html>", (String)"");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.frame(context.getWorkbenchContext()).surface();
        return true;
    }
}

