/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.AbstractSaveProjectPlugIn;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveProjectAsPlugIn
extends AbstractSaveProjectPlugIn {
    public static final FileFilter JUMP_PROJECT_FILE_FILTER = GUIUtil.createFileFilter(I18N.get((String)"ui.plugin.SaveProjectAsPlugIn.jump-project-files"), new String[]{"jmp", "jcs"});
    private JFileChooser fileChooser;

    public void initialize(PlugInContext context) throws Exception {
        this.fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting("jmp");
        this.fileChooser.setDialogTitle(I18N.get((String)"ui.plugin.SaveProjectAsPlugIn.save-project"));
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(JUMP_PROJECT_FILE_FILTER);
    }

    public String getName() {
        return I18N.get((String)"ui.plugin.SaveProjectAsPlugIn.save-project-as");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (context.getTask().getProjectFile() != null) {
            this.fileChooser.setSelectedFile(context.getTask().getProjectFile());
        }
        if (0 != this.fileChooser.showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        File file = this.fileChooser.getSelectedFile();
        file = FileUtil.addExtensionIfNone((File)file, (String)"jmp");
        this.save(context.getTask(), file, context.getWorkbenchFrame());
        return true;
    }
}

