/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class PersistentBlackboardPlugIn
extends AbstractPlugIn {
    private static String persistenceDirectory = ".";
    private static String fileName = "workbench-state.xml";
    private static final String BLACKBOARD_KEY = PersistentBlackboardPlugIn.class.getName() + " - BLACKBOARD";

    public static Blackboard get(WorkbenchContext context) {
        Blackboard blackboard = context.getBlackboard();
        return PersistentBlackboardPlugIn.get(blackboard);
    }

    public static Blackboard get(Blackboard blackboard) {
        if (blackboard.get(BLACKBOARD_KEY) == null) {
            blackboard.put(BLACKBOARD_KEY, (Object)new Blackboard());
        }
        return (Blackboard)blackboard.get(BLACKBOARD_KEY);
    }

    public static void setPersistenceDirectory(String value) {
        persistenceDirectory = value;
    }

    public static void setFileName(String value) {
        fileName = value;
    }

    public String getFilePath() {
        return persistenceDirectory + "/" + fileName;
    }

    public void initialize(final PlugInContext context) throws Exception {
        this.restoreState(context.getWorkbenchContext());
        context.getWorkbenchFrame().addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                PersistentBlackboardPlugIn.this.saveState(context.getWorkbenchContext());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(WorkbenchContext workbenchContext) {
        if (!new File(this.getFilePath()).exists()) {
            return;
        }
        try {
            FileReader fileReader = new FileReader(this.getFilePath());
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    PersistentBlackboardPlugIn.get(workbenchContext).putAll((Map)((Blackboard)new XML2Java(workbenchContext.getWorkbench().getPlugInManager().getClassLoader()).read((Reader)bufferedReader, Blackboard.class)).getProperties());
                }
                finally {
                    bufferedReader.close();
                }
            }
            finally {
                fileReader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(WorkbenchContext workbenchContext) {
        try {
            FileWriter fileWriter = new FileWriter(this.getFilePath(), false);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                try {
                    new Java2XML().write((Object)PersistentBlackboardPlugIn.get(workbenchContext), "workbench-state", (Writer)bufferedWriter);
                    bufferedWriter.flush();
                    fileWriter.flush();
                }
                finally {
                    bufferedWriter.close();
                }
            }
            finally {
                fileWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

