/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.WKTPlugIn;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;

public class AddNewFeaturesPlugIn
extends WKTPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("add.png");

    protected Layer layer(PlugInContext context) {
        return context.getLayerNamePanel().chooseEditableLayer();
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        return super.execute(context);
    }

    protected void apply(FeatureCollection c, PlugInContext context) {
        final ArrayList<Feature> features = new ArrayList<Feature>();
        FeatureSchema fs = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (Feature feature : c) {
            features.add(FeatureUtil.toFeature((Geometry)feature.getGeometry(), (FeatureSchema)fs));
        }
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                AddNewFeaturesPlugIn.this.layer.getFeatureCollectionWrapper().addAll((Collection)features);
            }

            public void unexecute() {
                AddNewFeaturesPlugIn.this.layer.getFeatureCollectionWrapper().removeAll((Collection)features);
            }
        }, context);
    }

    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle(I18N.get((String)"ui.plugin.AddNewFeaturesPlugIn.add-features-to") + " " + this.layer);
        d.setDescription("<HTML>" + I18N.get((String)"ui.plugin.AddNewFeaturesPlugIn.enter-well-known-text-for-one-or-more-geometries") + "</HTML>");
        return d;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyOneSelectedLayerMustBeEditableCheck());
    }
}

