/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.SimpleTreeModel;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;

public class LayerTreeModel
extends SimpleTreeModel {
    private LayerManagerProxy layerManagerProxy;

    public LayerTreeModel(LayerManagerProxy layerManagerProxy) {
        super((Object)new Root());
        this.layerManagerProxy = layerManagerProxy;
    }

    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!(child instanceof ColorThemingValue) || !(this.getChild(parent, i) instanceof ColorThemingValue) || !this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return super.getIndexOfChild(parent, child);
    }

    public List getChildren(Object parent) {
        if (parent == this.getRoot()) {
            return this.layerManagerProxy.getLayerManager().getCategories();
        }
        if (parent instanceof Category) {
            return ((Category)parent).getLayerables();
        }
        if (parent instanceof Layer && ColorThemingStyle.get((Layer)parent).isEnabled()) {
            Map attributeValueToBasicStyleMap = ColorThemingStyle.get((Layer)parent).getAttributeValueToBasicStyleMap();
            Map attributeValueToLabelMap = ColorThemingStyle.get((Layer)parent).getAttributeValueToLabelMap();
            ArrayList<ColorThemingValue> colorThemingValues = new ArrayList<ColorThemingValue>();
            for (Object value : attributeValueToBasicStyleMap.keySet()) {
                colorThemingValues.add(new ColorThemingValue(value, (BasicStyle)attributeValueToBasicStyleMap.get(value), (String)attributeValueToLabelMap.get(value)));
            }
            return colorThemingValues;
        }
        if (parent instanceof ColorThemingValue) {
            return Collections.EMPTY_LIST;
        }
        if (parent instanceof Layerable) {
            return new ArrayList();
        }
        Assert.shouldNeverReachHere((String)parent.getClass().getName());
        return null;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof Layerable) {
            ((Layerable)path.getLastPathComponent()).setName((String)newValue);
        } else if (path.getLastPathComponent() instanceof Category) {
            ((Category)path.getLastPathComponent()).setName((String)newValue);
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public static class ColorThemingValue {
        private Object value;
        private BasicStyle style;
        private String label;

        public ColorThemingValue(Object value, BasicStyle style, String label) {
            this.value = value;
            this.style = style;
            Assert.isTrue((label != null ? 1 : 0) != 0);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object other) {
            return other instanceof ColorThemingValue && LangUtil.bothNullOrEqual((Object)this.value, (Object)((ColorThemingValue)other).value) && this.style == ((ColorThemingValue)other).style;
        }

        public BasicStyle getStyle() {
            return this.style;
        }
    }

    public static class Root {
        private Root() {
        }
    }
}

