/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWImage;
import com.vividsolutions.jump.workbench.imagery.ecw.JNCSRendererProxy;
import org.apache.log4j.Logger;

public class ECWImageFactory
implements ReferencedImageFactory {
    private Logger logger = Logger.getLogger(ECWImageFactory.class);
    public static final String TYPE_NAME = "ECW";
    static final String sNotInstalled = I18N.get((String)"org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.not-installed");

    public String getTypeName() {
        return TYPE_NAME;
    }

    public ReferencedImage createImage(String location) throws JUMPException {
        return new ECWImage(location);
    }

    public String getDescription() {
        return "Enhanced Compressed Wavelet";
    }

    public String[] getExtensions() {
        return new String[]{"ecw"};
    }

    public boolean isEditableImage(String location) {
        return false;
    }

    public boolean isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass(JNCSRendererProxy.RENDERER_CLASS);
        }
        catch (ClassNotFoundException e) {
            this.logger.warn((Object)("ECW loader class " + JNCSRendererProxy.RENDERER_CLASS + " " + sNotInstalled));
            return false;
        }
        this.logger.trace((Object)"found ECW loader class");
        return c != null;
    }
}

