/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datastore;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.Query;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionManager {
    private WorkbenchContext context;
    private Map connectionDescriptorToConnectionMap = new HashMap();
    private static final DataStoreConnection DUMMY_CONNECTION = new DataStoreConnection(){

        public DataStoreMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        public FeatureInputStream execute(Query query) {
            throw new UnsupportedOperationException();
        }

        public void close() throws DataStoreException {
            throw new UnsupportedOperationException();
        }

        public boolean isClosed() throws DataStoreException {
            return true;
        }
    };
    private List listeners = new ArrayList();

    private ConnectionManager(WorkbenchContext context, final Collection connectionDescriptors) {
        this.context = context;
        for (ConnectionDescriptor connectionDescriptor : connectionDescriptors) {
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, DUMMY_CONNECTION);
        }
        this.addListener(new Listener(){

            public void connectionDescriptorAdded(ConnectionDescriptor connectionDescriptor) {
                this.updateConnectionDescriptors();
            }

            public void connectionDescriptorRemoved(ConnectionDescriptor connectionDescriptor) {
                this.updateConnectionDescriptors();
            }

            private void updateConnectionDescriptors() {
                connectionDescriptors.clear();
                connectionDescriptors.addAll(ConnectionManager.this.connectionDescriptorToConnectionMap.keySet());
            }
        });
    }

    public DataStoreConnection getOpenConnection(ConnectionDescriptor connectionDescriptor) throws Exception {
        if (this.getConnection(connectionDescriptor).isClosed()) {
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, connectionDescriptor.createConnection(this.getDriver(connectionDescriptor.getDataStoreDriverClassName())));
        }
        return this.getConnection(connectionDescriptor);
    }

    public DataStoreDriver getDriver(String driverClassName) {
        DataStoreDriver driver = this.findDriverRegistryEntry(driverClassName);
        if (driver == null) {
            throw new RuntimeException("Can't find DataStoreDriver: " + driverClassName);
        }
        return driver;
    }

    private DataStoreDriver findDriverRegistryEntry(String driverClassName) {
        List drivers = this.context.getRegistry().getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION);
        for (DataStoreDriver driver : drivers) {
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            return driver;
        }
        return null;
    }

    public DataStoreConnection getConnection(ConnectionDescriptor connectionDescriptor) {
        if (!this.connectionDescriptorToConnectionMap.containsKey(connectionDescriptor)) {
            this.connectionDescriptorToConnectionMap.put(connectionDescriptor, DUMMY_CONNECTION);
            this.fireConnectionDescriptorAdded(connectionDescriptor);
        }
        return (DataStoreConnection)this.connectionDescriptorToConnectionMap.get(connectionDescriptor);
    }

    public Collection getConnectionDescriptors() {
        return Collections.unmodifiableCollection(this.connectionDescriptorToConnectionMap.keySet());
    }

    public void deleteConnectionDescriptor(ConnectionDescriptor connectionDescriptor) throws DataStoreException {
        if (!this.getConnection(connectionDescriptor).isClosed()) {
            this.getConnection(connectionDescriptor).close();
        }
        this.connectionDescriptorToConnectionMap.remove(connectionDescriptor);
        this.fireConnectionDescriptorRemoved(connectionDescriptor);
    }

    private void fireConnectionDescriptorAdded(ConnectionDescriptor connectionDescriptor) {
        for (Listener listener : this.listeners) {
            listener.connectionDescriptorAdded(connectionDescriptor);
        }
    }

    private void fireConnectionDescriptorRemoved(ConnectionDescriptor connectionDescriptor) {
        for (Listener listener : this.listeners) {
            listener.connectionDescriptorRemoved(connectionDescriptor);
        }
    }

    public static ConnectionManager instance(WorkbenchContext context) {
        String INSTANCE_KEY;
        Blackboard blackboard = context.getBlackboard();
        if (blackboard.get(INSTANCE_KEY = ConnectionManager.class.getName() + " - INSTANCE") == null) {
            blackboard.put(INSTANCE_KEY, (Object)new ConnectionManager(context, (Collection)PersistentBlackboardPlugIn.get(blackboard).get(ConnectionManager.class.getName() + " - CONNECTION DESCRIPTORS", new ArrayList())));
        }
        return (ConnectionManager)blackboard.get(INSTANCE_KEY);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void closeConnections() throws DataStoreException {
        for (ConnectionDescriptor connectionDescriptor : this.getConnectionDescriptors()) {
            if (this.getConnection(connectionDescriptor).isClosed()) continue;
            this.getConnection(connectionDescriptor).close();
        }
    }

    public static interface Listener {
        public void connectionDescriptorAdded(ConnectionDescriptor var1);

        public void connectionDescriptorRemoved(ConnectionDescriptor var1);
    }
}

