/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.style.decoration;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringVertexStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.openjump.core.ui.images.IconLoader;

public class VertexZValueStyle
extends LineStringVertexStyle {
    public static final int FONT_BASE_SIZE = 10;
    private Font font = new Font("Dialog", 0, 10);
    private Font font2 = new Font("Dialog", 1, 12);

    public VertexZValueStyle(String name, String iconFile) {
        super(name, (Icon)IconLoader.icon(iconFile));
    }

    protected void paint(Point2D p, LineString line, int index, Viewport viewport, Graphics2D g) throws Exception {
        String text = Double.toString(line.getCoordinates()[index].z);
        g.setColor(Color.BLACK);
        g.setStroke(this.stroke);
        g.drawLine((int)p.getX(), (int)p.getY(), 1 + (int)p.getX(), 1 + (int)p.getY());
        if (index == 0 || index == line.getNumPoints() - 1) {
            g.drawOval((int)p.getX() - 2, (int)p.getY() - 2, 5, 5);
        }
        if (index == 0) {
            TextLayout layout = new TextLayout(text, this.font2, g.getFontRenderContext());
            Coordinate c0 = line.getCoordinates()[0];
            Coordinate c1 = line.getCoordinates()[1];
            float vx = (float)(c1.x - c0.x);
            float vy = (float)(c1.y - c0.y);
            float d = (float)Math.sqrt(vx * vx + vy * vy);
            float dx = vx >= 0.0f ? 10.0f * vx / d : 52.0f * vx / d;
            float dy = vy >= 0.0f ? -10.0f * vy / d : -20.0f * vy / d;
            layout.draw(g, dx + (float)p.getX(), dy + (float)p.getY());
        } else if (index == line.getNumPoints() - 1) {
            TextLayout layout = new TextLayout(text, this.font2, g.getFontRenderContext());
            Coordinate c0 = line.getCoordinates()[line.getNumPoints() - 1];
            Coordinate c1 = line.getCoordinates()[line.getNumPoints() - 2];
            float vx = (float)(c1.x - c0.x);
            float vy = (float)(c1.y - c0.y);
            float d = (float)Math.sqrt(vx * vx + vy * vy);
            float dx = vx >= 0.0f ? 10.0f * vx / d : 52.0f * vx / d;
            float dy = vy >= 0.0f ? -10.0f * vy / d : -20.0f * vy / d;
            layout.draw(g, dx + (float)p.getX(), dy + (float)p.getY());
        } else {
            TextLayout layout = new TextLayout(text, this.font, g.getFontRenderContext());
            layout.draw(g, 1.0f + (float)p.getX(), -1.0f + (float)p.getY());
        }
    }

    public static class VertexZValue
    extends VertexZValueStyle {
        public VertexZValue() {
            super(I18N.get("ui.renderer.style.VertexZValueStyle.Vertex-Z"), "ZValueDecorator.gif");
        }
    }
}

