/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerWizardPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.OneSRSWizardPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SRSWizardPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.URLWizardPanel;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddWmsLayerWizard
extends AbstractWizardGroup {
    private static final String CACHED_URL = "AddWMSQueryPlugin.CACHED_URL";
    public static final String KEY = AddWmsLayerWizard.class.getName();
    private WorkbenchContext workbenchContext;
    private String[] cachedURLs = new String[]{"http://wms.jpl.nasa.gov/wms.cgi", "http://demo.deegree.org/deegree-wms/services", "http://openaerialmap.org/wms/"};
    private String lastWMSVersion = "1.1.1";
    private ChooseProjectPanel chooseProjectPanel;

    public AddWmsLayerWizard(WorkbenchContext workbenchContext) {
        super(I18N.get("org.openjump.core.ui.plugin.wms.AddWmsLayerWizard.Add-WMS-Layer"), IconLoader.icon((String)"SmallWorld.gif"), URLWizardPanel.class.getName());
        this.workbenchContext = workbenchContext;
    }

    @Override
    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        this.removeAllPanels();
        String urlString = (String)PersistentBlackboardPlugIn.get((WorkbenchContext)workbenchContext).get(CACHED_URL);
        if (urlString != null) {
            this.cachedURLs = urlString.split(",");
        }
        URLWizardPanel urlPanel = new URLWizardPanel(this.cachedURLs, this.lastWMSVersion);
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, urlPanel.getID());
        this.addPanel((WizardPanel)this.chooseProjectPanel);
        this.addPanel((WizardPanel)urlPanel);
        this.addPanel((WizardPanel)new MapLayerWizardPanel());
        this.addPanel((WizardPanel)new SRSWizardPanel());
        this.addPanel((WizardPanel)new OneSRSWizardPanel());
    }

    @Override
    public String getFirstId() {
        String firstId = super.getFirstId();
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    @Override
    public void run(WizardDialog dialog, TaskMonitor monitor) {
        this.chooseProjectPanel.activateSelectedProject();
        try {
            PlugInContext context = this.workbenchContext.createPlugInContext();
            List mapLayers = (List)dialog.getData("LAYERS");
            String title = ((MapLayer)mapLayers.get(0)).getTitle();
            List<String> layerNames = this.toLayerNames(mapLayers);
            WMService service = (WMService)dialog.getData("SERVICE");
            String srs = (String)dialog.getData("SRS");
            String format = (String)dialog.getData("FORMAT");
            WMSLayer layer = new WMSLayer(title, context.getLayerManager(), service, srs, layerNames, format);
            LayerNamePanel layerNamePanel = context.getLayerNamePanel();
            Collection selectedCategories = layerNamePanel.getSelectedCategories();
            LayerManager mgr = context.getLayerManager();
            String categoryName = StandardCategoryNames.WORKING;
            if (!selectedCategories.isEmpty()) {
                categoryName = ((Category)selectedCategories.iterator().next()).getName();
            }
            mgr.addLayerable(categoryName, (Layerable)layer);
            this.cachedURLs = (String[])dialog.getData("URL");
            this.lastWMSVersion = (String)dialog.getData("WMS_VERSION");
            PersistentBlackboardPlugIn.get((WorkbenchContext)context.getWorkbenchContext()).put(CACHED_URL, this.toCommaString(this.cachedURLs));
        }
        catch (IOException e) {
            monitor.report(e);
        }
    }

    private String toCommaString(String[] values) {
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            string.append(values[i]);
            if (i == values.length - 1) continue;
            string.append(",");
        }
        return string.toString();
    }

    private List<String> toLayerNames(List<MapLayer> mapLayers) {
        ArrayList<String> names = new ArrayList<String>();
        for (MapLayer layer : mapLayers) {
            names.add(layer.getName());
        }
        return names;
    }
}

