/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view.helpclassescale;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import org.openjump.core.ui.util.ScreenScale;

public class ShowScaleRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "SCALE_SHOW";
    private static final int BAR_HEIGHT = 13;
    private static final Color FILL1 = Color.WHITE;
    private static final int HORIZONTAL_MARGIN = 100;
    private static final Color LINE_COLOR = Color.GRAY;
    private static final int TEXT_BOTTOM_MARGIN = 1;
    private static final Color TEXT_COLOR = Color.black;
    private final int FONTSIZE = 12;
    private static final int VERTICAL_MARGIN = 3;
    private static final String ENABLED_KEY = "SCALE_SHOW_ENABLED";
    private Font FONT = new Font("Dialog", 0, 12);
    private Stroke stroke = new BasicStroke();
    private PlugInContext myPlugInContext = null;

    public ShowScaleRenderer(LayerViewPanel panel) {
        super((Object)CONTENT_ID, panel);
    }

    protected void paint(Graphics2D g) {
        if (!ShowScaleRenderer.isEnabled(this.panel)) {
            return;
        }
        g.setStroke(this.stroke);
        double screenScale = ScreenScale.getHorizontalMapScale(this.panel.getViewport());
        this.paintScaleLabel(g, screenScale);
    }

    private int barBottom() {
        return this.panel.getHeight() - 3;
    }

    private int barTop() {
        return this.barBottom() - 13;
    }

    private TextLayout createTextLayout(String text, Font font, Graphics2D g) {
        return new TextLayout(text, font, g.getFontRenderContext());
    }

    private void paintScaleLabel(Graphics2D g, double scale) {
        Integer scaleD = new Integer((int)Math.floor(scale));
        String text = "1 : " + scaleD.toString();
        int length = text.length();
        Rectangle2D.Double shape = new Rectangle2D.Double((double)this.panel.getWidth() - (double)(length + 13) * 3.6, this.barTop(), (double)(length + 12) * 3.6 - 3.0, this.barBottom() - this.barTop());
        g.setColor(FILL1);
        g.fill(shape);
        g.setColor(LINE_COLOR);
        g.draw(shape);
        Font font = this.FONT;
        g.setColor(TEXT_COLOR);
        int textBottomMargin = 1;
        TextLayout layout = this.createTextLayout(text, font, g);
        layout.draw(g, (float)((double)this.panel.getWidth() - (double)(length + 11) * 3.6), this.barBottom() - textBottomMargin);
    }

    public static boolean isEnabled(LayerViewPanel panel) {
        return panel.getBlackboard().get(ENABLED_KEY, false);
    }

    public static void setEnabled(boolean enabled, LayerViewPanel panel) {
        panel.getBlackboard().put(ENABLED_KEY, enabled);
    }

    public void setMyPlugInContext(PlugInContext myPlugInContext) {
        this.myPlugInContext = myPlugInContext;
    }
}

