/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Component;
import java.awt.Frame;
import org.openjump.core.ui.util.ScreenScale;

public class ZoomToScalePlugIn
extends AbstractPlugIn {
    private String T1 = "scale";
    int scale = 0;
    double oldHorizontalScale = 0.0;
    double modelWidth = 0.0;
    double panelWidth = 0.0;
    String text = I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.set-new-scale-to-zoom") + ":  1 : ";

    public void initialize(PlugInContext context) throws Exception {
        this.T1 = I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.scale") + ": ";
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.VIEW}, I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale") + "{pos:9}", false, null, (EnableCheck)ZoomToScalePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        Viewport port = context.getLayerViewPanel().getViewport();
        this.oldHorizontalScale = ScreenScale.getHorizontalMapScale(port);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.zoom-to-scale"), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        double factor = (double)this.scale / this.oldHorizontalScale;
        Envelope oldEnvelope = port.getEnvelopeInModelCoordinates();
        double xc = 0.5 * (oldEnvelope.getMaxX() + oldEnvelope.getMinX());
        double yc = 0.5 * (oldEnvelope.getMaxY() + oldEnvelope.getMinY());
        double xmin = xc - 0.5 * factor * oldEnvelope.getWidth();
        double xmax = xc + 0.5 * factor * oldEnvelope.getWidth();
        double ymin = yc - 0.5 * factor * oldEnvelope.getHeight();
        double ymax = yc + 0.5 * factor * oldEnvelope.getHeight();
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmax, ymax)};
        LineString g1 = new GeometryFactory().createLineString(coords);
        port.zoom(g1.getEnvelopeInternal());
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(I18N.get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.actual-scale-in-horizontal-direction") + " 1 : " + (int)this.oldHorizontalScale);
        dialog.addIntegerField(this.text, 25000, 7, this.text);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.scale = dialog.getInteger(this.text);
    }
}

