/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.ToolTipWriter;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.List;
import org.openjump.core.geomutils.GeoUtils;

public class MapToolTipPlugIn
extends AbstractPlugIn {
    PlugInContext gContext;
    static final String sErrorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.view.MapToolTipPlugIn.Error-See-Output-Window");
    static final String sPoint = I18N.get("org.openjump.core.ui.plugin.view.MapToolTipPlugIn.Point");
    static final String sSide = I18N.get("org.openjump.core.ui.plugin.view.MapToolTipPlugIn.Side");
    static final String sLength = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.length");
    static final String sAngle = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String sDegrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    static final String sNoData = I18N.get("org.openjump.core.ui.plugin.view.MapToolTipPlugIn.No-Data");
    static final String sArea = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.area");
    static final String pictureSuffix = "_p";
    private MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            if (MapToolTipPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel() == null) {
                return;
            }
            ToolTipWriter toolTipWriter = new ToolTipWriter(MapToolTipPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel());
            toolTipWriter.setEnabled(MapToolTipPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel().getToolTipWriter().isEnabled());
            String fid = toolTipWriter.write("{FID}", (Point2D)e.getPoint());
            if (fid != null) {
                String toolTipText = MapToolTipPlugIn.this.getData(Integer.parseInt(fid), e.getPoint());
                MapToolTipPlugIn.this.gContext.getWorkbenchContext().getLayerViewPanel().setToolTipText(toolTipText);
            }
        }
    };

    public void initialize(PlugInContext context) throws Exception {
        this.gContext = context;
        context.getWorkbenchFrame().getDesktopPane().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerViewPanel().addMouseMotionListener((MouseMotionListener)MapToolTipPlugIn.this.mouseMotionAdapter);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child.getClass().getName().equals("com.vividsolutions.jump.workbench.ui.TaskFrame")) {
                    ((TaskFrame)child).getLayerViewPanel().removeMouseMotionListener((MouseMotionListener)MapToolTipPlugIn.this.mouseMotionAdapter);
                }
            }
        });
    }

    public boolean execute(PlugInContext context) throws Exception {
        try {
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("MapToolTipPlugIn Exception:" + e.toString());
            return false;
        }
    }

    private String getData(int fID, Point2D mouseLocation) {
        int maxLinesOfData = 10;
        String dataText = "<html>";
        LayerViewPanel panel = this.gContext.getWorkbenchContext().getLayerViewPanel();
        if (panel == null) {
            return "";
        }
        LayerManager layerManager = panel.getLayerManager();
        List layerList = layerManager.getVisibleLayers(false);
        for (Layer layer : layerList) {
            FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            int numAttribs = featureSchema.getAttributeCount();
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            List featureList = featureCollection.getFeatures();
            for (Feature feature : featureList) {
                int fid = feature.getID();
                if (fid != fID) continue;
                Geometry geo = feature.getGeometry();
                try {
                    Coordinate coord = panel.getViewport().toModelCoordinate(mouseLocation);
                    dataText = dataText + this.getGeoData(geo, coord);
                }
                catch (NoninvertibleTransformException e) {
                    // empty catch block
                }
                int NumLinesOfData = 1;
                for (int num = 0; num < numAttribs; ++num) {
                    AttributeType type = featureSchema.getAttributeType(num);
                    if (type != AttributeType.STRING) continue;
                    String name = featureSchema.getAttributeName(num);
                    String data = feature.getString(name).trim();
                    if (name.endsWith(pictureSuffix)) {
                        data = "<img src=\"file:///" + data + "\">";
                    }
                    if (data.equals("") || NumLinesOfData >= maxLinesOfData) continue;
                    dataText = dataText + "<br>" + name + ": " + data;
                    ++NumLinesOfData;
                }
                return dataText + "</html>";
            }
        }
        dataText = dataText + sNoData + "</html>";
        return dataText;
    }

    private String getGeoData(Geometry geo, Coordinate mousePt) {
        GeoData geoData = this.getClosest(geo, mousePt);
        DecimalFormat df2 = new DecimalFormat("##0.0#");
        DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
        String geoText = "";
        geoText = geoData.area > 0.0 ? geoData.type + ": " + sSide + ": " + geoData.side + ", " + sLength + ": " + df3.format(geoData.length) + ", " + sAngle + ": " + df2.format(geoData.angle) + " " + sDegrees + ", " + sArea + ": " + df2.format(geoData.area) : geoData.type + ": " + sSide + ": " + geoData.side + ", " + sLength + ": " + df3.format(geoData.length) + ", " + sAngle + ": " + df2.format(geoData.angle) + " " + sDegrees;
        if (geoData.type.equals("Point")) {
            geoText = "Point";
        }
        return geoText;
    }

    private GeoData getClosest(Geometry geo, Coordinate mousePt) {
        GeoData geoData;
        if (geo.getGeometryType().equals("GeometryCollection") || geo.getGeometryType().equals("MultiPoint") || geo.getGeometryType().equals("MultiLineString") || geo.getGeometryType().equals("MultiPolygon")) {
            geoData = this.getClosest(((GeometryCollection)geo).getGeometryN(0), mousePt);
            for (int i = 1; i < ((GeometryCollection)geo).getNumGeometries(); ++i) {
                GeoData geoData2 = this.getClosest(((GeometryCollection)geo).getGeometryN(i), mousePt);
                if (!(geoData2.distance < geoData.distance)) continue;
                geoData.set(geoData2);
            }
        } else {
            Coordinate p1;
            Coordinate p0;
            geo.getCoordinates();
            CoordinateList coords = new CoordinateList();
            UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
            geo.apply((CoordinateFilter)filter);
            coords.add(filter.getCoordinates(), false);
            if (geo instanceof Polygon || geo instanceof LinearRing) {
                coords.add((Object)coords.getCoordinate(0));
            }
            int maxIndex = coords.size() - 1;
            int side = 1;
            double length = 0.0;
            double angle = 0.0;
            double distToClosestSide = mousePt.distance(coords.getCoordinate(0));
            if (coords.size() > 1) {
                p0 = coords.getCoordinate(0);
                p1 = coords.getCoordinate(1);
                length = p0.distance(p1);
                angle = GeoUtils.getBearing180(p0, p1);
                distToClosestSide = GeoUtils.getDistance(mousePt, p0, p1);
            }
            for (int i = 1; i < maxIndex; ++i) {
                p0 = coords.getCoordinate(i);
                double distToSide = GeoUtils.getDistance(mousePt, p0, p1 = coords.getCoordinate(i + 1));
                if (!(distToSide < distToClosestSide)) continue;
                side = i + 1;
                length = p0.distance(p1);
                angle = GeoUtils.getBearing180(p0, p1);
                distToClosestSide = distToSide;
            }
            geoData = new GeoData();
            geoData.type = geo.getGeometryType();
            geoData.side = side;
            geoData.length = length;
            geoData.angle = angle;
            geoData.distance = distToClosestSide;
            geoData.area = geo.getArea();
        }
        return geoData;
    }

    private class GeoData {
        public String type;
        public double distance;
        public int side;
        public double length;
        public double angle;
        public double area;

        private GeoData() {
        }

        public void set(GeoData geoData) {
            this.type = geoData.type;
            this.distance = geoData.distance;
            this.side = geoData.side;
            this.length = geoData.length;
            this.angle = geoData.angle;
            this.area = geoData.area;
        }
    }
}

