/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import org.openjump.core.apitools.FeatureSchemaTools;
import org.openjump.core.ui.plot.Plot2DPanelOJ;

public class CreateHistogramPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sHistogram = "Histogram";
    private String sCount = "count";
    private MultiInputDialog dialog;
    private String T2 = "number of ranges";
    private String CLAYER = "select layer";
    private String ATTRIBUTE = "select attribute";
    private Layer selLayer = null;
    private int ranges = 7;
    private FeatureCollection fc = null;
    private String selAttribute = null;
    private String sName = "Create Histogram Plot";
    private String sWrongDataType = "Wrong datatype of chosen attribute";

    public void initialize(PlugInContext context) throws Exception {
        this.ATTRIBUTE = GenericNames.SELECT_ATTRIBUTE;
        this.T2 = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Number-of-ranges");
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sHistogram = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Histogram-Plot");
        this.sCount = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.count");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Create-Histogram-Plot");
        this.sWrongDataType = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS, MenuNames.PLOT}, this.sName + "...", false, null, (EnableCheck)CreateHistogramPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createHistogram(context, this.selLayer);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List list = FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(context.getCandidateLayer(0));
        Object val = list.size() > 0 ? list.iterator().next() : null;
        final JComboBox jcb_attribute = dialog.addComboBox(this.ATTRIBUTE, val, (Collection)list, this.ATTRIBUTE);
        if (list.size() == 0) {
            jcb_attribute.setEnabled(false);
        }
        dialog.addIntegerField(this.T2, this.ranges, 6, this.T2);
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = CreateHistogramPlugIn.this.getFieldsFromLayerWithoutGeometryAndString();
                if (list.size() == 0) {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attribute.setEnabled(false);
                }
                jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.ranges = dialog.getInteger(this.T2);
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.fc = this.selLayer.getFeatureCollectionWrapper();
        this.selAttribute = dialog.getText(this.ATTRIBUTE);
    }

    private boolean createHistogram(PlugInContext context, Layer selLayer) throws Exception {
        FeatureSchema fs = this.fc.getFeatureSchema();
        AttributeType type = null;
        if (fs.getAttributeType(this.selAttribute) != AttributeType.DOUBLE && fs.getAttributeType(this.selAttribute) != AttributeType.INTEGER) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        type = fs.getAttributeType(this.selAttribute);
        double[] data = new double[this.fc.size()];
        int i = 0;
        Iterator iter = this.fc.iterator();
        while (iter.hasNext()) {
            Feature f = (Feature)iter.next();
            Object val = f.getAttribute(this.selAttribute);
            if (type == AttributeType.DOUBLE) {
                data[i] = (Double)val;
            } else if (type == AttributeType.INTEGER) {
                data[i] = ((Integer)val).doubleValue();
            }
            ++i;
        }
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addHistogramPlotOJ(this.selAttribute, data, this.ranges, context, selLayer, this.selAttribute);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.selAttribute);
        plot.setAxisLabel(1, this.sCount);
        JInternalFrame frame = new JInternalFrame(this.sHistogram);
        frame.setLayout(new BorderLayout());
        frame.add((Component)((Object)plot), "Center");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(450, 450);
        frame.setVisible(true);
        context.getWorkbenchFrame().addInternalFrame(frame);
        return true;
    }

    private List getFieldsFromLayerWithoutGeometryAndString() {
        return FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(this.dialog.getLayer(this.CLAYER));
    }
}

