/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.math.array.StatisticSample;
import org.openjump.core.apitools.FeatureSchemaTools;

public class CalcVarianceAndMeanPerClassPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private MultiInputDialog dialog;
    private String sidetext = "Calculates mean and variance for a specified attribute in accordance with the classes, which need to be given";
    private String OLAYER = "select origin layer";
    private String ATTRIBUTEA = "Select attribute to calculate ratio from";
    private String ATTRIBUTEB = "Select attribute with classification";
    private Layer selLayerO = null;
    private String selAttributeA = null;
    private String selAttributeB = null;
    private String sName = "Calculate Mean and Variance Per Class";
    private String sWrongDataType = "Wrong datatype of chosen attribute";
    private String sSearch = "reading data and search for complement";
    private String sCalcRatios = "calculating ratios";

    public void initialize(PlugInContext context) throws Exception {
        this.sidetext = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.descriptiontext");
        this.OLAYER = GenericNames.SELECT_LAYER;
        this.ATTRIBUTEA = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.Select-attribute-to-calculate-statistics-from");
        this.ATTRIBUTEB = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.Select-attribute-with-classification");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.Calculate-Mean-and-Variance-Per-Class");
        this.sWrongDataType = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        this.sSearch = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.reading-data-and-searching-for-complement");
        this.sCalcRatios = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CalcVarianceAndMeanPerClassPlugIn.calculating-statistics");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.sName + "...", false, null, (EnableCheck)CalcVarianceAndMeanPerClassPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.calcClass(context, monitor, this.selLayerO);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sidetext);
        dialog.addLayerComboBox(this.OLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List listO = FeatureSchemaTools.getFieldsFromLayerWithoutGeometry(context.getCandidateLayer(0));
        Object valA = listO.size() > 0 ? listO.iterator().next() : null;
        Object valB = listO.size() > 0 ? listO.iterator().next() : null;
        final JComboBox jcb_attributeA = dialog.addComboBox(this.ATTRIBUTEA, valA, (Collection)listO, this.ATTRIBUTEA);
        if (listO.size() == 0) {
            jcb_attributeA.setEnabled(false);
        }
        final JComboBox jcb_attributeB = dialog.addComboBox(this.ATTRIBUTEB, valB, (Collection)listO, this.ATTRIBUTEB);
        if (listO.size() == 0) {
            jcb_attributeB.setEnabled(false);
        }
        dialog.getComboBox(this.OLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = CalcVarianceAndMeanPerClassPlugIn.this.getFieldsFromLayerWithoutGeometryO();
                if (list.size() == 0) {
                    jcb_attributeA.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeA.setEnabled(false);
                }
                jcb_attributeA.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
        dialog.getComboBox(this.OLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = CalcVarianceAndMeanPerClassPlugIn.this.getFieldsFromLayerWithoutGeometryO();
                if (list.size() == 0) {
                    jcb_attributeB.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attributeB.setEnabled(false);
                }
                jcb_attributeB.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.selLayerO = dialog.getLayer(this.OLAYER);
        this.selAttributeA = dialog.getText(this.ATTRIBUTEA);
        this.selAttributeB = dialog.getText(this.ATTRIBUTEB);
    }

    private boolean calcClass(PlugInContext context, TaskMonitor monitor, Layer orgLayer) throws Exception {
        FeatureCollectionWrapper fcO = orgLayer.getFeatureCollectionWrapper();
        FeatureSchema fsO = fcO.getFeatureSchema();
        AttributeType typeA = null;
        AttributeType typeB = null;
        if (fsO.getAttributeType(this.selAttributeA) != AttributeType.DOUBLE && fsO.getAttributeType(this.selAttributeA) != AttributeType.INTEGER) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        typeA = fsO.getAttributeType(this.selAttributeA);
        typeB = fsO.getAttributeType(this.selAttributeB);
        double[] data = new double[fcO.size()];
        int[] classes = new int[fcO.size()];
        int[] exists = new int[fcO.size()];
        int i = 0;
        Iterator iter = fcO.iterator();
        while (iter.hasNext()) {
            monitor.report(i, fcO.size(), this.sSearch);
            Feature f = (Feature)iter.next();
            Object valA = f.getAttribute(this.selAttributeA);
            Object valB = f.getAttribute(this.selAttributeB);
            if (typeA == AttributeType.DOUBLE) {
                data[i] = (Double)valA;
            } else if (typeA == AttributeType.INTEGER) {
                data[i] = ((Integer)valA).intValue();
            }
            if (typeB == AttributeType.DOUBLE) {
                classes[i] = ((Double)valB).intValue();
            } else if (typeB == AttributeType.INTEGER) {
                classes[i] = (Integer)valB;
            }
            exists[i] = 1;
            ++i;
        }
        monitor.report(this.sCalcRatios);
        double[] var = StatisticSample.fill((int)fcO.size(), (double)-9999.0);
        double[] mean = StatisticSample.fill((int)fcO.size(), (double)-9999.0);
        int[] diffClasses = this.getDifferentClassValues(classes);
        for (int j = 0; j < diffClasses.length; ++j) {
            int actualClass = diffClasses[j];
            int[] idxValsOfSameClass = this.getIndexValuesOfSameClass(classes, actualClass);
            int[] existingIdxVals = this.reduceToExisting(idxValsOfSameClass, exists);
            double[] vals = this.getValuesToIndex(data, existingIdxVals);
            double meanC = StatisticSample.mean((double[])vals);
            double varC = StatisticSample.variance((double[])vals);
            for (int k = 0; k < existingIdxVals.length; ++k) {
                var[existingIdxVals[k]] = varC;
                mean[existingIdxVals[k]] = meanC;
            }
        }
        FeatureDataset fd = null;
        ArrayList<Feature> outData = new ArrayList<Feature>();
        FeatureSchema targetFSnew = null;
        int count = 0;
        Iterator iterp = fcO.iterator();
        String attnameB = this.selAttributeA + "_mean";
        String attname = this.selAttributeA + "_var";
        while (iterp.hasNext()) {
            Feature p = (Feature)iterp.next();
            if (++count == 1) {
                FeatureSchema targetFs = p.getSchema();
                targetFSnew = FeatureSchemaTools.copyFeatureSchema(targetFs);
                if (!targetFSnew.hasAttribute(attnameB)) {
                    targetFSnew.addAttribute(attnameB, AttributeType.DOUBLE);
                }
                if (!targetFSnew.hasAttribute(attname)) {
                    targetFSnew.addAttribute(attname, AttributeType.DOUBLE);
                }
            }
            Feature fcopy = FeatureSchemaTools.copyFeature(p, targetFSnew);
            fcopy.setAttribute(attnameB, (Object)new Double(mean[count - 1]));
            fcopy.setAttribute(attname, (Object)new Double(var[count - 1]));
            outData.add(fcopy);
        }
        fd = new FeatureDataset(targetFSnew);
        fd.addAll(outData);
        String name = this.selAttributeA + "_meanvar";
        context.addLayer(StandardCategoryNames.WORKING, name, (FeatureCollection)fd);
        return true;
    }

    public double[] getValuesToIndex(double[] data, int[] existingIdxVals) {
        double[] vals = new double[existingIdxVals.length];
        for (int i = 0; i < existingIdxVals.length; ++i) {
            vals[i] = data[existingIdxVals[i]];
        }
        return vals;
    }

    private int[] reduceToExisting(int[] idxValsOfSameClass, int[] exists) {
        int i;
        int[] idxVals = null;
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (i = 0; i < idxValsOfSameClass.length; ++i) {
            if (exists[i] != 1) continue;
            vals.add(new Integer(idxValsOfSameClass[i]));
        }
        idxVals = new int[vals.size()];
        i = 0;
        for (Integer idx : vals) {
            idxVals[i] = idx;
            ++i;
        }
        return idxVals;
    }

    public int[] getIndexValuesOfSameClass(int[] classes, int actualClass) {
        int i;
        int[] idxVals = null;
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (i = 0; i < classes.length; ++i) {
            if (classes[i] != actualClass) continue;
            vals.add(new Integer(i));
        }
        idxVals = new int[vals.size()];
        i = 0;
        for (Integer idx : vals) {
            idxVals[i] = idx;
            ++i;
        }
        return idxVals;
    }

    public int[] getDifferentClassValues(int[] classes) {
        int i;
        int[] classVals = null;
        ArrayList<Integer> vals = new ArrayList<Integer>();
        for (i = 0; i < classes.length; ++i) {
            if (i == 0) {
                vals.add(new Integer(classes[i]));
                continue;
            }
            boolean found = false;
            for (Integer existingClass : vals) {
                if (classes[i] != existingClass) continue;
                found = true;
            }
            if (found) continue;
            vals.add(new Integer(classes[i]));
        }
        classVals = new int[vals.size()];
        i = 0;
        for (Integer idx : vals) {
            classVals[i] = idx;
            ++i;
        }
        return classVals;
    }

    private List getFieldsFromLayerWithoutGeometryO() {
        return FeatureSchemaTools.getFieldsFromLayerWithoutGeometry(this.dialog.getLayer(this.OLAYER));
    }
}

