/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.analysis.onelayer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JRadioButton;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.core.graph.polygongraph.PolygonGraph;
import org.openjump.core.graph.polygongraph.PolygonGraphEdge;
import org.openjump.core.graph.polygongraph.PolygonGraphNode;

public class MergeSelectedPolygonsWithNeighbourPlugIn
extends ThreadedBasePlugIn {
    private String sMergeTwoPolys = "Merge Selected Polygons with Neighbours";
    private String sFeaturesFromDifferentLayer = "Error: Features from different layers!";
    private String sSidebar = "Merges selected polygons with neighboring polygons, either with the one that is largest of all neighbors, or the one with which it has the longest common boundary. Note, the function may return multi-polygons if the polygons to merge have only one point in common.";
    boolean useArea = true;
    boolean useBorder = false;
    String sUseArea = "merge with neighbor that has the largest area";
    String sUseBoder = "merge with neighbor with the longest common edge";
    String sChoseMergeMethod = "Please chose the merge method:";
    String sMerged = "merged";
    String sSearchingForMergeCandidates = "Searching for merge candidates...";
    String sMergingPolygons = "Merging polygons...";
    static final String sMERGEMETHOD = "MERGE METHOD";
    private MultiInputDialog dialog;
    private JRadioButton buttonSelectMergeTypeUseArea = null;
    private JRadioButton buttonSelectMergeTypeUseBorder = null;

    public void initialize(PlugInContext context) throws Exception {
        this.sMergeTwoPolys = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Merge-Selected-Polygons-with-Neighbours");
        this.sFeaturesFromDifferentLayer = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.features-from-different-layers");
        this.sSidebar = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.description");
        this.sUseArea = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-with-neighbor-that-has-the-largest-area");
        this.sUseBoder = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merge-with-neighbor-with-the-longest-common-edge");
        this.sChoseMergeMethod = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Please-chose-the-merge-method");
        this.sMerged = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.merged");
        this.sSearchingForMergeCandidates = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Searching-for-merge-candidates");
        this.sMergingPolygons = I18N.get("org.openjump.core.ui.plugin.tools.MergeSelectedPolygonsWithNeighbourPlugIn.Merging-polygons");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.ONELAYER}, this.getName() + "...", false, null, (EnableCheck)MergeSelectedPolygonsWithNeighbourPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public String getName() {
        return this.sMergeTwoPolys;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setSideBarDescription(this.sSidebar);
        String METHODGROUP = sMERGEMETHOD;
        this.dialog.addLabel(this.sChoseMergeMethod);
        this.buttonSelectMergeTypeUseArea = this.dialog.addRadioButton(this.sUseArea, sMERGEMETHOD, this.useArea, this.sUseArea);
        this.buttonSelectMergeTypeUseBorder = this.dialog.addRadioButton(this.sUseBoder, sMERGEMETHOD, this.useBorder, this.sUseBoder);
        GUIUtil.centreOnWindow((Component)this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.useArea = dialog.getBoolean(this.sUseArea);
        this.useBorder = dialog.getBoolean(this.sUseBoder);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        Collection features = context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Collection layers = context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        if (layers.size() > 1) {
            context.getWorkbenchFrame().warnUser(this.sFeaturesFromDifferentLayer);
            return;
        }
        for (Feature ftemp : features) {
            ftemp.getGeometry().setUserData((Object)new Boolean(true));
        }
        Iterator iter = layers.iterator();
        Layer firstLayer = (Layer)iter.next();
        PirolFeatureCollection input = FeatureCollectionTools.cloneFeatureCollection(firstLayer.getFeatureCollectionWrapper());
        FeatureSchema originalFeatureSchema = input.getFeatureSchema();
        PirolFeatureCollection fcN = FeatureCollectionTools.addAttributeToFeatureCollection(input, "mergeid", AttributeType.INTEGER, new Integer(0));
        fcN = FeatureCollectionTools.addAttributeToFeatureCollection(fcN, "selected", AttributeType.INTEGER, new Integer(0));
        fcN = FeatureCollectionTools.addAttributeToFeatureCollection(fcN, "toMergeWithFID", AttributeType.INTEGER, new Integer(0));
        FeatureDataset fcAssigned = new FeatureDataset(fcN.getFeatureSchema());
        int i = 0;
        int fcount = 88888888;
        Quadtree qTree = new Quadtree();
        ArrayList<Feature> selectedF = new ArrayList<Feature>();
        Iterator iterator = fcN.iterator();
        while (iterator.hasNext()) {
            Feature f = (Feature)iterator.next();
            f.setAttribute("mergeid", (Object)new Integer(++fcount));
            Object userdata = f.getGeometry().getUserData();
            if (userdata != null) {
                ++i;
                Boolean isSelected = (Boolean)userdata;
                if (isSelected.booleanValue()) {
                    f.setAttribute("selected", (Object)new Integer(i));
                }
                selectedF.add(f);
            }
            qTree.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
        }
        for (Feature ftemp : features) {
            ftemp.getGeometry().setUserData(null);
        }
        int sizeS = selectedF.size();
        int counterS = 0;
        Iterator iterator2 = selectedF.iterator();
        while (iterator2.hasNext()) {
            monitor.report(counterS, sizeS, this.sSearchingForMergeCandidates);
            if (monitor.isCancelRequested()) {
                return;
            }
            Feature ftemp = (Feature)iterator2.next();
            Geometry gtemp = ftemp.getGeometry();
            List candidates = qTree.query(gtemp.getEnvelopeInternal());
            if (this.useArea) {
                double area = -1.0;
                Feature f2merge = null;
                for (Feature ft : candidates) {
                    double tarea;
                    if (!gtemp.intersects(ft.getGeometry()) || !((tarea = ft.getGeometry().getArea()) > area)) continue;
                    f2merge = ft;
                    area = tarea;
                }
                int val = (Integer)f2merge.getAttribute("toMergeWithFID");
                if (val != 0) {
                    int selectedVal = (Integer)ftemp.getAttribute("selected");
                    if (selectedVal <= 0) {
                        f2merge.setAttribute("toMergeWithFID", (Object)new Integer(-1));
                    }
                } else {
                    f2merge.setAttribute("toMergeWithFID", (Object)((Integer)ftemp.getAttribute("selected")));
                }
                ftemp.setAttribute("toMergeWithFID", (Object)((Integer)f2merge.getAttribute("mergeid")));
            } else {
                PolygonGraph pg = new PolygonGraph(candidates, null);
                PolygonGraphEdge longestEdge = null;
                double maxlength = -1.0;
                for (PolygonGraphNode node : pg.nodes) {
                    if (node.realWorldObject.getID() != ftemp.getID()) continue;
                    for (PolygonGraphEdge tedge : node.edges) {
                        ArrayList<Geometry> lines = tedge.getBoundaries();
                        double length = 0.0;
                        for (Geometry line : lines) {
                            length += line.getLength();
                        }
                        if (!(length > maxlength)) continue;
                        maxlength = length;
                        longestEdge = tedge;
                    }
                }
                Feature fToMerge = null;
                fToMerge = longestEdge.node1.realWorldObject.getID() == ftemp.getID() ? longestEdge.node2.realWorldObject : longestEdge.node1.realWorldObject;
                int val = (Integer)fToMerge.getAttribute("toMergeWithFID");
                if (val != 0) {
                    int selectedVal = (Integer)ftemp.getAttribute("selected");
                    if (selectedVal <= 0) {
                        fToMerge.setAttribute("toMergeWithFID", (Object)new Integer(-1));
                    }
                } else {
                    fToMerge.setAttribute("toMergeWithFID", (Object)((Integer)ftemp.getAttribute("selected")));
                }
                ftemp.setAttribute("toMergeWithFID", (Object)((Integer)fToMerge.getAttribute("mergeid")));
            }
            ++counterS;
        }
        List allfeat = qTree.queryAll();
        fcAssigned.addAll(allfeat);
        FeatureDataset resultFList = new FeatureDataset(fcAssigned.getFeatureSchema());
        FeatureDataset selectedFList = new FeatureDataset(fcAssigned.getFeatureSchema());
        FeatureDataset mergeFList = new FeatureDataset(fcAssigned.getFeatureSchema());
        for (Feature fti : allfeat) {
            Feature ft = fti.clone(true);
            int selectedVal = (Integer)ft.getAttribute("selected");
            int toMergeWithVal = (Integer)ft.getAttribute("toMergeWithFID");
            if (selectedVal == 0 && toMergeWithVal == 0) {
                resultFList.add(ft);
                continue;
            }
            if (selectedVal > 0) {
                selectedFList.add(ft);
                mergeFList.add(ft);
                continue;
            }
            mergeFList.add(ft);
        }
        int size = selectedFList.size();
        int counter = 0;
        Iterator iterator3 = selectedFList.iterator();
        while (iterator3.hasNext()) {
            monitor.report(counter, size, this.sMergingPolygons);
            if (monitor.isCancelRequested()) {
                return;
            }
            Feature ftemp = (Feature)iterator3.next();
            int toMergeWithVal = (Integer)ftemp.getAttribute("toMergeWithFID");
            Feature mpoly = this.getPolyToMerge(toMergeWithVal, mergeFList);
            if (mpoly != null) {
                ArrayList<Geometry> polygons = new ArrayList<Geometry>();
                polygons.add(mpoly.getGeometry());
                polygons.add(ftemp.getGeometry());
                Geometry gp = UnaryUnionOp.union(polygons);
                mpoly.setGeometry(gp);
                mergeFList = this.removeFromList(mergeFList, ftemp);
            } else {
                resultFList.add(ftemp);
                mergeFList = this.removeFromList(mergeFList, ftemp);
            }
            ++counter;
        }
        resultFList.addAll(mergeFList.getFeatures());
        FeatureDataset removedAttrFc = new FeatureDataset(originalFeatureSchema);
        Iterator iterator4 = resultFList.iterator();
        while (iterator4.hasNext()) {
            Feature ftemp = (Feature)iterator4.next();
            Feature fnew = FeatureCollectionTools.copyFeatureAndSetFeatureSchema(ftemp, originalFeatureSchema);
            removedAttrFc.add(fnew);
        }
        resultFList = removedAttrFc;
        context.addLayer(StandardCategoryNames.RESULT, firstLayer.getName() + "_" + this.sMerged, (FeatureCollection)resultFList);
    }

    private Feature getPolyToMerge(int featureID, FeatureCollection mergeFList) {
        Feature foundFeature = null;
        Iterator iterator = mergeFList.iterator();
        while (iterator.hasNext()) {
            Feature ftemp = (Feature)iterator.next();
            int val = (Integer)ftemp.getAttribute("mergeid");
            if (val != featureID) continue;
            int selectedVal = (Integer)ftemp.getAttribute("selected");
            if (selectedVal == 0) {
                foundFeature = ftemp;
                continue;
            }
            int toMergeWithVal = (Integer)ftemp.getAttribute("toMergeWithFID");
            foundFeature = this.getPolyToMerge(toMergeWithVal, mergeFList);
        }
        return foundFeature;
    }

    private FeatureDataset removeFromList(FeatureDataset mergeFList, Feature fToDelete) {
        FeatureDataset fdnew = new FeatureDataset(mergeFList.getFeatureSchema());
        int valToDelete = (Integer)fToDelete.getAttribute("mergeid");
        Iterator iterator = mergeFList.iterator();
        while (iterator.hasNext()) {
            Feature ftemp = (Feature)iterator.next();
            int valCur = (Integer)ftemp.getAttribute("mergeid");
            if (valToDelete == valCur) continue;
            fdnew.add(ftemp);
        }
        return fdnew;
    }
}

