/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openjump.sigle.utilities.geom.FeatureCollectionUtil;

public class PlanarGraphPlugIn
extends ThreadedBasePlugIn {
    public static final String EDGE = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Edge");
    public static final String FACE = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Face");
    public static final String NODE = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Node");
    public static final String CATEGORY = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Graph");
    public static final String MAPPING = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Mapping");
    public static final String TITLE = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Topologic-Analysis");
    public static final String SELECT_LAYER = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Select-layer-to-analyse");
    public static final String CALCULATE_NODES = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-nodes");
    public static final String CALCULATE_FACES = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-faces");
    public static final String CALCULATE_RELATIONS = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Calculate-the-relations-arcs-nodes-and-/or-arcs-faces");
    public static final String KEEP_ATTRIBUTES = I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Keep-attributes");
    public static final Integer MINUS_ONE = new Integer(-1);
    GeometryFactory gf = new GeometryFactory();
    private static boolean nodeb = true;
    private static boolean faceb = true;
    private static boolean relb = true;
    private static boolean attributesb = true;
    private static String LEFT_FACE = "LeftFace";
    private static String RIGHT_FACE = "RightFace";
    private static String INITIAL_NODE = "StartNode";
    private static String FINAL_NODE = "EndNode";
    private String layerName;
    public Collection edges;
    private MultiInputDialog mid;

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection fcFace = null;
        Layer layer = this.mid.getLayer(SELECT_LAYER);
        FeatureCollectionWrapper fcSource = layer.getFeatureCollectionWrapper();
        this.layerName = layer.getName();
        nodeb = this.mid.getBoolean(CALCULATE_NODES);
        faceb = this.mid.getBoolean(CALCULATE_FACES);
        relb = this.mid.getBoolean(CALCULATE_RELATIONS);
        attributesb = this.mid.getBoolean(KEEP_ATTRIBUTES);
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Searching-for-linear-elements"));
        List list = this.getLines(fcSource);
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Number-of-found-elements") + ": " + list.size());
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Generate-layer-of-arcs"));
        FeatureCollection fcEdge = this.createEdgeLayer(layer.getFeatureCollectionWrapper(), nodeb, faceb, relb, context);
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Arc-layer-generated"));
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Create-nodes"));
        if (nodeb) {
            FeatureCollection fcNode = this.createNodeLayer(fcEdge, context, relb);
        }
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Layer-with-nodes-generated"));
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Create-faces"));
        if (faceb) {
            fcFace = this.createFaceLayer(fcEdge, context, relb);
        }
        monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Layer-of-faces-generated"));
        if (faceb) {
            Feature fWithin = null;
            AttributeMapping mapping = null;
            if (attributesb) {
                mapping = new AttributeMapping(new FeatureSchema(), new FeatureSchema());
                List aFeatures = new ArrayList();
                monitor.report(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Transfer-of-attributes"));
                if (FeatureCollectionUtil.getFeatureCollectionDimension(fcSource) == 2) {
                    mapping = new AttributeMapping(fcSource.getFeatureSchema(), fcFace.getFeatureSchema());
                    aFeatures = fcFace.getFeatures();
                } else if (FeatureCollectionUtil.getFeatureCollectionDimension(fcSource) == 1) {
                    mapping = new AttributeMapping(fcSource.getFeatureSchema(), fcFace.getFeatureSchema());
                    aFeatures = fcEdge.getFeatures();
                } else {
                    context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Cannot-transfer-attributes"));
                }
                FeatureDataset fcRecup = new FeatureDataset(mapping.createSchema("GEOMETRY"));
                IndexedFeatureCollection indexedB = new IndexedFeatureCollection(fcSource);
                for (int i = 0; i < aFeatures.size(); ++i) {
                    Feature aFeature = (Feature)aFeatures.get(i);
                    BasicFeature feature = new BasicFeature(fcRecup.getFeatureSchema());
                    int nbFeatureWithin = 0;
                    Iterator j = indexedB.query(aFeature.getGeometry().getEnvelopeInternal()).iterator();
                    while (j.hasNext() && !monitor.isCancelRequested()) {
                        Feature bFeature = (Feature)j.next();
                        if (!aFeature.getGeometry().within(bFeature.getGeometry())) continue;
                        ++nbFeatureWithin;
                        fWithin = bFeature;
                    }
                    if (nbFeatureWithin == 1 && attributesb) {
                        mapping.transferAttributes(fWithin, aFeature, feature);
                    }
                    feature.setGeometry((Geometry)aFeature.getGeometry().clone());
                    fcRecup.add(feature);
                }
                if (fcRecup.size() > 0) {
                    context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + MAPPING, (FeatureCollection)fcRecup);
                }
            }
            context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + FACE, fcFace);
        }
    }

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.getName(), false, null, (EnableCheck)new MultiEnableCheck().add(new EnableCheckFactory(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(new EnableCheckFactory(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(1)));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.mid.setVisible(true);
        this.mid.wasOKPressed();
        return this.mid.wasOKPressed();
    }

    public String getName() {
        return I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.Planar-Graph") + "...";
    }

    private void initDialog(PlugInContext context) {
        this.mid = new MultiInputDialog((Frame)context.getWorkbenchFrame(), TITLE, true);
        this.mid.addLayerComboBox(SELECT_LAYER, context.getLayerManager().getLayer(0), context.getLayerManager());
        this.mid.addLabel(I18N.get("org.openjump.sigle.plugin.PlanarGraphPlugIn.The-layer-of-arcs-is-always-generated"));
        this.mid.addCheckBox(CALCULATE_NODES, nodeb);
        this.mid.addCheckBox(CALCULATE_FACES, faceb);
        this.mid.addCheckBox(CALCULATE_RELATIONS, relb);
        this.mid.addCheckBox(KEEP_ATTRIBUTES, attributesb);
        this.mid.pack();
    }

    public List getLines(FeatureCollection fc) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter filter = new LinearComponentExtracter(linesList);
        boolean count = false;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Geometry g = ((Feature)i.next()).getGeometry();
            g.apply((GeometryComponentFilter)filter);
        }
        return linesList;
    }

    public FeatureCollection createEdgeLayer(FeatureCollection fc, boolean nodeb, boolean faceb, boolean relations, PlugInContext context) {
        FeatureSchema fsEdge = new FeatureSchema();
        fsEdge.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsEdge.addAttribute("ID", AttributeType.INTEGER);
        if (nodeb && relations) {
            fsEdge.addAttribute(INITIAL_NODE, AttributeType.INTEGER);
            fsEdge.addAttribute(FINAL_NODE, AttributeType.INTEGER);
        }
        if (faceb && relations) {
            fsEdge.addAttribute(RIGHT_FACE, AttributeType.INTEGER);
            fsEdge.addAttribute(LEFT_FACE, AttributeType.INTEGER);
        }
        FeatureDataset fcEdge = new FeatureDataset(fsEdge);
        List list = this.getLines(fc);
        Geometry gc = new UnaryUnionOp((Collection)list).union();
        if (!(gc instanceof GeometryCollection)) {
            gc = this.gf.createGeometryCollection(new Geometry[]{gc});
        }
        LineMerger lineMerger = new LineMerger();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            lineMerger.add(gc.getGeometryN(i));
        }
        this.edges = lineMerger.getMergedLineStrings();
        int no = 0;
        Iterator it = this.edges.iterator();
        while (it.hasNext()) {
            BasicFeature f = new BasicFeature(fsEdge);
            f.setGeometry((Geometry)it.next());
            f.setAttribute("ID", (Object)new Integer(++no));
            fcEdge.add(f);
        }
        context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + EDGE, (FeatureCollection)fcEdge);
        return fcEdge;
    }

    public FeatureCollection createNodeLayer(FeatureCollection fcEdge, PlugInContext context, boolean relations) {
        Feature f;
        FeatureSchema fsNode = new FeatureSchema();
        fsNode.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsNode.addAttribute("ID", AttributeType.INTEGER);
        FeatureDataset fcNode = new FeatureDataset(fsNode);
        HashMap<Coordinate, Object> nodes = new HashMap<Coordinate, Object>();
        Iterator it = this.edges.iterator();
        while (it.hasNext()) {
            Coordinate[] cc = ((Geometry)it.next()).getCoordinates();
            nodes.put(cc[0], this.gf.createPoint(cc[0]));
            nodes.put(cc[cc.length - 1], this.gf.createPoint(cc[cc.length - 1]));
        }
        int no = 0;
        Iterator it2 = nodes.values().iterator();
        while (it2.hasNext()) {
            f = new BasicFeature(fsNode);
            f.setGeometry((Geometry)it2.next());
            f.setAttribute("ID", (Object)new Integer(++no));
            nodes.put(f.getGeometry().getCoordinate(), f);
            fcNode.add(f);
        }
        context.getLayerManager().addLayer(CATEGORY, this.layerName + "_" + NODE, (FeatureCollection)fcNode);
        if (relations) {
            it2 = fcEdge.iterator();
            while (it2.hasNext()) {
                f = (Feature)it2.next();
                Coordinate[] cc = f.getGeometry().getCoordinates();
                f.setAttribute(INITIAL_NODE, ((Feature)nodes.get(cc[0])).getAttribute("ID"));
                f.setAttribute(FINAL_NODE, ((Feature)nodes.get(cc[cc.length - 1])).getAttribute("ID"));
            }
        }
        return fcNode;
    }

    public FeatureCollection createFaceLayer(FeatureCollection fcEdge, PlugInContext context, boolean relations) {
        FeatureSchema fsFace = new FeatureSchema();
        fsFace.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fsFace.addAttribute("ID", AttributeType.INTEGER);
        FeatureDataset fcFace = new FeatureDataset(fsFace);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(this.edges);
        int no = 0;
        Iterator it = polygonizer.getPolygons().iterator();
        while (it.hasNext()) {
            BasicFeature f = new BasicFeature(fsFace);
            Geometry face = (Geometry)it.next();
            face.normalize();
            f.setGeometry(face);
            f.setAttribute("ID", (Object)new Integer(++no));
            fcFace.add(f);
        }
        if (relations) {
            for (Feature edge : fcEdge.getFeatures()) {
                edge.setAttribute(RIGHT_FACE, (Object)MINUS_ONE);
                edge.setAttribute(LEFT_FACE, (Object)MINUS_ONE);
                Geometry g1 = edge.getGeometry();
                List list = fcFace.query(g1.getEnvelopeInternal());
                for (int i = 0; i < list.size(); ++i) {
                    Feature face = (Feature)list.get(i);
                    this.labelEdge(edge, face);
                }
            }
        }
        return fcFace;
    }

    private void labelEdge(Feature edge, Feature face) {
        IntersectionMatrix im = edge.getGeometry().relate(face.getGeometry());
        if (im.matches("*1*******")) {
            int edgeC0 = this.getIndex(edge.getGeometry().getCoordinates()[0], face.getGeometry());
            int edgeC1 = this.getIndex(edge.getGeometry().getCoordinates()[1], face.getGeometry());
            if (edgeC1 > edgeC0 && Math.abs(edgeC1 - edgeC0) == 1 || edgeC1 < edgeC0 && Math.abs(edgeC1 - edgeC0) > 1) {
                edge.setAttribute(RIGHT_FACE, face.getAttribute("ID"));
            } else {
                edge.setAttribute(LEFT_FACE, face.getAttribute("ID"));
            }
        } else if (im.matches("1********")) {
            edge.setAttribute(RIGHT_FACE, face.getAttribute("ID"));
            edge.setAttribute(LEFT_FACE, face.getAttribute("ID"));
        }
    }

    private int getIndex(Coordinate c, Geometry g) {
        Coordinate[] cc = g.getCoordinates();
        for (int i = 0; i < cc.length; ++i) {
            if (!cc[i].equals((Object)c)) continue;
            return i;
        }
        return -1;
    }
}

