/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.plugin.raster.ProfileGraphTool;

public class ProfileGraphPlugIn
extends AbstractPlugIn {
    ProfileGraphTool profileTool;
    private static final String sErrorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.tools.MeasureM_FPlugIn.Error-see-output-window");
    private String sName = "Create Thiessen Polygons";

    public void initialize(PlugInContext context) throws Exception {
        this.sName = I18N.get("org.openjump.core.ui.plugin.raster.ProfileGraphPlugIn.Profile-Graph");
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.RASTER}, this.sName + "...", false, null, (EnableCheck)this.createEnableCheck(context.getWorkbenchContext()));
        this.profileTool = new ProfileGraphTool();
    }

    public boolean execute(PlugInContext context) throws Exception {
        try {
            context.getLayerViewPanel().setCurrentCursorTool((CursorTool)this.profileTool);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("MeasureM_FPlugIn Exception:" + e.toString());
            return false;
        }
    }

    private Icon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("RulerM_F.gif"));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }
}

