/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;

public class SearchAllAttributes
extends AbstractPlugIn {
    private static final String SEARCHFOR = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-for");
    private static final String SEARCHALLATTRIBUTES = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-all-attributes");
    private static final String INCLUDEGEOMETRY = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.include-geometry");
    private static final String MATCHOR = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.match-any-search-word");
    private static final String MATCHAND = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.match-all-search-words");
    private static final String MATCHHINT = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.all-search-words-must-be-ina-single-attribute");
    private static final String CASESENSITIVE = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.case-sensitive");
    private static final String WHOLEWORD = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.whole-word");
    private static final String SIDEBARTEXT = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.search-for-text-in-any-attribute");
    private static final String REGULAREXPRESSIONS = I18N.get("org.openjump.core.ui.plugin.queries.SearchAllAttributes.regular-expressions");
    private boolean includeGeometry = false;
    private String searchString = "";
    private int patternCaseOption = 2;
    private boolean wholeWord = false;
    private boolean regularExpressions = false;
    private boolean multiWordMatchAnd = true;

    public String getName() {
        return SEARCHALLATTRIBUTES;
    }

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES}, this.getName() + "...", false, null, null);
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.includeGeometry = false;
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow((Component)dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.searchInAttributes(context, this.searchString);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(SIDEBARTEXT);
        dialog.addTextField(SEARCHFOR, this.searchString, 16, null, "Search target");
        dialog.addCheckBox(CASESENSITIVE, this.patternCaseOption == 0);
        dialog.addCheckBox(WHOLEWORD, this.wholeWord);
        dialog.addRadioButton(MATCHAND, "MatchOptions", this.multiWordMatchAnd, MATCHHINT);
        dialog.addRadioButton(MATCHOR, "MatchOptions", !this.multiWordMatchAnd, MATCHHINT);
        dialog.addCheckBox(INCLUDEGEOMETRY, this.includeGeometry);
        dialog.addCheckBox(REGULAREXPRESSIONS, this.regularExpressions);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.searchString = dialog.getText(SEARCHFOR);
        this.wholeWord = dialog.getCheckBox(WHOLEWORD).isSelected();
        this.multiWordMatchAnd = dialog.getRadioButton(MATCHAND).isSelected();
        this.patternCaseOption = dialog.getCheckBox(CASESENSITIVE).isSelected() ? 0 : 2;
        this.includeGeometry = dialog.getCheckBox(INCLUDEGEOMETRY).isSelected();
        this.regularExpressions = dialog.getCheckBox(REGULAREXPRESSIONS).isSelected();
    }

    private void searchInAttributes(PlugInContext context, String searchString) {
        SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        LayerManager layerManager = context.getLayerManager();
        String[] searchStrings = searchString.split(" ");
        int nwords = searchStrings.length;
        Pattern[] patterns = new Pattern[nwords];
        String quote = "\\Q";
        String endQuote = "\\E";
        if (this.regularExpressions) {
            quote = "";
            endQuote = "";
        }
        for (int k = 0; k < nwords; ++k) {
            String regex = this.wholeWord ? "\\b" + quote + searchStrings[k] + endQuote + "\\b" : quote + searchStrings[k] + endQuote;
            patterns[k] = Pattern.compile(regex, this.patternCaseOption);
        }
        ArrayList layerList = new ArrayList(layerManager.getVisibleLayers(false));
        for (Layer layer : layerList) {
            HashSet<Feature> selectedFeatures = new HashSet<Feature>();
            Iterator iter = layer.getFeatureCollectionWrapper().iterator();
            while (iter.hasNext()) {
                Feature f = (Feature)iter.next();
                String attribString = null;
                int n = f.getAttributes().length;
                for (int i = 0; i < n; ++i) {
                    Object attribute = f.getAttribute(i);
                    if (!this.includeGeometry && attribute instanceof Geometry) continue;
                    try {
                        attribString = attribute.toString();
                        boolean select = this.multiWordMatchAnd;
                        for (int k = 0; k < nwords; ++k) {
                            patterns[k].matcher(attribString).reset();
                            select = this.multiWordMatchAnd ? select && patterns[k].matcher(attribString).find() : select || patterns[k].matcher(attribString).find();
                        }
                        if (!select) continue;
                        selectedFeatures.add(f);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
            }
            if (selectedFeatures.size() <= 0) continue;
            selectionManager.getFeatureSelection().selectItems(layer, selectedFeatures);
        }
    }
}

