/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import com.vividsolutions.jump.I18N;

public class Function {
    private String key;
    public char type;
    public int[] args;
    public double arg;
    public static final Function ISNULL = new Function("isnull", 'B');
    public static final Function BNOF = new Function("bnof", 'B');
    public static final Function DDAY = new Function("dday", 'D');
    public static final Function DYEA = new Function("dyea", 'D');
    public static final Function DNOF = new Function("dnof", 'D');
    public static final Function NNOF = new Function("nnof", 'N');
    public static final Function SNOF = new Function("snof", 'S');
    public static final Function TRIM = new Function("trim", 'S');
    public static final Function SUBS = new Function("subs", 'S', new int[]{0, 2});
    public static final Function LENG = new Function("leng", 'N');
    public static final Function GNOF = new Function("gnof", 'G');
    public static final Function AREA = new Function("area", 'N');
    public static final Function NBPT = new Function("nbpt", 'N');
    public static final Function NBPA = new Function("nbpa", 'N');
    public static final Function BUFF = new Function("buff", 'G', 1000.0);
    public static final Function CENT = new Function("cent", 'G');
    public static final Function EMPT = new Function("empt", 'B');
    public static final Function SIMP = new Function("simp", 'B');
    public static final Function VALI = new Function("vali", 'B');
    public static Function[] BOOLEAN_FUNCTIONS = new Function[]{BNOF, ISNULL};
    public static Function[] DATE_FUNCTIONS = new Function[]{DNOF, DDAY, DYEA, ISNULL};
    public static Function[] NUMERIC_FUNCTIONS = new Function[]{NNOF, ISNULL};
    public static Function[] STRING_FUNCTIONS = new Function[]{SNOF, TRIM, SUBS, LENG, ISNULL};
    public static Function[] GEOMETRIC_FUNCTIONS = new Function[]{GNOF, LENG, AREA, NBPT, NBPA, BUFF, CENT, EMPT, SIMP, VALI};

    public Function(String key, char type) {
        this.key = key;
        this.type = type;
    }

    public Function(String key, char type, int[] args) {
        this.key = key;
        this.type = type;
        this.args = args;
    }

    public Function(String key, char type, double arg) {
        this.key = key;
        this.type = type;
        this.arg = arg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(I18N.get("org.openjump.core.ui.plugin.queries.Function." + this.key));
        if (this == BUFF) {
            return sb.toString() + " (" + this.arg + ")";
        }
        if (this == SUBS && this.args.length == 1) {
            return sb.toString() + " (" + this.args[0] + ")";
        }
        if (this == SUBS && this.args.length == 2) {
            return sb.toString() + " (" + this.args[0] + "," + this.args[1] + ")";
        }
        return sb.toString();
    }
}

