/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Point2D;
import java.io.StringReader;
import java.util.Collection;
import javax.swing.JPopupMenu;

public class PasteItemsAtPlugIn
extends PasteItemsPlugIn {
    WKTReader reader = new WKTReader();
    private static final String PASTE_ITEMS_AT_POINT = I18N.get("org.openjump.core.ui.plugin.mousemenu.PasteItemsAtPlugIn.Paste-Items-At-Point");

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, (PlugIn)this, this.getNameWithMnemonic() + "{pos:10}", false, null, (EnableCheck)PasteItemsAtPlugIn.createEnableCheck((WorkbenchContext)workbenchContext));
    }

    public String getName() {
        return PASTE_ITEMS_AT_POINT;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Transferable transferable = GUIUtil.getContents((Clipboard)Toolkit.getDefaultToolkit().getSystemClipboard());
        Collection features = transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) ? (Collection)GUIUtil.getContents((Clipboard)Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR) : this.reader.read(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor))).getFeatures();
        final SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
        final Layer layer = context.getSelectedLayer(0);
        final Collection featureCopies = PasteItemsAtPlugIn.conform((Collection)features, (FeatureSchema)layer.getFeatureCollectionWrapper().getFeatureSchema());
        Feature feature = (Feature)featureCopies.iterator().next();
        Coordinate firstPoint = feature.getGeometry().getCoordinate();
        Coordinate cursorPt = context.getLayerViewPanel().getViewport().toModelCoordinate((Point2D)context.getLayerViewPanel().getLastClickedPoint());
        Coordinate displacement = CoordUtil.subtract(cursorPt, firstPoint);
        this.moveAll(featureCopies, displacement);
        this.execute(new UndoableCommand(this.getName()){

            public void execute() {
                layer.getFeatureCollectionWrapper().addAll(featureCopies);
                selectionManager.clear();
                selectionManager.getFeatureSelection().selectItems(layer, featureCopies);
            }

            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(featureCopies);
            }
        }, context);
        return true;
    }

    private void moveAll(Collection featureCopies, Coordinate displacement) {
        for (Feature item : featureCopies) {
            this.move(item.getGeometry(), displacement);
            item.getGeometry().geometryChanged();
        }
    }

    private void move(Geometry geometry, final Coordinate displacement) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x += displacement.x;
                coordinate.y += displacement.y;
            }
        });
    }
}

