/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class ExtractLayersByAttribute
extends AbstractPlugIn {
    private static final String EXTRACT_LAYERS_BY_ATTRIBUTE = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extract-Layer-by-Attribute");
    private static final String LAYER_ATTRIBUTE = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Attribute");
    private static final String DIALOGMSG = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extracts-layers-using-a-common-attribute");
    private static final String LAYER = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.LAYER");
    private static final String TEXT = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.TEXT");
    private static final String EXTRACT = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute.Extract");
    private static final String NULL = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute._NULL_");
    private static final String EMPTY = I18N.get("org.openjump.core.ui.plugin.layer.ExtractLayersByAttribute._EMPTY_");
    private Layer sourceLayer = null;
    private JComboBox layerAttributeComboBox = null;
    private boolean textAttributeFound = false;
    public static final ImageIcon ICON = IconLoader.icon((String)"extract.gif");

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT, MenuNames.EXTRACT}, this.getName(), false, (Icon)ICON, (EnableCheck)ExtractLayersByAttribute.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.sourceLayer = context.getSelectedLayer(0);
        MultiInputDialog dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogFields(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            String attrName = dialog.getText(LAYER_ATTRIBUTE);
            this.extractLayers(context, this.sourceLayer, attrName);
            return true;
        }
        return false;
    }

    private void setDialogFields(MultiInputDialog dialog) {
        dialog.setSideBarDescription(DIALOGMSG);
        this.layerAttributeComboBox = dialog.addComboBox(LAYER_ATTRIBUTE, null, new ArrayList(), null);
        List names = this.attributeNames();
        this.layerAttributeComboBox.setModel(new DefaultComboBoxModel(new Vector(names)));
        String layerName = null;
        this.textAttributeFound = false;
        for (String attribute : names) {
            if (attribute.equalsIgnoreCase(LAYER)) {
                layerName = attribute;
                continue;
            }
            if (!attribute.equalsIgnoreCase(TEXT)) continue;
            this.textAttributeFound = true;
        }
        this.layerAttributeComboBox.setSelectedItem(layerName);
    }

    private List attributeNames() {
        ArrayList<String> candidateAttributeNames = new ArrayList<String>();
        FeatureSchema schema = this.sourceLayer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            String name = schema.getAttributeName(i);
            if (name.equalsIgnoreCase("GEOMETRY")) continue;
            candidateAttributeNames.add(name);
        }
        return candidateAttributeNames;
    }

    public String getName() {
        return EXTRACT_LAYERS_BY_ATTRIBUTE;
    }

    private List extractLayers(PlugInContext context, Layer layer, String attributeName) {
        ArrayList<Layer> newLayes = new ArrayList<Layer>();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List featureList = featureCollection.getFeatures();
        FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        int attributeIndex = featureSchema.getAttributeIndex(attributeName);
        featureCollection = layer.getFeatureCollectionWrapper();
        featureList = layer.getFeatureCollectionWrapper().getFeatures();
        boolean wasFiringEvents = context.getLayerManager().isFiringEvents();
        ArrayList<String> newLayerNameList = new ArrayList<String>();
        for (Feature feature : featureList) {
            Object attributeValue = feature.getAttribute(attributeIndex);
            if (attributeValue == null) {
                if (newLayerNameList.contains(NULL)) continue;
                newLayerNameList.add(NULL);
                continue;
            }
            String attributeString = attributeValue.toString();
            if (attributeString.length() == 0 && !newLayerNameList.contains(EMPTY)) {
                newLayerNameList.add(EMPTY);
                continue;
            }
            if (newLayerNameList.contains(attributeString)) continue;
            newLayerNameList.add(attributeString);
        }
        for (String layerName : newLayerNameList) {
            context.getLayerManager().setFiringEvents(true);
            Layer newLayer = context.addLayer(EXTRACT, layerName, (FeatureCollection)new FeatureDataset(featureSchema));
            if (this.textAttributeFound) {
                LabelStyle labelStyle = new LabelStyle();
                labelStyle.setAttribute(TEXT);
                labelStyle.setScaling(true);
                labelStyle.setEnabled(true);
                newLayer.addStyle((Style)labelStyle);
            }
            context.getLayerManager().setFiringEvents(false);
            FeatureCollectionWrapper newFeatureCollection = newLayer.getFeatureCollectionWrapper();
            newLayes.add(newLayer);
            for (Feature feature : featureList) {
                Object attributeValue = feature.getAttribute(attributeIndex);
                if (attributeValue == null) {
                    if (!layerName.equals(NULL)) continue;
                    newFeatureCollection.add((Feature)feature.clone());
                    continue;
                }
                String attributeString = attributeValue.toString();
                if (attributeString.length() == 0) {
                    if (!layerName.equals(EMPTY)) continue;
                    newFeatureCollection.add((Feature)feature.clone());
                    continue;
                }
                if (!attributeString.equals(layerName)) continue;
                newFeatureCollection.add((Feature)feature.clone());
            }
        }
        context.getLayerManager().setFiringEvents(wasFiringEvents);
        context.getLayerViewPanel().repaint();
        return newLayes;
    }
}

