/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class InvertSelectionPlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.EDIT}, I18N.get("org.openjump.core.ui.plugin.edit.InvertSelectionPlugIn.invert-selection") + "{pos:6}", false, null, (EnableCheck)this.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection oldSelectedFeatures = new ArrayList();
        ArrayList<Feature> newSelectedFeatures = new ArrayList<Feature>();
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        SelectionManager selectionManager = layerViewPanel.getSelectionManager();
        Collection layers = selectionManager.getLayersWithSelectedItems();
        for (Layer layer : layers) {
            newSelectedFeatures.clear();
            oldSelectedFeatures = selectionManager.getFeaturesWithSelectedItems(layer);
            selectionManager.getFeatureSelection().unselectItems(layer);
            if (layer.isVisible()) {
                TreeSet<Integer> ids = new TreeSet<Integer>();
                Iterator it = oldSelectedFeatures.iterator();
                while (it.hasNext()) {
                    ids.add(new Integer(((Feature)it.next()).getID()));
                }
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                Iterator i = featureCollection.iterator();
                while (i.hasNext()) {
                    Feature feature = (Feature)i.next();
                    if (ids.contains(new Integer(feature.getID()))) continue;
                    newSelectedFeatures.add(feature);
                }
            }
            selectionManager.getFeatureSelection().selectItems(layer, newSelectedFeatures);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

