/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreDataSource;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Color;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openjump.core.ui.plugin.datastore.AddDataStoreLayerWizardPanel;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

public class AddDataStoreLayerWizard
extends AbstractWizardGroup {
    private static final String KEY = AddDataStoreLayerWizard.class.getName();
    private AddDataStoreLayerWizardPanel dataStoreWizardPanel;
    private WorkbenchContext workbenchContext;
    private ChooseProjectPanel chooseProjectPanel;

    public AddDataStoreLayerWizard(WorkbenchContext workbenchContext) {
        super(I18N.get(KEY), IconLoader.icon((String)"Table.gif"), AddDataStoreLayerWizardPanel.class.getName());
        this.workbenchContext = workbenchContext;
        this.dataStoreWizardPanel = new AddDataStoreLayerWizardPanel(workbenchContext);
        this.addPanel(this.dataStoreWizardPanel);
        this.chooseProjectPanel = new ChooseProjectPanel(workbenchContext, this.dataStoreWizardPanel.getID());
        this.addPanel((WizardPanel)this.chooseProjectPanel);
    }

    public String getFirstId() {
        String firstId = super.getFirstId();
        if (!this.chooseProjectPanel.hasActiveTaskFrame() && this.chooseProjectPanel.hasTaskFrames()) {
            this.chooseProjectPanel.setNextID(firstId);
            return this.chooseProjectPanel.getID();
        }
        return firstId;
    }

    public void run(WizardDialog dialog, TaskMonitor monitor) {
        this.chooseProjectPanel.activateSelectedProject();
        try {
            AddDatastoreLayerPanel dataStorePanel = this.dataStoreWizardPanel.getDataStorePanel();
            final Layer layer = this.createLayer(dataStorePanel, monitor);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Collection selectedCategories = AddDataStoreLayerWizard.this.workbenchContext.getLayerNamePanel().getSelectedCategories();
                    LayerManager layerManager = AddDataStoreLayerWizard.this.workbenchContext.getLayerManager();
                    String categoryName = StandardCategoryNames.WORKING;
                    if (!selectedCategories.isEmpty()) {
                        categoryName = ((Category)selectedCategories.iterator().next()).getName();
                    }
                    try {
                        AddDataStoreLayerWizard.this.workbenchContext.getLayerViewPanel().getViewport().update();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    layerManager.addLayerable(categoryName, (Layerable)layer);
                }
            });
            this.workbenchContext.getLayerViewPanel().getViewport().update();
        }
        catch (Exception e) {
            monitor.report(e);
        }
    }

    private Layer createLayer(AddDatastoreLayerPanel panel, TaskMonitor monitor) throws Exception {
        String datasetName = panel.getDatasetName();
        LayerManager layerManager = this.workbenchContext.getLayerManager();
        Color fillColor = layerManager.generateLayerFillColor();
        FeatureCollection featureCollection = AddNewLayerPlugIn.createBlankFeatureCollection();
        Layer layer = new Layer(datasetName, fillColor, featureCollection, layerManager);
        String geometryAttributeName = panel.getGeometryAttributeName();
        String whereClause = panel.getWhereClause();
        ConnectionDescriptor connectionDescriptor = panel.getConnectionDescriptor();
        boolean caching = panel.isCaching();
        DataStoreDataSource ds = new DataStoreDataSource(datasetName, geometryAttributeName, whereClause, connectionDescriptor, caching, this.workbenchContext);
        DataSourceQuery dsq = new DataSourceQuery((DataSource)ds, null, datasetName);
        layer.setDataSourceQuery(dsq);
        CoordinateSystemRegistry crsRegistry = CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard());
        layerManager.setFiringEvents(false);
        AddDataStoreLayerWizard.load(layer, crsRegistry, monitor);
        layerManager.setFiringEvents(true);
        return layer;
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        layer.setFeatureCollection(AddDataStoreLayerWizard.executeQuery(layer.getDataSourceQuery().getQuery(), layer.getDataSourceQuery().getDataSource(), registry, monitor));
        layer.setFeatureCollectionModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        Connection connection = dataSource.getConnection();
        try {
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(connection.executeQuery(query, monitor), registry);
            return featureCollection;
        }
        finally {
            connection.close();
        }
    }
}

