/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.io.file;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openjump.core.ui.io.file.AbstractFileLayerLoader;
import org.openjump.core.ui.util.TaskUtil;
import org.openjump.util.UriUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencedImageFactoryFileLayerLoader
extends AbstractFileLayerLoader {
    private Class dataSourceClass;
    private WorkbenchContext workbenchContext;
    private ReferencedImageFactory imageFactory;
    private String[] supportFileExtensions;

    public ReferencedImageFactoryFileLayerLoader(WorkbenchContext workbenchContext, ReferencedImageFactory imageFactory, String[] supportFileExtensions) {
        super(imageFactory.getDescription(), Arrays.asList(imageFactory.getExtensions()));
        this.imageFactory = imageFactory;
        this.workbenchContext = workbenchContext;
        this.supportFileExtensions = supportFileExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean open(TaskMonitor monitor, URI uri, Map<String, Object> options) {
        File file;
        block9: {
            if (uri.getScheme().equals("zip")) {
                try {
                    File zipFileName = UriUtil.getZipFile(uri);
                    String entryPath = UriUtil.getZipEntryFilePath(uri);
                    String entryFileName = UriUtil.getFileName(uri);
                    String entryBaseName = UriUtil.getFileNameWithoutExtension(uri);
                    ZipFile zipFile = new ZipFile(zipFileName);
                    try {
                        monitor.report("Decompressing: " + entryFileName);
                        file = this.unzip(zipFile, entryPath, entryFileName);
                        if (this.supportFileExtensions != null) {
                            for (String extension : this.supportFileExtensions) {
                                monitor.report("Decompressing: " + entryBaseName + "." + extension);
                                this.unzip(zipFile, entryPath, entryBaseName + "." + extension);
                            }
                        }
                        break block9;
                    }
                    finally {
                        zipFile.close();
                    }
                }
                catch (Exception e) {
                    monitor.report(e);
                    return false;
                }
            }
            file = new File(uri);
        }
        LayerManager layerManager = this.workbenchContext.getLayerManager();
        layerManager.setFiringEvents(false);
        Layer layer = this.createLayer(layerManager, file);
        layerManager.setFiringEvents(true);
        Category category = TaskUtil.getSelectedCategoryName(this.workbenchContext);
        category.add(0, (Layerable)layer);
        Feature feature = this.createFeature(this.imageFactory, file, this.getImageryLayerDataset(layer));
        layer.getFeatureCollectionWrapper().add(feature);
        String imageFilePath = (String)feature.getAttribute("IMAGEFILE");
        if (this.imageFactory.isEditableImage(imageFilePath)) {
            layer.setSelectable(true);
            layer.setEditable(true);
            layer.setReadonly(false);
            return true;
        }
        layer.setSelectable(false);
        layer.setEditable(false);
        layer.setReadonly(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzip(ZipFile zipFile, String path, String name) throws IOException {
        String entryName = path != null ? path + "/" + name : name;
        ZipEntry entry = zipFile.getEntry(entryName);
        if (entry != null) {
            File file = new File(System.getProperty("java.io.tmpdir"), name);
            file.deleteOnExit();
            InputStream in = zipFile.getInputStream(entry);
            ReadableByteChannel rc = null;
            FileOutputStream out = null;
            try {
                long written;
                rc = Channels.newChannel(in);
                out = new FileOutputStream(file);
                FileChannel fc = out.getChannel();
                int attempts = 0;
                long sz = entry.getSize();
                for (long count = 0L; count < sz; count += written) {
                    written = fc.transferFrom(rc, count, sz);
                    if (written == 0L) {
                        if (++attempts <= 100) continue;
                        throw new IOException("Error writing to file " + file);
                    }
                    attempts = 0;
                }
                out.close();
                out = null;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex) {}
                }
            }
            return file;
        }
        return null;
    }

    private ImageryLayerDataset getImageryLayerDataset(Layer layer) {
        ReferencedImageStyle irs = (ReferencedImageStyle)layer.getStyle(ReferencedImageStyle.class);
        return irs.getImageryLayerDataset();
    }

    private Feature createFeature(ReferencedImageFactory referencedImageFactory, File file, ImageryLayerDataset imageryLayerDataset) {
        BasicFeature feature = new BasicFeature(ImageryLayerDataset.getSchema());
        feature.setAttribute("IMAGEFILE", (Object)file.getPath());
        feature.setAttribute("IMAGEFORMAT", (Object)referencedImageFactory.getTypeName());
        feature.setAttribute("IMAGEFACT", (Object)referencedImageFactory.getClass().getName());
        feature.setGeometry((Geometry)new GeometryFactory().createPoint((Coordinate)null));
        imageryLayerDataset.createImage((Feature)feature);
        return feature;
    }

    private Layer createLayer(LayerManager layerManager, File file) {
        Layer layer = new Layer(file.getName(), Color.black, (FeatureCollection)new FeatureDataset(ImageryLayerDataset.getSchema()), layerManager);
        layer.setEditable(true);
        layer.getBasicStyle().setEnabled(false);
        layer.getBasicStyle().setRenderingFill(false);
        layer.addStyle((Style)new ReferencedImageStyle());
        return layer;
    }
}

