/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.openjump.core.rasterimage.RasterImageLayer;

public class RasterImageRenderer
extends ImageCachingRenderer {
    protected boolean doneRendering = true;

    public RasterImageRenderer(Object contentID, LayerViewPanel panel) {
        super(contentID, panel);
    }

    protected RasterImageLayer getRasterImageLayer() {
        return (RasterImageLayer)this.getContentID();
    }

    public ThreadSafeImage getImage() {
        if (!this.getLayer().isVisible()) {
            return null;
        }
        return super.getImage();
    }

    public Runnable createRunnable() {
        if (!LayerRenderer.render((Layerable)this.getLayer(), (LayerViewPanel)this.panel)) {
            return null;
        }
        return super.createRunnable();
    }

    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render((Layerable)this.getLayer(), (LayerViewPanel)this.panel)) {
            return;
        }
        super.copyTo(graphics);
    }

    private RasterImageLayer getLayer() {
        return (RasterImageLayer)this.getContentID();
    }

    protected void renderHook(ThreadSafeImage image) throws Exception {
        if (!this.getRasterImageLayer().isVisible()) {
            return;
        }
        while (!this.doneRendering) {
            Thread.sleep(50L);
        }
        this.doneRendering = false;
        RasterImageLayer rLayer = this.getRasterImageLayer();
        Envelope realWorldCoordinates = new Envelope(rLayer.getEnvelope());
        final Point2D upperLeftCorner = this.panel.getViewport().toViewPoint(new Coordinate(realWorldCoordinates.getMinX(), realWorldCoordinates.getMaxY()));
        final BufferedImage sourceImage = rLayer.createImage(this.panel);
        final int xOffset = rLayer.getXOffset();
        final int yOffset = rLayer.getYOffset();
        if (sourceImage == null) {
            this.doneRendering = true;
            return;
        }
        if (this.cancelled) {
            this.doneRendering = true;
            return;
        }
        ThreadSafeImage.Drawer drawer = new ThreadSafeImage.Drawer(){

            public void draw(Graphics2D g) throws Exception {
                g.translate(upperLeftCorner.getX(), upperLeftCorner.getY());
                Object oldRenderingKey = g.getRenderingHint(RenderingHints.KEY_RENDERING);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                Object oldColorRenderingKey = g.getRenderingHint(RenderingHints.KEY_COLOR_RENDERING);
                g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                Object oldDitheringKey = g.getRenderingHint(RenderingHints.KEY_DITHERING);
                g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                Object oldAplhaInterpolationKey = g.getRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                Object oldAAKey = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setComposite(AlphaComposite.getInstance(3, 0.0f));
                g.setColor(Color.RED);
                g.fillRect(xOffset, yOffset, sourceImage.getWidth(), sourceImage.getHeight());
                g.setComposite(AlphaComposite.getInstance(3, 1.0f - (float)RasterImageRenderer.this.getRasterImageLayer().getTransparencyLevel()));
                g.drawImage((Image)sourceImage, xOffset, yOffset, null);
                if (oldRenderingKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                }
                if (oldColorRenderingKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, oldColorRenderingKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
                }
                if (oldDitheringKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, oldDitheringKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
                }
                if (oldAplhaInterpolationKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, oldAplhaInterpolationKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
                }
                if (oldAAKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                }
            }
        };
        image.draw(drawer);
        this.doneRendering = true;
    }
}

