/*
 * Decompiled with CFR 0.152.
 */
package org.openjump;

import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWImageFactory;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoTIFFImageFactory;
import com.vividsolutions.jump.workbench.imagery.graphic.GraphicImageFactory;
import com.vividsolutions.jump.workbench.imagery.mrsid.MrSIDImageFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import de.latlon.deejump.plugin.SaveLegendPlugIn;
import de.latlon.deejump.plugin.style.LayerStyle2SLDPlugIn;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPopupMenu;
import org.openjump.core.ccordsys.srid.EnsureAllLayersHaveSRIDStylePlugIn;
import org.openjump.core.rasterimage.AddRasterImageLayerWizard;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterImageLayerRendererFactory;
import org.openjump.core.ui.DatasetOptionsPanel;
import org.openjump.core.ui.io.file.DataSourceFileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.ReferencedImageFactoryFileLayerLoader;
import org.openjump.core.ui.plugin.datastore.AddDataStoreLayerWizard;
import org.openjump.core.ui.plugin.edittoolbox.ConstrainedMoveVertexPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.DrawCircleWithGivenRadiusPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedArcPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedCirclePlugIn;
import org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedLineStringPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.DrawConstrainedPolygonPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.RotateSelectedItemPlugIn;
import org.openjump.core.ui.plugin.edittoolbox.SelectOneItemPlugIn;
import org.openjump.core.ui.plugin.file.DataSourceQueryChooserOpenWizard;
import org.openjump.core.ui.plugin.file.FileDragDropPlugin;
import org.openjump.core.ui.plugin.file.OpenFilePlugIn;
import org.openjump.core.ui.plugin.file.OpenProjectPlugIn;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.file.OpenWizardPlugIn;
import org.openjump.core.ui.plugin.layer.ChangeLayerableNamePlugIn;
import org.openjump.core.ui.plugin.layer.ChangeSRIDPlugIn;
import org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn;
import org.openjump.core.ui.plugin.layer.ToggleVisiblityPlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageContextMenu;
import org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn;
import org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryOneDown;
import org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryOneUp;
import org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryToBottom;
import org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryToTop;
import org.openjump.core.ui.plugin.mousemenu.category.SetCategoryVisibilityPlugIn;
import org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn;
import org.openjump.core.ui.plugin.style.ImportSLDPlugIn;
import org.openjump.core.ui.plugin.view.EasyButtonsPlugin;
import org.openjump.core.ui.plugin.view.MapToolTipPlugIn;
import org.openjump.core.ui.plugin.view.ShowFullPathPlugIn;
import org.openjump.core.ui.plugin.view.ShowScalePlugIn;
import org.openjump.core.ui.plugin.view.ZoomToScalePlugIn;
import org.openjump.core.ui.plugin.window.MosaicInternalFramesPlugIn;
import org.openjump.core.ui.plugin.window.SynchronizationPlugIn;
import org.openjump.core.ui.plugin.wms.AddWmsLayerWizard;
import org.openjump.core.ui.plugin.wms.ZoomToWMSPlugIn;
import org.openjump.core.ui.style.decoration.ArrowLineStringMiddlepointStyle;
import org.openjump.core.ui.style.decoration.SegmentDownhillArrowStyle;
import org.openjump.core.ui.style.decoration.VertexZValueStyle;
import org.openjump.core.ui.swing.factory.field.ComboBoxFieldComponentFactory;
import org.openjump.core.ui.swing.factory.field.FieldComponentFactoryRegistry;
import org.openjump.core.ui.swing.factory.field.FileFieldComponentFactory;

public class OpenJumpConfiguration {
    public static void loadOpenJumpPlugIns(WorkbenchContext workbenchContext) throws Exception {
        PlugInContext pluginContext = workbenchContext.createPlugInContext();
        PersistentBlackboardPlugIn persistentBlackboard = new PersistentBlackboardPlugIn();
        persistentBlackboard.initialize(pluginContext);
        FieldComponentFactoryRegistry.setFactory(workbenchContext, "FileString", new FileFieldComponentFactory(workbenchContext));
        FieldComponentFactoryRegistry.setFactory(workbenchContext, "CharSetComboBoxField", new ComboBoxFieldComponentFactory(workbenchContext, null, Charset.availableCharsets().keySet().toArray()));
        OpenWizardPlugIn open = new OpenWizardPlugIn();
        open.initialize(pluginContext);
        OpenFilePlugIn openFile = new OpenFilePlugIn();
        openFile.initialize(pluginContext);
        OpenProjectPlugIn openProject = new OpenProjectPlugIn();
        openProject.initialize(pluginContext);
        OpenRecentPlugIn openRecent = OpenRecentPlugIn.get(workbenchContext);
        openRecent.initialize(pluginContext);
        FileDragDropPlugin fileDragDropPlugin = new FileDragDropPlugin();
        fileDragDropPlugin.initialize(pluginContext);
        EasyButtonsPlugin myEasyButtonsPlugIn = new EasyButtonsPlugin();
        myEasyButtonsPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ZoomToWMSPlugIn myZoomToWMSPlugIn = new ZoomToWMSPlugIn();
        myZoomToWMSPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ZoomToScalePlugIn myZoomToScalePlugIn = new ZoomToScalePlugIn();
        myZoomToScalePlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ShowScalePlugIn myShowScalePlugIn = new ShowScalePlugIn();
        myShowScalePlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        MapToolTipPlugIn myMapTipPlugIn = new MapToolTipPlugIn();
        myMapTipPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        pluginContext.getFeatureInstaller().addMenuSeparator(MenuNames.LAYER);
        LayerStyle2SLDPlugIn mySytle2SLDplugIn = new LayerStyle2SLDPlugIn();
        mySytle2SLDplugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        new ImportSLDPlugIn().initialize(pluginContext);
        new ImportArcMapStylePlugIn().initialize(pluginContext);
        pluginContext.getFeatureInstaller().addMenuSeparator(MenuNames.LAYER);
        ShowFullPathPlugIn myFullPathPlugin = new ShowFullPathPlugIn();
        myFullPathPlugin.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ToggleVisiblityPlugIn myToggleVisPlugIn = new ToggleVisiblityPlugIn();
        myToggleVisPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ChangeSRIDPlugIn myChangeSRIDPlugIn = new ChangeSRIDPlugIn();
        myChangeSRIDPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        MosaicInternalFramesPlugIn mosaicInternalFramesPlugIn = new MosaicInternalFramesPlugIn();
        mosaicInternalFramesPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        SynchronizationPlugIn synchronizationPlugIn = new SynchronizationPlugIn("");
        synchronizationPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        pluginContext.getFeatureInstaller().addMenuSeparator(MenuNames.WINDOW);
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        popupMenu.addSeparator();
        SaveDatasetsPlugIn mySaveDataSetPlugIn = new SaveDatasetsPlugIn();
        mySaveDataSetPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        LayerPropertiesPlugIn myLayerPropertiesPlugIn = new LayerPropertiesPlugIn();
        myLayerPropertiesPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ChangeLayerableNamePlugIn changeLayerableNamePlugIn = new ChangeLayerableNamePlugIn();
        changeLayerableNamePlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        RenderingManager.putRendererForLayerable(RasterImageLayer.class, (Renderer.ContentDependendFactory)new RasterImageLayerRendererFactory(pluginContext.getWorkbenchContext()));
        pluginContext.getWorkbenchFrame().getNodeClassToPopupMenuMap().put(RasterImageLayer.class, RasterImageContextMenu.getInstance(pluginContext));
        SaveLegendPlugIn saveLegend = new SaveLegendPlugIn();
        saveLegend.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        SetCategoryVisibilityPlugIn.getInstance(workbenchContext.createPlugInContext()).initialize(new PlugInContext(workbenchContext, null, null, null, null));
        new MoveCategoryToTop().initialize(new PlugInContext(workbenchContext, null, null, null, null));
        new MoveCategoryOneUp().initialize(new PlugInContext(workbenchContext, null, null, null, null));
        new MoveCategoryOneDown().initialize(new PlugInContext(workbenchContext, null, null, null, null));
        new MoveCategoryToBottom().initialize(new PlugInContext(workbenchContext, null, null, null, null));
        DrawConstrainedPolygonPlugIn myConstrainedPolygonPlugIn = new DrawConstrainedPolygonPlugIn();
        myConstrainedPolygonPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        DrawConstrainedLineStringPlugIn myConstrainedLSPlugIn = new DrawConstrainedLineStringPlugIn();
        myConstrainedLSPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        DrawConstrainedCirclePlugIn myConstrainedCPlugIn = new DrawConstrainedCirclePlugIn();
        myConstrainedCPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        DrawConstrainedArcPlugIn myConstrainedArcPlugIn = new DrawConstrainedArcPlugIn();
        myConstrainedArcPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        ConstrainedMoveVertexPlugIn myCMVPlugIn = new ConstrainedMoveVertexPlugIn();
        myCMVPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        RotateSelectedItemPlugIn myRotateSIPlugIn = new RotateSelectedItemPlugIn();
        myRotateSIPlugIn.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        SelectOneItemPlugIn mySelectOnePlugin = new SelectOneItemPlugIn();
        mySelectOnePlugin.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        DrawCircleWithGivenRadiusPlugIn drawCirclePlugin = new DrawCircleWithGivenRadiusPlugIn();
        drawCirclePlugin.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        EnsureAllLayersHaveSRIDStylePlugIn ensureLayerSRIDPlugin = new EnsureAllLayersHaveSRIDStylePlugIn();
        ensureLayerSRIDPlugin.initialize(new PlugInContext(workbenchContext, null, null, null, null));
        JUMPWorkbench workbench = workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        workbenchFrame.addChoosableStyleClass(ArrowLineStringMiddlepointStyle.NarrowSolidMiddle.class);
        workbenchFrame.addChoosableStyleClass(SegmentDownhillArrowStyle.NarrowSolidMiddle.class);
        workbenchFrame.addChoosableStyleClass(SegmentDownhillArrowStyle.Open.class);
        workbenchFrame.addChoosableStyleClass(SegmentDownhillArrowStyle.Solid.class);
        workbenchFrame.addChoosableStyleClass(VertexZValueStyle.VertexZValue.class);
        workbenchContext.getBlackboard().put(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, true);
        AddDataStoreLayerWizard addDataStoreLayerWizard = new AddDataStoreLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addDataStoreLayerWizard);
        AddWmsLayerWizard addWmsLayerWizard = new AddWmsLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addWmsLayerWizard);
        AddRasterImageLayerWizard addRasterImageLayerWizard = new AddRasterImageLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addRasterImageLayerWizard);
    }

    public static void postExtensionInitialization(WorkbenchContext workbenchContext) {
        Registry registry = workbenchContext.getRegistry();
        List loadChoosers = DataSourceQueryChooserManager.get((Blackboard)workbenchContext.getBlackboard()).getLoadDataSourceQueryChoosers();
        for (Object chooser : loadChoosers) {
            Object showCharsetSelection;
            if (!(chooser instanceof FileDataSourceQueryChooser)) continue;
            FileDataSourceQueryChooser fileChooser = (FileDataSourceQueryChooser)chooser;
            Class dataSourceClass = fileChooser.getDataSourceClass();
            String description = fileChooser.getDescription();
            List<String> extensions = Arrays.asList(fileChooser.getExtensions());
            DataSourceFileLayerLoader fileLoader = new DataSourceFileLayerLoader(workbenchContext, dataSourceClass, description, extensions);
            if (description == "GML 2.0") {
                fileLoader.addOption("Input Template File", "FileString", true);
            }
            if (dataSourceClass == StandardReaderWriterFileDataSource.Shapefile.class && (showCharsetSelection = PersistentBlackboardPlugIn.get((WorkbenchContext)workbenchContext).get(DatasetOptionsPanel.BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION)) instanceof Boolean && ((Boolean)showCharsetSelection).booleanValue()) {
                fileLoader.addOption("charset", "CharSetComboBoxField", Charset.defaultCharset().displayName(), true);
            }
            registry.createEntry((Object)FileLayerLoader.KEY, (Object)fileLoader);
        }
        OpenJumpConfiguration.addFactory(workbenchContext, registry, (ReferencedImageFactory)new GraphicImageFactory(), new String[]{"wld", "bpw", "jpw", "gfw"});
        OpenJumpConfiguration.addFactory(workbenchContext, registry, (ReferencedImageFactory)new ECWImageFactory(), null);
        OpenJumpConfiguration.addFactory(workbenchContext, registry, (ReferencedImageFactory)new GeoTIFFImageFactory(), new String[]{"tfw"});
        OpenJumpConfiguration.addFactory(workbenchContext, registry, (ReferencedImageFactory)new MrSIDImageFactory(), null);
        DataSourceQueryChooserManager manager = DataSourceQueryChooserManager.get((Blackboard)workbenchContext.getWorkbench().getBlackboard());
        for (DataSourceQueryChooser chooser : manager.getLoadDataSourceQueryChoosers()) {
            if (chooser instanceof FileDataSourceQueryChooser) continue;
            DataSourceQueryChooserOpenWizard wizard = new DataSourceQueryChooserOpenWizard(workbenchContext, chooser);
            OpenWizardPlugIn.addWizard(workbenchContext, wizard);
        }
    }

    private static void addFactory(WorkbenchContext workbenchContext, Registry registry, ReferencedImageFactory factory, String[] supportFileExtensions) {
        if (factory.isAvailable(workbenchContext)) {
            ReferencedImageFactoryFileLayerLoader loader = new ReferencedImageFactoryFileLayerLoader(workbenchContext, factory, supportFileExtensions);
            registry.createEntry((Object)FileLayerLoader.KEY, (Object)loader);
        }
    }
}

