/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.geotools.shapefile.MultiLineHandler;
import org.geotools.shapefile.MultiPointHandler;
import org.geotools.shapefile.NullShapeHandler;
import org.geotools.shapefile.PointHandler;
import org.geotools.shapefile.PolygonHandler;
import org.geotools.shapefile.ShapeHandler;
import org.geotools.shapefile.ShapeTypeNotSupportedException;
import org.geotools.shapefile.ShapefileException;
import org.geotools.shapefile.ShapefileHeader;

public class Shapefile {
    static final int SHAPEFILE_ID = 9994;
    static final int VERSION = 1000;
    public static final int NULL = 0;
    public static final int POINT = 1;
    public static final int POINTZ = 11;
    public static final int POINTM = 21;
    public static final int ARC = 3;
    public static final int ARCM = 23;
    public static final int ARCZ = 13;
    public static final int POLYGON = 5;
    public static final int POLYGONM = 25;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINT = 8;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPOINTZ = 18;
    public static final int MULTIPATCH = 31;
    public static final int UNDEFINED = -1;
    private URL baseURL;
    private InputStream myInputStream;
    private int errors;

    public Shapefile(URL url) {
        this.baseURL = url;
        this.myInputStream = null;
        try {
            URLConnection uc = this.baseURL.openConnection();
            this.myInputStream = new BufferedInputStream(uc.getInputStream(), 16384);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Shapefile(InputStream IS) {
        this.myInputStream = IS;
    }

    public void close() {
        try {
            this.myInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private EndianDataInputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Could make a connection to the URL: " + this.baseURL);
        }
        return new EndianDataInputStream(this.myInputStream);
    }

    private EndianDataOutputStream getOutputStream() throws IOException {
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(this.baseURL.getFile()));
        return new EndianDataOutputStream(in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GeometryCollection read(GeometryFactory geometryFactory) throws IOException, ShapefileException, Exception {
        EndianDataInputStream file = this.getInputStream();
        if (file == null) {
            throw new IOException("Failed connection or no content for " + this.baseURL);
        }
        ShapefileHeader mainHeader = new ShapefileHeader(file);
        if (mainHeader.getVersion() < 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + mainHeader.getVersion() + ") older that supported (" + 1000 + "), attempting to read anyway");
        }
        if (mainHeader.getVersion() > 1000) {
            System.err.println("Sf-->Warning, Shapefile format (" + mainHeader.getVersion() + ") newer that supported (" + 1000 + "), attempting to read anyway");
        }
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        int type = mainHeader.getShapeType();
        ShapeHandler handler = Shapefile.getShapeHandler(type);
        if (handler == null) {
            throw new ShapeTypeNotSupportedException("Unsuported shape type:" + type);
        }
        int recordNumber = 0;
        int contentLength = 0;
        this.errors = 0;
        try {
            while (true) {
                recordNumber = file.readIntBE();
                contentLength = file.readIntBE();
                try {
                    Geometry body = handler.read(file, geometryFactory, contentLength);
                    list.add(body);
                    if (body.getUserData() == null) continue;
                    ++this.errors;
                }
                catch (IllegalArgumentException r2d2) {
                    System.err.println("Error processing record " + recordNumber + " : " + r2d2.getMessage());
                    System.err.println("   an empty Geometry has been returned");
                    r2d2.printStackTrace();
                    list.add(handler.getEmptyGeometry(geometryFactory));
                    ++this.errors;
                }
                catch (Exception c3p0) {
                    System.err.println("Error processing record " + recordNumber + " : " + c3p0.getMessage());
                    System.err.println("   an empty Geometry has been returned");
                    c3p0.printStackTrace();
                    list.add(handler.getEmptyGeometry(geometryFactory));
                    ++this.errors;
                }
            }
        }
        catch (EOFException e) {
            return geometryFactory.createGeometryCollection(list.toArray(new Geometry[0]));
        }
    }

    public int getErrorNumber() {
        return this.errors;
    }

    public void write(GeometryCollection geometries, int ShapeFileDimension) throws IOException, Exception {
        EndianDataOutputStream file = this.getOutputStream();
        ShapefileHeader mainHeader = new ShapefileHeader(geometries, ShapeFileDimension);
        mainHeader.write(file);
        int pos = 50;
        int numShapes = geometries.getNumGeometries();
        ShapeHandler handler = geometries.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometries.getGeometryN(0), ShapeFileDimension);
        for (int i = 0; i < numShapes; ++i) {
            Geometry body = geometries.getGeometryN(i);
            file.writeIntBE(i + 1);
            file.writeIntBE(handler.getLength(body));
            pos += 4;
            handler.write(body, file);
            pos += handler.getLength(body);
        }
        file.flush();
        file.close();
    }

    public synchronized void writeIndex(GeometryCollection geometries, EndianDataOutputStream file, int ShapeFileDimension) throws IOException, Exception {
        int nrecords = geometries.getNumGeometries();
        ShapefileHeader mainHeader = new ShapefileHeader(geometries, ShapeFileDimension);
        ShapeHandler handler = geometries.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometries.getGeometryN(0), ShapeFileDimension);
        mainHeader.writeToIndex(file);
        int pos = 50;
        int len = 0;
        for (int i = 0; i < nrecords; ++i) {
            Geometry geom = geometries.getGeometryN(i);
            len = handler.getLength(geom);
            file.writeIntBE(pos);
            file.writeIntBE(len);
            pos = pos + len + 4;
        }
        file.flush();
        file.close();
    }

    public static String getShapeTypeDescription(int index) {
        switch (index) {
            case 0: {
                return "Null Shape";
            }
            case 1: {
                return "Point";
            }
            case 11: {
                return "PointZ";
            }
            case 21: {
                return "PointM";
            }
            case 3: {
                return "PolyLine";
            }
            case 23: {
                return "PolyLineM";
            }
            case 13: {
                return "PolyLineZ";
            }
            case 5: {
                return "Polygon";
            }
            case 25: {
                return "PolygonM";
            }
            case 15: {
                return "PolygonZ";
            }
            case 8: {
                return "MultiPoint";
            }
            case 28: {
                return "MultiPointM";
            }
            case 18: {
                return "MultiPointZ";
            }
        }
        return "Undefined";
    }

    public static ShapeHandler getShapeHandler(Geometry geom, int ShapeFileDimension) throws Exception {
        return Shapefile.getShapeHandler(Shapefile.getShapeType(geom, ShapeFileDimension));
    }

    public static ShapeHandler getShapeHandler(int type) throws Exception {
        switch (type) {
            case 0: {
                return new NullShapeHandler();
            }
            case 1: {
                return new PointHandler();
            }
            case 11: {
                return new PointHandler(11);
            }
            case 21: {
                return new PointHandler(21);
            }
            case 5: {
                return new PolygonHandler();
            }
            case 25: {
                return new PolygonHandler(25);
            }
            case 15: {
                return new PolygonHandler(15);
            }
            case 3: {
                return new MultiLineHandler();
            }
            case 23: {
                return new MultiLineHandler(23);
            }
            case 13: {
                return new MultiLineHandler(13);
            }
            case 8: {
                return new MultiPointHandler();
            }
            case 28: {
                return new MultiPointHandler(28);
            }
            case 18: {
                return new MultiPointHandler(18);
            }
        }
        return null;
    }

    public static int getShapeType(Geometry geom, int ShapeFileDimension) throws ShapefileException {
        if (ShapeFileDimension != 2 && ShapeFileDimension != 3 && ShapeFileDimension != 4) {
            throw new ShapefileException("invalid ShapeFileDimension for getShapeType - expected 2,3,or 4 but got " + ShapeFileDimension + "  (2=x,y ; 3=x,y,m ; 4=x,y,z,m)");
        }
        if (geom instanceof Point) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 21;
                }
                case 4: {
                    return 11;
                }
            }
        }
        if (geom instanceof MultiPoint) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 8;
                }
                case 3: {
                    return 28;
                }
                case 4: {
                    return 18;
                }
            }
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 5;
                }
                case 3: {
                    return 25;
                }
                case 4: {
                    return 15;
                }
            }
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 23;
                }
                case 4: {
                    return 13;
                }
            }
        }
        if (geom instanceof GeometryCollection && geom.isEmpty()) {
            return 0;
        }
        return -1;
    }

    public synchronized void readIndex(InputStream is) throws IOException {
        EndianDataInputStream file = null;
        try {
            BufferedInputStream in = new BufferedInputStream(is);
            file = new EndianDataInputStream(in);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ShapefileHeader head = new ShapefileHeader(file);
        boolean pos = false;
        boolean len = false;
        file.close();
    }
}

