/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;

public class NullShapeHandler
implements ShapeHandler {
    int myShapeType = -1;

    public NullShapeHandler(int type) throws InvalidShapefileException {
        if (type != 0) {
            throw new InvalidShapefileException("NullShapeHandler constructor: expected a type of 0");
        }
        this.myShapeType = type;
    }

    public NullShapeHandler() {
        this.myShapeType = 0;
    }

    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        int actualReadWords = 0;
        GeometryCollection geom = null;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            geom = geometryFactory.createGeometryCollection(new Geometry[0]);
        } else if (shapeType != this.myShapeType) {
            throw new InvalidShapefileException("nullshapehandler.read() - handler's shapetype doesnt match file's");
        }
        while (actualReadWords < contentLength) {
            short junk2 = file.readShortBE();
            ++actualReadWords;
        }
        return geom;
    }

    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        file.writeIntLE(0);
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        return 2;
    }

    public Geometry getEmptyGeometry(GeometryFactory factory) {
        return factory.createPoint((CoordinateSequence)new CoordinateArraySequence(0));
    }
}

