/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.manager;

import com.vividsolutions.jump.util.StringUtil;
import de.latlon.deejump.plugin.manager.ExtensionWrapper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ExtensionPanel
extends JPanel {
    private ExtensionWrapper cataloguedExtension;
    private JCheckBox installCheck;

    public ExtensionPanel(ExtensionWrapper catExtension) {
        this.cataloguedExtension = catExtension;
        this.initGUI();
        Dimension dim = new Dimension(300, 40);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
    }

    private void initGUI() {
        final String label = StringUtil.limitLength(this.cataloguedExtension.getTitle(), 30) + " (" + this.cataloguedExtension.getCategory() + ") ";
        this.installCheck = new JCheckBox(label, this.cataloguedExtension.isInstalled());
        this.installCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("label: " + label);
                ExtensionPanel.this.cataloguedExtension.setInstalled(ExtensionPanel.this.installCheck.isSelected());
            }
        });
        Dimension dim = new Dimension(286, 36);
        this.installCheck.setPreferredSize(dim);
        this.installCheck.setMinimumSize(dim);
        this.installCheck.setAlignmentX(0.2f);
        this.add(this.installCheck);
    }

    public String getExtensionText() {
        return this.cataloguedExtension.toString();
    }

    public void setEnabled(boolean on) {
        super.setEnabled(on);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(on);
        }
    }

    public void setSelected(boolean selected) {
        this.installCheck.setSelected(selected);
        this.cataloguedExtension.setInstalled(selected);
    }
}

