/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.jdbc.ValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PostgisValueConverterFactory {
    private final ValueConverter WKT_GEOMETRY_MAPPER = new WKTGeometryValueConverter();
    private final ValueConverter WKB_GEOMETRY_MAPPER = new WKBGeometryValueConverter();
    private final Connection conn;
    private final WKBReader wkbReader = new WKBReader();
    private final WKTReader wktReader = new WKTReader();

    public PostgisValueConverterFactory(Connection conn) {
        this.conn = conn;
    }

    public ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        String classname = rsm.getColumnClassName(columnIndex);
        String dbTypeName = rsm.getColumnTypeName(columnIndex);
        if (dbTypeName.equalsIgnoreCase("geometry")) {
            return this.WKB_GEOMETRY_MAPPER;
        }
        if (dbTypeName.equalsIgnoreCase("bytea")) {
            return this.WKB_GEOMETRY_MAPPER;
        }
        ValueConverter stdConverter = ValueConverterFactory.getConverter(rsm, columnIndex);
        if (stdConverter != null) {
            return stdConverter;
        }
        return ValueConverterFactory.STRING_MAPPER;
    }

    class WKBGeometryValueConverter
    implements ValueConverter {
        WKBGeometryValueConverter() {
        }

        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes == null) {
                return PostgisValueConverterFactory.this.wktReader.read("GEOMETRYCOLLECTION EMPTY");
            }
            return PostgisValueConverterFactory.this.wkbReader.read(bytes);
        }
    }

    class WKTGeometryValueConverter
    implements ValueConverter {
        WKTGeometryValueConverter() {
        }

        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            Object valObj = rs.getObject(columnIndex);
            if (valObj == null) {
                return PostgisValueConverterFactory.this.wktReader.read("GEOMETRYCOLLECTION EMPTY");
            }
            return PostgisValueConverterFactory.this.wktReader.read(valObj.toString());
        }
    }
}

