/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.ByteGetter;
import org.postgis.binary.ValueGetter;

public class BinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized Geometry parse(String string) {
        ByteGetter.StringByteGetter stringByteGetter = new ByteGetter.StringByteGetter(string);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(stringByteGetter));
    }

    public synchronized Geometry parse(byte[] byArray) {
        ByteGetter.BinaryByteGetter binaryByteGetter = new ByteGetter.BinaryByteGetter(byArray);
        return this.parseGeometry(BinaryParser.valueGetterForEndian(binaryByteGetter));
    }

    protected Geometry parseGeometry(ValueGetter valueGetter) {
        Geometry geometry;
        byte by = valueGetter.getByte();
        if (by != valueGetter.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int n = valueGetter.getInt();
        int n2 = n & 0x1FFFFFFF;
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        boolean bl2 = (n & 0x40000000) != 0;
        boolean bl3 = (n & 0x20000000) != 0;
        int n3 = -1;
        if (bl3) {
            n3 = valueGetter.getInt();
        }
        switch (n2) {
            case 1: {
                geometry = this.parsePoint(valueGetter, bl, bl2);
                break;
            }
            case 2: {
                geometry = this.parseLineString(valueGetter, bl, bl2);
                break;
            }
            case 3: {
                geometry = this.parsePolygon(valueGetter, bl, bl2);
                break;
            }
            case 4: {
                geometry = this.parseMultiPoint(valueGetter);
                break;
            }
            case 5: {
                geometry = this.parseMultiLineString(valueGetter);
                break;
            }
            case 6: {
                geometry = this.parseMultiPolygon(valueGetter);
                break;
            }
            case 7: {
                geometry = this.parseCollection(valueGetter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        Geometry geometry2 = geometry;
        if (bl3) {
            geometry2.setSrid(n3);
        }
        return geometry2;
    }

    private Point parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point point;
        double d = valueGetter.getDouble();
        double d2 = valueGetter.getDouble();
        if (bl) {
            double d3 = valueGetter.getDouble();
            point = new Point(d, d2, d3);
        } else {
            point = new Point(d, d2);
        }
        if (bl2) {
            point.setM(valueGetter.getDouble());
        }
        return point;
    }

    private void parseGeometryArray(ValueGetter valueGetter, Geometry[] geometryArray) {
        for (int i = 0; i < geometryArray.length; ++i) {
            geometryArray[i] = this.parseGeometry(valueGetter);
        }
    }

    private Point[] parsePointArray(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n = valueGetter.getInt();
        Point[] pointArray = new Point[n];
        for (int i = 0; i < n; ++i) {
            pointArray[i] = this.parsePoint(valueGetter, bl, bl2);
        }
        return pointArray;
    }

    private MultiPoint parseMultiPoint(ValueGetter valueGetter) {
        Geometry[] geometryArray = new Point[valueGetter.getInt()];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPoint((Point[])geometryArray);
    }

    private LineString parseLineString(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point[] pointArray = this.parsePointArray(valueGetter, bl, bl2);
        return new LineString(pointArray);
    }

    private LinearRing parseLinearRing(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point[] pointArray = this.parsePointArray(valueGetter, bl, bl2);
        return new LinearRing(pointArray);
    }

    private Polygon parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n = valueGetter.getInt();
        LinearRing[] linearRingArray = new LinearRing[n];
        for (int i = 0; i < n; ++i) {
            linearRingArray[i] = this.parseLinearRing(valueGetter, bl, bl2);
        }
        return new Polygon(linearRingArray);
    }

    private MultiLineString parseMultiLineString(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new LineString[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiLineString((LineString[])geometryArray);
    }

    private MultiPolygon parseMultiPolygon(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new Polygon[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPolygon((Polygon[])geometryArray);
    }

    private GeometryCollection parseCollection(ValueGetter valueGetter) {
        int n = valueGetter.getInt();
        Geometry[] geometryArray = new Geometry[n];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new GeometryCollection(geometryArray);
    }
}

