/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Element;

public class SVGRectElementBridge
extends SVGShapeElementBridge {
    public String getLocalName() {
        return "rect";
    }

    public Bridge getInstance() {
        return new SVGRectElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        try {
            float f;
            SVGOMRectElement sVGOMRectElement = (SVGOMRectElement)element;
            float f2 = sVGOMRectElement.getX().getAnimVal().getValue();
            float f3 = sVGOMRectElement.getY().getAnimVal().getValue();
            float f4 = sVGOMRectElement.getWidth().getAnimVal().getValue();
            float f5 = sVGOMRectElement.getHeight().getAnimVal().getValue();
            float f6 = sVGOMRectElement.getRx().getAnimVal().getValue();
            if (f6 > f4 / 2.0f) {
                f6 = f4 / 2.0f;
            }
            if ((f = sVGOMRectElement.getRy().getAnimVal().getValue()) > f5 / 2.0f) {
                f = f5 / 2.0f;
            }
            RectangularShape rectangularShape = f6 == 0.0f || f == 0.0f ? new Rectangle2D.Float(f2, f3, f4, f5) : new RoundRectangle2D.Float(f2, f3, f4, f5, f6 * 2.0f, f * 2.0f);
            shapeNode.setShape(rectangularShape);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("x") || string.equals("y") || string.equals("width") || string.equals("height") || string.equals("rx") || string.equals("ry"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Shape shape = shapeNode.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(bridgeContext, element, shapeNode);
    }
}

