/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class AbstractWMFPainter {
    public static final String WMF_FILE_EXTENSION = ".wmf";
    protected WMFFont wmfFont = null;
    protected int currentHorizAlign = 0;
    protected int currentVertAlign = 0;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;
    protected WMFRecordStore currentStore;
    protected transient boolean bReadingWMF = true;
    protected transient BufferedInputStream bufStream = null;

    protected BufferedImage getImage(byte[] byArray, int n, int n2) {
        int n3 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n4 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        if (n != n3 || n2 != n4) {
            return null;
        }
        return this.getImage(byArray);
    }

    protected Dimension getImageDimension(byte[] byArray) {
        int n = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n2 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        return new Dimension(n, n2);
    }

    protected BufferedImage getImage(byte[] byArray) {
        int n = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n2 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        int[] nArray = new int[n * n2];
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        int n4 = (byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF;
        int n5 = (byArray[15] & 0xFF) << 8 | byArray[14] & 0xFF;
        int n6 = (byArray[23] & 0xFF) << 24 | (byArray[22] & 0xFF) << 16 | (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
        if (n6 == 0) {
            n6 = ((n * n5 + 31 & 0xFFFFFFE0) >> 3) * n2;
        }
        int n7 = (byArray[35] & 0xFF) << 24 | (byArray[34] & 0xFF) << 16 | (byArray[33] & 0xFF) << 8 | byArray[32] & 0xFF;
        if (n5 == 24) {
            int n8 = n6 / n2 - n * 3;
            int n9 = n3;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[n * (n2 - i - 1) + j] = 0xFF000000 | (byArray[n9 + 2] & 0xFF) << 16 | (byArray[n9 + 1] & 0xFF) << 8 | byArray[n9] & 0xFF;
                    n9 += 3;
                }
                n9 += n8;
            }
        } else if (n5 == 8) {
            int n10;
            int n11 = 0;
            n11 = n7 > 0 ? n7 : 256;
            int n12 = n3;
            int[] nArray2 = new int[n11];
            for (n10 = 0; n10 < n11; ++n10) {
                nArray2[n10] = 0xFF000000 | (byArray[n12 + 2] & 0xFF) << 16 | (byArray[n12 + 1] & 0xFF) << 8 | byArray[n12] & 0xFF;
                n12 += 4;
            }
            n10 = n6 / n2 - n;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[n * (n2 - i - 1) + j] = nArray2[byArray[n12] & 0xFF];
                    ++n12;
                }
                n12 += n10;
            }
        } else if (n5 == 1) {
            int n13;
            int n14 = 2;
            int n15 = n3;
            int[] nArray3 = new int[n14];
            for (n13 = 0; n13 < n14; ++n13) {
                nArray3[n13] = 0xFF000000 | (byArray[n15 + 2] & 0xFF) << 16 | (byArray[n15 + 1] & 0xFF) << 8 | byArray[n15] & 0xFF;
                n15 += 4;
            }
            n13 = 7;
            byte by = byArray[n15];
            int n16 = n6 / n2 - n / 8;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[n * (n2 - i - 1) + j] = (by & 1 << n13) != 0 ? nArray3[1] : nArray3[0];
                    if (--n13 != -1) continue;
                    n13 = 7;
                    by = byArray[++n15];
                }
                n13 = 7;
                if ((n15 += n16) >= byArray.length) continue;
                by = byArray[n15];
            }
        }
        writableRaster.setDataElements(0, 0, n, n2, nArray);
        return bufferedImage;
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D graphics2D, String string, WMFFont wMFFont) {
        return this.getAttributedString(graphics2D, string, wMFFont).getIterator();
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D graphics2D, String string, WMFFont wMFFont, int n) {
        AttributedString attributedString = this.getAttributedString(graphics2D, string, wMFFont);
        return attributedString.getIterator();
    }

    protected AttributedString getAttributedString(Graphics2D graphics2D, String string, WMFFont wMFFont) {
        AttributedString attributedString = new AttributedString(string);
        Font font = graphics2D.getFont();
        attributedString.addAttribute(TextAttribute.SIZE, new Float(font.getSize2D()));
        attributedString.addAttribute(TextAttribute.FONT, font);
        if (this.wmfFont.underline != 0) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.wmfFont.italic != 0) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        if (this.wmfFont.weight > 400) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        return attributedString;
    }

    public void setRecordStore(WMFRecordStore wMFRecordStore) {
        if (wMFRecordStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = wMFRecordStore;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }

    protected int addObject(WMFRecordStore wMFRecordStore, int n, Object object) {
        return this.currentStore.addObject(n, object);
    }

    protected int addObjectAt(WMFRecordStore wMFRecordStore, int n, Object object, int n2) {
        return this.currentStore.addObjectAt(n, object, n2);
    }
}

