/*
 * Decompiled with CFR 0.152.
 */
package com.ermapper.ecw;

import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFile;
import com.ermapper.ecw.JNCSFileNotOpenException;
import com.ermapper.ecw.JNCSFileOpenFailedException;
import com.ermapper.ecw.JNCSInvalidSetViewException;
import com.ermapper.util.JNCSDatasetPoint;
import com.ermapper.util.JNCSWorldPoint;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.StringTokenizer;

public class JNCSRenderer
extends JNCSFile {
    private double dRendererSetViewWorldTLX;
    private double dRendererSetViewWorldTLY;
    private double dRendererSetViewWorldBRX;
    private double dRendererSetViewWorldBRY;
    private int dRendererSetViewDatasetTLX;
    private int dRendererSetViewDatasetTLY;
    private int dRendererSetViewDatasetBRX;
    private int dRendererSetViewDatasetBRY;
    private int dRendererSetViewWidth;
    private int dRendererSetViewHeight;
    private int[] pRGBArray = null;
    private double[] outputDeviceCoords = new double[4];
    private double dRendererWorldTLX;
    private double dRendererWorldTLY;
    private double dRendererWorldBRX;
    private double dRendererWorldBRY;
    private Image ecwImage = null;
    private int prevImageSizeX = -1;
    private int prevImageSizeY = -1;
    private boolean bHaveValidSetView = false;
    private float transparencyValue = 1.0f;
    private AlphaComposite alphaComposite = null;
    private static boolean bHave1_2VM = false;
    private MemoryImageSource memImSource = null;
    private static DirectColorModel ecwColorModel = null;
    private static final boolean bOptimizeImageStretch = true;

    public JNCSRenderer() throws JNCSException {
    }

    public JNCSRenderer(String string, boolean bl) throws JNCSFileOpenFailedException, JNCSException {
        this.open(string, bl);
    }

    public void setTransparency(float f) {
        this.transparencyValue = f;
        if (bHave1_2VM) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.transparencyValue);
        }
    }

    public int setView(int n, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        if (n2 < 0) {
            n8 = 0;
        }
        if (n3 < 0) {
            n9 = 0;
        }
        if (n4 > this.width - 1) {
            n10 = this.width - 1;
        }
        if (n5 > this.height - 1) {
            n11 = this.height - 1;
        }
        int n12 = (int)Math.round((double)(n8 - n2) / (double)(n4 - n2) * (double)n6);
        int n13 = (int)Math.round((double)(n9 - n3) / (double)(n5 - n3) * (double)n7);
        int n14 = (int)Math.round((double)(n10 - n2) / (double)(n4 - n2) * (double)n6);
        int n15 = (int)Math.round((double)(n11 - n3) / (double)(n5 - n3) * (double)n7);
        super.setView(n, nArray, n8, n9, n10, n11, n14 - n12, n15 - n13);
        this.bHaveValidSetView = true;
        if (!this.progressive) {
            this.dRendererSetViewDatasetTLX = n8;
            this.dRendererSetViewDatasetTLY = n8;
            this.dRendererSetViewDatasetBRX = n10;
            this.dRendererSetViewDatasetBRY = n11;
            this.dRendererSetViewWidth = n14 - n12;
            this.dRendererSetViewHeight = n15 - n13;
        }
        return 0;
    }

    public int setView(int n, int[] nArray, double d, double d2, double d3, double d4, int n2, int n3) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        JNCSDatasetPoint jNCSDatasetPoint = this.convertWorldToDataset(d, d2);
        JNCSDatasetPoint jNCSDatasetPoint2 = this.convertWorldToDataset(d3, d4);
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        jNCSDatasetPoint.x = (int)Math.floor((d5 - this.originX) / this.cellIncrementX);
        jNCSDatasetPoint.y = (int)Math.floor((d6 - this.originY) / this.cellIncrementY);
        jNCSDatasetPoint2.x = (int)Math.ceil((d7 - this.originX) / this.cellIncrementX);
        jNCSDatasetPoint2.y = (int)Math.ceil((d8 - this.originY) / this.cellIncrementY);
        JNCSWorldPoint jNCSWorldPoint = this.convertDatasetToWorld(jNCSDatasetPoint.x, jNCSDatasetPoint.y);
        JNCSWorldPoint jNCSWorldPoint2 = this.convertDatasetToWorld(jNCSDatasetPoint2.x, jNCSDatasetPoint2.y);
        d5 = jNCSWorldPoint.x;
        d6 = jNCSWorldPoint.y;
        d7 = jNCSWorldPoint2.x;
        d8 = jNCSWorldPoint2.y;
        if (jNCSDatasetPoint.x < 0) {
            d5 = this.originX;
        }
        if (jNCSDatasetPoint.y < 0) {
            d6 = this.originY;
        }
        if (jNCSDatasetPoint2.x > this.width - 1) {
            d7 = this.originX + (double)(this.width - 1) * this.cellIncrementX;
        }
        if (jNCSDatasetPoint2.y > this.height - 1) {
            d8 = this.originY + (double)(this.height - 1) * this.cellIncrementY;
        }
        if (jNCSDatasetPoint.x < 0 && jNCSDatasetPoint2.x < 0 || jNCSDatasetPoint.x > this.width - 1 && jNCSDatasetPoint2.x > this.width - 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        if (jNCSDatasetPoint.y < 0 && jNCSDatasetPoint2.y < 0 || jNCSDatasetPoint.y > this.height - 1 && jNCSDatasetPoint2.y > this.height - 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        int n4 = (int)Math.round((d5 - d) / (d3 - d) * (double)n2);
        int n5 = (int)Math.round((d6 - d2) / (d4 - d2) * (double)n3);
        int n6 = (int)Math.round((d7 - d) / (d3 - d) * (double)n2);
        int n7 = (int)Math.round((d8 - d2) / (d4 - d2) * (double)n3);
        if (n6 - n4 > jNCSDatasetPoint2.x - jNCSDatasetPoint.x) {
            n6 = jNCSDatasetPoint2.x;
            n4 = jNCSDatasetPoint.x;
        }
        if (n7 - n5 > jNCSDatasetPoint2.y - jNCSDatasetPoint.y) {
            n7 = jNCSDatasetPoint2.y;
            n5 = jNCSDatasetPoint.y;
        }
        if (n6 - n4 < 1 || n7 - n5 < 1) {
            this.bHaveValidSetView = false;
            return 1;
        }
        super.setView(n, nArray, d5, d6, d7, d8, n6 - n4, n7 - n5);
        this.bHaveValidSetView = true;
        if (!this.progressive) {
            this.dRendererSetViewWorldTLX = d5;
            this.dRendererSetViewWorldTLY = d6;
            this.dRendererSetViewWorldBRX = d7;
            this.dRendererSetViewWorldBRY = d8;
            this.dRendererSetViewWidth = n6 - n4;
            this.dRendererSetViewHeight = n7 - n5;
        }
        return 0;
    }

    public void refreshUpdate(int n, int n2, double d, double d2, double d3, double d4) {
        this.ecwReadImage(n, n2, d, d2, d3, d4);
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(n, n2, d, d2, d3, d4);
        }
    }

    public void refreshUpdate(int n, int n2, int n3, int n4, double d, int n5) {
        this.ecwReadImage(n, n2, n3, n4, d, n5);
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(n, n2, (double)n3, (double)n4, d, (double)n5);
        }
    }

    private boolean ecwReadImage(int n, int n2, double d, double d2, double d3, double d4) {
        Image image = null;
        boolean bl = false;
        if (this.prevImageSizeX != n || this.prevImageSizeY != n2) {
            this.pRGBArray = new int[n * n2];
            this.prevImageSizeX = n;
            this.prevImageSizeY = n2;
            bl = true;
        }
        try {
            this.readImageRGBA(this.pRGBArray, n, n2);
            if (bl) {
                this.memImSource = null;
                this.memImSource = new MemoryImageSource(n, n2, (ColorModel)ecwColorModel, this.pRGBArray, 0, n);
            } else {
                this.memImSource.newPixels(this.pRGBArray, (ColorModel)ecwColorModel, 0, n);
            }
        }
        catch (JNCSException jNCSException) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("readImageRGBA failed :").append(jNCSException.toString()).append("\n"))));
            this.bHaveValidSetView = false;
            boolean bl2 = false;
            return bl2;
        }
        image = Toolkit.getDefaultToolkit().createImage(this.memImSource);
        if (this.ecwImage == null) {
            this.ecwImage = image;
            this.dRendererWorldTLX = d;
            this.dRendererWorldTLY = d2;
            this.dRendererWorldBRX = d3;
            this.dRendererWorldBRY = d4;
        } else {
            Image image2 = this.ecwImage;
            synchronized (image2) {
                this.ecwImage = image;
                this.dRendererWorldTLX = d;
                this.dRendererWorldTLY = d2;
                this.dRendererWorldBRX = d3;
                this.dRendererWorldBRY = d4;
            }
        }
        this.bHaveValidSetView = false;
        return true;
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, ImageObserver imageObserver) {
        if (!this.progressive && this.bHaveValidSetView) {
            this.ecwReadImage(this.dRendererSetViewWidth, this.dRendererSetViewHeight, this.dRendererSetViewWorldTLX, this.dRendererSetViewWorldTLY, this.dRendererSetViewWorldBRX, this.dRendererSetViewWorldBRY);
        }
        if (this.progressive && this.ecwImage == null) {
            return;
        }
        Image image = this.ecwImage;
        synchronized (image) {
            if (!bHave1_2VM || (double)this.transparencyValue != 1.0) {
                // empty if block
            }
            this.calculateDeviceCoords(n, n2, n + n3, n2 + n4, d, d2, d3, d4, this.outputDeviceCoords);
            int n5 = (int)Math.round(this.outputDeviceCoords[2] - this.outputDeviceCoords[0]);
            int n6 = (int)Math.round(this.outputDeviceCoords[3] - this.outputDeviceCoords[1]);
            int n7 = this.ecwImage.getWidth(imageObserver);
            int n8 = this.ecwImage.getHeight(imageObserver);
            if (n5 != n7 || n6 != n8) {
                if (n5 > n7 && n6 > n8) {
                    double d5 = this.outputDeviceCoords[0] < (double)n ? (double)n : this.outputDeviceCoords[0];
                    double d6 = this.outputDeviceCoords[1] < (double)n2 ? (double)n2 : this.outputDeviceCoords[1];
                    double d7 = this.outputDeviceCoords[2] > (double)(n + n3) ? (double)(n + n3) : this.outputDeviceCoords[2];
                    double d8 = this.outputDeviceCoords[3] > (double)(n2 + n4) ? (double)(n2 + n4) : this.outputDeviceCoords[3];
                    double[] dArray = JNCSRenderer.calculateImageCoords(this.outputDeviceCoords[0], this.outputDeviceCoords[1], this.outputDeviceCoords[2], this.outputDeviceCoords[3], n7, n8, d5, d6, d7, d8);
                    dArray[0] = Math.floor(dArray[0]);
                    dArray[1] = Math.floor(dArray[1]);
                    dArray[2] = Math.ceil(dArray[2]);
                    dArray[3] = Math.ceil(dArray[3]);
                    double d9 = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)n7 * dArray[0];
                    double d10 = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)n8 * dArray[1];
                    double d11 = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)n7 * dArray[2];
                    double d12 = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)n8 * dArray[3];
                    double d13 = (this.outputDeviceCoords[2] - this.outputDeviceCoords[0]) * (d9 - this.dRendererWorldTLX) / (this.dRendererWorldBRX - this.dRendererWorldTLX) + this.outputDeviceCoords[0];
                    double d14 = (this.outputDeviceCoords[3] - this.outputDeviceCoords[1]) * (d10 - this.dRendererWorldTLY) / (this.dRendererWorldBRY - this.dRendererWorldTLY) + this.outputDeviceCoords[1];
                    double d15 = (this.outputDeviceCoords[2] - this.outputDeviceCoords[0]) * (d11 - this.dRendererWorldTLX) / (this.dRendererWorldBRX - this.dRendererWorldTLX) + this.outputDeviceCoords[0];
                    double d16 = (this.outputDeviceCoords[3] - this.outputDeviceCoords[1]) * (d12 - this.dRendererWorldTLY) / (this.dRendererWorldBRY - this.dRendererWorldTLY) + this.outputDeviceCoords[1];
                    graphics.drawImage(this.ecwImage, (int)Math.round(d13), (int)Math.round(d14), (int)Math.round(d15), (int)Math.round(d16), (int)Math.floor(dArray[0]), (int)Math.floor(dArray[1]), (int)Math.ceil(dArray[2]), (int)Math.ceil(dArray[3]), imageObserver);
                } else {
                    graphics.drawImage(this.ecwImage, (int)Math.round(this.outputDeviceCoords[0]), (int)Math.round(this.outputDeviceCoords[1]), (int)Math.round(this.outputDeviceCoords[2]), (int)Math.round(this.outputDeviceCoords[3]), 0, 0, n7, n8, imageObserver);
                }
            } else {
                graphics.drawImage(this.ecwImage, (int)Math.round(this.outputDeviceCoords[0]), (int)Math.round(this.outputDeviceCoords[1]), imageObserver);
            }
            if (!bHave1_2VM || (double)this.transparencyValue != 1.0) {
                // empty if block
            }
        }
    }

    private static final double[] calculateImageCoords(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double[] dArray = new double[4];
        double d11 = (d9 - d7) * d5 / (d3 - d);
        double d12 = (d10 - d8) * d6 / (d4 - d2);
        dArray[0] = (d7 - d) * d11 / (d9 - d7);
        dArray[1] = (d8 - d2) * d12 / (d10 - d8);
        dArray[2] = dArray[0] + d11;
        dArray[3] = dArray[1] + d12;
        return dArray;
    }

    private final void calculateDeviceCoords(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, double[] dArray) {
        dArray[0] = (this.dRendererWorldTLX - d) / (d3 - d) * (double)(n3 - n);
        dArray[1] = (this.dRendererWorldTLY - d2) / (d4 - d2) * (double)(n4 - n2);
        dArray[2] = (this.dRendererWorldBRX - d) / (d3 - d) * (double)(n3 - n);
        dArray[3] = (this.dRendererWorldBRY - d2) / (d4 - d2) * (double)(n4 - n2);
    }

    private final void convertImageToWorld(int n, int n2, double d, double d2, double[] dArray) {
        dArray[0] = this.dRendererWorldTLX + (this.dRendererWorldBRX - this.dRendererWorldTLX) / (double)n * d;
        dArray[1] = this.dRendererWorldTLY + (this.dRendererWorldBRY - this.dRendererWorldTLY) / (double)n2 * d2;
    }

    static {
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n >= 1 && n2 >= 2) {
            bHave1_2VM = true;
        }
        ecwColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
    }
}

