/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.OverlayContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class OverlayContainer
extends WidgetContainer {
    private ArrayList children;
    private Dimension minSize;
    private Dimension prefSize;

    public OverlayContainer() {
        this.component = new WidgetContainerPanel(this);
        this.children = new ArrayList();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Widget getChild(int i) {
        return (Widget)this.children.get(i);
    }

    public Collection getChildren() {
        return new ArrayList(this.children);
    }

    public int getChildIndex(Widget widget) {
        return this.children.indexOf(widget);
    }

    public void layoutChildren() {
        Rectangle bounds = this.getBounds();
        for (int i = 0; i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            Dimension max = child.getMaximumSize();
            child.getComponent().setBounds(new Rectangle(0, 0, Math.min(bounds.width, max.width), Math.min(bounds.height, max.height)));
            if (!(child instanceof WidgetContainer)) continue;
            ((WidgetContainer)child).layoutChildren();
        }
    }

    public void add(Widget widget, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.children.add(index, widget);
        ((JPanel)this.component).add(widget.component, index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public void add(Widget widget) {
        this.add(widget, 0);
    }

    public void remove(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            ((JPanel)this.component).remove(widget.component);
            this.children.remove(index);
            this.removeAsParent(widget);
            this.invalidateSize();
        }
    }

    public void removeAll() {
        ((JPanel)this.component).removeAll();
        for (int i = 0; i < this.children.size(); ++i) {
            this.removeAsParent((Widget)this.children.get(i));
        }
        this.children.clear();
        this.invalidateSize();
    }

    public void setVisibleChild(int i) {
        for (int j = 0; j < this.children.size(); ++j) {
            ((Widget)this.children.get(j)).setVisible(i == j);
        }
    }

    public void setVisibleChild(Widget child) {
        for (int j = 0; j < this.children.size(); ++j) {
            Widget w;
            w.setVisible((w = (Widget)this.children.get(j)) == child);
        }
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension();
            for (int i = 0; i < this.children.size(); ++i) {
                Dimension size = ((Widget)this.children.get(i)).getMinimumSize();
                if (size.width > this.minSize.width) {
                    this.minSize.width = size.width;
                }
                if (size.height <= this.minSize.height) continue;
                this.minSize.height = size.height;
            }
        }
        return this.minSize;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension();
            for (int i = 0; i < this.children.size(); ++i) {
                Dimension size = ((Widget)this.children.get(i)).getPreferredSize();
                if (size.width > this.prefSize.width) {
                    this.prefSize.width = size.width;
                }
                if (size.height <= this.prefSize.height) continue;
                this.prefSize.height = size.height;
            }
        }
        return this.prefSize;
    }

    protected void invalidateSize() {
        this.prefSize = null;
        this.minSize = null;
        super.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(OverlayContainer.class, new OverlayContainerDelegate());
    }
}

