/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util.python;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;

public class ModifyGeometry {
    private static WorkbenchContext workbenchContext = null;
    private String name;
    private ArrayList transactions = new ArrayList();

    public ModifyGeometry(String name) {
        this.name = name;
    }

    public static void setWorkbenchContext(WorkbenchContext workContext) {
        workbenchContext = workContext;
    }

    public void commitTransactions() {
        LayerManager lm = workbenchContext.getLayerManager();
        if (lm != null) {
            UndoableEditReceiver uer = lm.getUndoableEditReceiver();
            if (uer != null) {
                uer.startReceiving();
                uer.reportNothingToUndoYet();
                EditTransaction.commit((Collection)this.transactions);
                uer.stopReceiving();
            }
        } else {
            EditTransaction.commit((Collection)this.transactions);
        }
    }

    public void addTransactionOnSelection(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection((EditTransaction.SelectionEditor)new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    ModifyGeometry.this.modify(item);
                }
                return geometryWithSelectedItems;
            }
        }, (SelectionManagerProxy)workbenchContext.getLayerViewPanel(), (LayerViewPanelContext)workbenchContext.getLayerViewPanel().getContext(), (String)this.name, (Layer)layer, (boolean)false, (boolean)false);
        this.transactions.add(transaction);
    }

    public void modify(Geometry geometry) {
    }

    public void addRemoveFeaturesTransaction(Layer layer, Collection features) {
        GeometryEditor geometryEditor = new GeometryEditor();
        EditTransaction transaction = new EditTransaction(features, this.name, layer, false, true, workbenchContext.getLayerViewPanel().getContext());
        for (Feature feature : features) {
            Geometry g = transaction.getGeometry(feature);
            g = geometryEditor.remove(g, g);
            transaction.setGeometry(feature, g);
        }
        this.transactions.add(transaction);
    }

    public void addChangeGeometryTransaction(Layer layer, Feature feature, Geometry geometry) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(feature);
        EditTransaction transaction = new EditTransaction(features, this.name, layer, false, true, workbenchContext.getLayerViewPanel().getContext());
        transaction.setGeometry(feature, geometry);
        this.transactions.add(transaction);
    }
}

