/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class UnionByAttributePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String LAYER = I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.layer");
    private static final String ATTRIBUTE = I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.attribute");
    private static final String IGNORE_EMPTY = I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.ignore-empty");
    private static final String MERGE_LINES = I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.merge-lines");
    private static final String TOTAL_NUMERIC_FIELDS = I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.total-numeric-fields");
    private MultiInputDialog dialog;
    private GeometryFactory fact;

    public String getName() {
        return I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.union-by-attribute");
    }

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.ONELAYER}, this.getName(), false, null, (EnableCheck)new MultiEnableCheck().add(new EnableCheckFactory(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(new EnableCheckFactory(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(1)));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        return this.dialog.wasOKPressed();
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.union-by-attribute"), true);
        this.dialog.setSideBarImage((Icon)IconLoader.icon((String)"UnionByAttribute.gif"));
        this.dialog.setSideBarDescription(I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.creates-a-new-layer-containing-the-unions-of-features-having-a-common-attribute-value"));
        this.dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), context.getLayerManager());
        List list = this.getFieldsFromLayerWithoutGeometry(context.getCandidateLayer(0));
        Object val = list.size() > 0 ? list.iterator().next() : null;
        final JComboBox jcb_attribute = this.dialog.addComboBox(ATTRIBUTE, val, (Collection)list, I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.select-attribute"));
        if (list.size() == 0) {
            jcb_attribute.setEnabled(false);
        }
        final JCheckBox jcb_ignore_empty = this.dialog.addCheckBox(IGNORE_EMPTY, true);
        if (list.size() == 0) {
            jcb_ignore_empty.setEnabled(false);
        }
        this.dialog.addSeparator();
        JCheckBox jcb_merge_lines = this.dialog.addCheckBox(MERGE_LINES, true);
        JCheckBox jcb_total_numeric_fields = this.dialog.addCheckBox(TOTAL_NUMERIC_FIELDS, true);
        this.dialog.getComboBox(LAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = UnionByAttributePlugIn.this.getFieldsFromLayerWithoutGeometry();
                if (list.size() == 0) {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attribute.setEnabled(false);
                    jcb_ignore_empty.setEnabled(false);
                }
                jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
        GUIUtil.centreOnWindow((Component)this.dialog);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        Layer layer = this.dialog.getLayer(LAYER);
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        FeatureSchema schema = fc.getFeatureSchema();
        String att = this.dialog.getText(ATTRIBUTE);
        boolean ignore_empty = this.dialog.getBoolean(IGNORE_EMPTY);
        boolean merge_lines = this.dialog.getBoolean(MERGE_LINES);
        boolean total_numeric_fields = this.dialog.getBoolean(TOTAL_NUMERIC_FIELDS);
        if (fc.getFeatures().size() <= 0 || ((Feature)fc.getFeatures().get(0)).getGeometry() == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.no-data-to-be-unioned"));
            return;
        }
        this.fact = ((Feature)fc.getFeatures().get(0)).getGeometry().getFactory();
        FeatureSchema newSchema = new FeatureSchema();
        newSchema.addAttribute(schema.getAttributeName(schema.getGeometryIndex()), AttributeType.GEOMETRY);
        newSchema.addAttribute(att, schema.getAttributeType(att));
        if (total_numeric_fields) {
            int max = schema.getAttributeCount();
            for (int i = 0; i < max; ++i) {
                if (schema.getAttributeType(i) != AttributeType.INTEGER && schema.getAttributeType(i) != AttributeType.DOUBLE) continue;
                newSchema.addAttribute(schema.getAttributeName(i), schema.getAttributeType(i));
            }
        }
        HashMap<Object, FeatureDataset> map = new HashMap<Object, FeatureDataset>();
        monitor.report(I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.union-by-attribute"));
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Object key = f.getAttribute(att);
            if (ignore_empty && (key == null || key.toString().trim().length() == 0)) continue;
            if (!map.containsKey(key)) {
                FeatureDataset fd = new FeatureDataset(fc.getFeatureSchema());
                fd.add(f);
                map.put(key, fd);
                continue;
            }
            ((FeatureCollection)map.get(key)).add(f);
        }
        int count = 1;
        FeatureDataset resultfc = new FeatureDataset(newSchema);
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            monitor.report(I18N.get("ui.plugin.analysis.UnionByAttributePlugIn.union-by-attribute") + " (" + count++ + "/" + map.size() + ")");
            Object key = i2.next();
            FeatureCollection fca = (FeatureCollection)map.get(key);
            if (fca.size() <= 0) continue;
            Feature feature = this.union(context, monitor, fca, merge_lines, total_numeric_fields);
            feature.setAttribute(att, key);
            BasicFeature newFeature = new BasicFeature(newSchema);
            int max = newSchema.getAttributeCount();
            for (int j = 0; j < max; ++j) {
                newFeature.setAttribute(j, feature.getAttribute(newSchema.getAttributeName(j)));
            }
            resultfc.add(newFeature);
        }
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        context.addLayer(StandardCategoryNames.RESULT, layer.getName() + "-" + att + " (union)", (FeatureCollection)resultfc);
    }

    private Feature union(PlugInContext context, TaskMonitor monitor, FeatureCollection fc, boolean merge_lines, boolean total) {
        Geometry gp;
        ArrayList<Geometry> points = new ArrayList<Geometry>();
        ArrayList<Geometry> lineStrings = new ArrayList<Geometry>();
        ArrayList<Geometry> polygons = new ArrayList<Geometry>();
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Iterator it = fc.iterator();
        while (it.hasNext()) {
            Geometry g = ((Feature)it.next()).getGeometry();
            if (g instanceof Point) {
                points.add(g);
                continue;
            }
            if (g instanceof LineString) {
                lineStrings.add(g);
                continue;
            }
            if (g instanceof Polygon) {
                polygons.add(g);
                continue;
            }
            if (!(g instanceof GeometryCollection)) continue;
            GeometryCollection gc = (GeometryCollection)g;
            for (int j = 0; j < gc.getNumGeometries(); ++j) {
                Geometry gp2 = gc.getGeometryN(j);
                if (gp2 instanceof Point) {
                    points.add(gp2);
                    continue;
                }
                if (gp2 instanceof LineString) {
                    lineStrings.add(gp2);
                    continue;
                }
                if (!(gp2 instanceof Polygon)) continue;
                polygons.add(gp2);
            }
        }
        if (points.size() > 0 && null != (gp = UnaryUnionOp.union(points))) {
            geoms.add(gp);
        }
        if (merge_lines && lineStrings.size() > 0) {
            LineMerger merger = new LineMerger();
            merger.add(lineStrings);
            geoms.addAll(merger.getMergedLineStrings());
        } else if (lineStrings.size() > 0) {
            context.getOutputFrame().addText("merge_lines = true");
            gp = UnaryUnionOp.union(lineStrings);
            if (gp != null) {
                geoms.add(gp);
            }
        }
        if (polygons.size() > 0 && null != (gp = UnaryUnionOp.union(polygons))) {
            geoms.add(gp);
        }
        FeatureSchema schema = fc.getFeatureSchema();
        Feature feature = new BasicFeature(schema);
        if (geoms.size() == 0) {
            feature.setGeometry((Geometry)this.fact.createGeometryCollection(new Geometry[0]));
        } else {
            feature.setGeometry(UnaryUnionOp.union(geoms));
        }
        if (total) {
            feature = this.totalNumericValues(fc, feature);
        }
        return feature;
    }

    private Feature totalNumericValues(FeatureCollection fc, Feature feature) {
        FeatureSchema schema = fc.getFeatureSchema();
        Iterator it = fc.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            int max = schema.getAttributeCount();
            for (int i = 0; i < max; ++i) {
                Object val;
                if (schema.getAttributeType(i) == AttributeType.INTEGER) {
                    val = feature.getAttribute(i);
                    int val1 = val == null ? 0 : (Integer)val;
                    val = f.getAttribute(i);
                    val1 = val == null ? val1 : val1 + (Integer)val;
                    feature.setAttribute(i, (Object)new Integer(val1));
                    continue;
                }
                if (schema.getAttributeType(i) != AttributeType.DOUBLE) continue;
                val = feature.getAttribute(i);
                double val1 = val == null ? 0.0 : (Double)val;
                val = f.getAttribute(i);
                val1 = val == null ? val1 : val1 + (Double)val;
                feature.setAttribute(i, (Object)new Double(val1));
            }
        }
        return feature;
    }

    private Geometry mergeLines(Geometry g) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        g.apply((GeometryComponentFilter)lineFilter);
        LineMerger merger = new LineMerger();
        merger.add(linesList);
        return this.fact.buildGeometry(merger.getMergedLineStrings());
    }

    private List getFieldsFromLayerWithoutGeometry(Layer lyr) {
        ArrayList<String> fields = new ArrayList<String>();
        FeatureSchema schema = lyr.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            fields.add(schema.getAttributeName(i));
        }
        return fields;
    }

    private List getFieldsFromLayerWithoutGeometry() {
        return this.getFieldsFromLayerWithoutGeometry(this.dialog.getLayer(LAYER));
    }
}

