/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.FMEGMLWriter;
import com.vividsolutions.jump.io.GMLWriter;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTWriter;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectPlugIn;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.ui.images.IconLoader;

public class SaveDatasetsPlugIn
extends AbstractPlugIn {
    private static final String sSaveSelectedDatasets = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Save-Selected-Datasets");
    private static final String sUseSaveDatasetAsToSaveLayer = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Use***Save-Dataset-As***to-Save-Layer");
    private static final String sSavedLayer = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Saved-Layer");
    private static final String sErrorSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Error-See-Output-Window");
    private static final String sWarningSeeOutputWindow = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Warning-See-Output-Window");
    private static final String sCouldNotSaveLayer = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Could-not-save-layer");
    private static final String sCouldNotSave = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Could-not-save");
    private static final String sLayer = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.layer");
    private static final String sWithEmptyGeometry = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.with-empty-geometry");
    private static final String sWithMixedGeometryTypes = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.with-mixed-geometry-types");
    private static final String sCanNotSaveReadOnly = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Cannot-save-to-read-only-source-for-layer");
    private static final String sDidNotSaveSameFile = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Did-not-save-these-layers-since-they-would-have-to-be-saved-to-the-same-file");
    private static final String sSavedTask = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Saved-task");
    private static final String sFileName = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.File-Name");
    private static final String sLayerName = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Layer-Name");
    private static final String sUnrecognizedFileType = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Unrecognized-file-type");
    private static final String sNewLayerCreated = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.New-layer-created");
    private static final String sCouldNotWrite = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Could-not-write");
    private static final String sEmptyLayerNotSaved = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Empty-layer-not-saved");
    private static final String sSaveFilesFromReadOnlySources = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Save-files-from-read-only-sources");
    private static final String sFiles = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Files");
    private static final String sWantToSaveReadonly = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Do-you-want-to-save-the-read-only-layers");
    private static final String sNoteLayerNameWillBeFileName = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Note-layer-name-will-be-filename");
    private static final String sReadOnlyLayer = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.read-only-layer");
    private static final String sReplacesFile = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.replaces-file");
    private static final String sReadOnlyWillReplace = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.read-only-source-will-replace-an-existing-file");
    private static final String sNoteOutputWindow = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Note-Output-window-will-display-the-results-of-this-command");
    private static final String sWouldHaveReplaced = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.The-read-only-layer-would-have-replaced-the-following-file(s)");
    private static final String sHasReplaced = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.The-read-only-layer-has-replaced-the-following-file(s)");
    private static final String sNoOutputDir = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.No-output-directory-designated-for-read-only-source-could-not-save-layer");
    private static final String sNoOutputFileExt = I18N.get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.No-output-file-extension-designated-for-read-only-source-could-not-save-layer");
    private boolean saveAll = false;
    private int saveReadOnlySources = -1;
    private String pathToSaveReadOnlySources = "";
    private String extToSaveReadOnlySources = "";
    private JFileChooser fileChooser;
    public static final ImageIcon ICON = IconLoader.icon("disk_multiple.png");

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        TitledPopupMenu layerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, sSaveSelectedDatasets + "{pos:12}", false, (Icon)ICON, (EnableCheck)SaveDatasetsPlugIn.createEnableCheck(workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        try {
            int i;
            Layer layer2;
            WorkbenchContext workbenchContext = context.getWorkbenchContext();
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogTitle(sSaveFilesFromReadOnlySources);
            this.fileChooser.setDialogType(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            GUIUtil.removeChoosableFileFilters((JFileChooser)this.fileChooser);
            FileFilter fileFilter1 = GUIUtil.createFileFilter((String)("SHP " + sFiles), (String[])new String[]{"shp"});
            this.fileChooser.addChoosableFileFilter(fileFilter1);
            FileFilter fileFilter2 = GUIUtil.createFileFilter((String)("GML " + sFiles), (String[])new String[]{"gml"});
            this.fileChooser.addChoosableFileFilter(fileFilter2);
            FileFilter fileFilter3 = GUIUtil.createFileFilter((String)("JML " + sFiles), (String[])new String[]{"jml"});
            this.fileChooser.addChoosableFileFilter(fileFilter3);
            FileFilter fileFilter4 = GUIUtil.createFileFilter((String)("FME " + sFiles), (String[])new String[]{"fme"});
            this.fileChooser.addChoosableFileFilter(fileFilter4);
            FileFilter fileFilter5 = GUIUtil.createFileFilter((String)("WKT " + sFiles), (String[])new String[]{"wkt"});
            this.fileChooser.addChoosableFileFilter(fileFilter5);
            this.fileChooser.setFileFilter(fileFilter1);
            boolean writeWarning = false;
            String newLine = "";
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            LayerManager layerManager = context.getLayerManager();
            Collection layerCollection = layerManager.getLayers();
            Iterator i2 = layerCollection.iterator();
            while (i2.hasNext()) {
                this.writeProjectionFile(context, (Layer)i2.next());
            }
            ArrayList<Layer> layerList = new ArrayList<Layer>();
            if (this.saveAll) {
                layerCollection = layerManager.getLayersWithModifiedFeatureCollections();
                Iterator i3 = layerCollection.iterator();
                while (i3.hasNext()) {
                    layerList.add((Layer)i3.next());
                }
            } else {
                layerCollection = context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layer.class);
                for (Layer layer2 : layerCollection) {
                    boolean addIt = false;
                    DataSourceQuery dsq = layer2.getDataSourceQuery();
                    if (dsq != null && !dsq.getDataSource().isWritable()) {
                        addIt = true;
                    }
                    if (!layer2.isFeatureCollectionModified() && !addIt) continue;
                    layerList.add(layer2);
                }
            }
            for (i = layerList.size() - 1; i >= 0; --i) {
                layer2 = (Layer)layerList.get(i);
                if (layer2.getFeatureCollectionWrapper().getFeatures().size() != 0) continue;
                context.getWorkbenchFrame().getOutputFrame().addText(sEmptyLayerNotSaved + ": " + layer2.getName());
                writeWarning = true;
                layerList.remove(i);
                newLine = "\n";
            }
            for (i = layerList.size() - 1; i >= 0; --i) {
                layer2 = (Layer)layerList.get(i);
                DataSourceQuery dsq = layer2.getDataSourceQuery();
                boolean writeSaveMsg = false;
                if (dsq == null) {
                    writeSaveMsg = true;
                } else {
                    DataSource ds = dsq.getDataSource();
                    if (ds == null) {
                        writeSaveMsg = true;
                    } else if (ds.getProperties().get("File") == null) {
                        writeSaveMsg = true;
                    }
                }
                if (!writeSaveMsg) continue;
                context.getWorkbenchFrame().getOutputFrame().addText(sUseSaveDatasetAsToSaveLayer + layer2.getName());
                writeWarning = true;
                layerList.remove(i);
                newLine = "\n";
            }
            this.saveReadOnlySources = -1;
            this.pathToSaveReadOnlySources = "";
            String chosenSaveFile = "";
            for (int i4 = layerList.size() - 1; i4 >= 0; --i4) {
                Layer layer3 = (Layer)layerList.get(i4);
                DataSourceQuery dsq = layer3.getDataSourceQuery();
                if (dsq.getDataSource().isWritable()) continue;
                if (this.saveReadOnlySources == -1) {
                    int response = JOptionPane.showConfirmDialog((Component)workbenchContext.getLayerViewPanel(), sWantToSaveReadonly + "\n" + "(" + sNoteLayerNameWillBeFileName + ")", "JUMP", 0);
                    this.saveReadOnlySources = 0;
                    if (response == 0 && 0 == this.fileChooser.showSaveDialog((Component)workbenchContext.getLayerViewPanel())) {
                        File file = this.fileChooser.getSelectedFile();
                        this.pathToSaveReadOnlySources = file.getParent() + "\\";
                        this.extToSaveReadOnlySources = "." + FileUtil.getExtension(file);
                        this.saveReadOnlySources = 1;
                        chosenSaveFile = file.getPath();
                    }
                }
                if (this.saveReadOnlySources != 0) continue;
                context.getWorkbenchFrame().getOutputFrame().addText(newLine + sCanNotSaveReadOnly + ": " + layer3.getName());
                writeWarning = true;
                layerList.remove(i4);
            }
            int currRec = 0;
            int lastRec = layerList.size() - 1;
            boolean writeHeader = true;
            while (currRec < lastRec) {
                Layer currLayer = (Layer)layerList.get(currRec);
                String currDestination = currLayer.getDataSourceQuery().getDataSource().getProperties().get("File").toString();
                if (!currLayer.getDataSourceQuery().getDataSource().isWritable()) {
                    currDestination = this.pathToSaveReadOnlySources + currLayer.getName() + this.extToSaveReadOnlySources;
                }
                String dupLayers = "\n" + sFileName + ": " + currDestination + "\n" + sLayerName + ": " + currLayer.getName();
                int numDups = 0;
                int checkRec = currRec + 1;
                while (checkRec <= lastRec) {
                    Layer checkLayer = (Layer)layerList.get(checkRec);
                    String checkDestination = checkLayer.getDataSourceQuery().getDataSource().getProperties().get("File").toString();
                    if (!checkLayer.getDataSourceQuery().getDataSource().isWritable()) {
                        checkDestination = this.pathToSaveReadOnlySources + checkLayer.getName() + this.extToSaveReadOnlySources;
                    }
                    if (currDestination.equals(checkDestination)) {
                        dupLayers = dupLayers + "\n" + sLayerName + ": " + checkLayer.getName();
                        layerList.remove(checkRec);
                        --lastRec;
                        ++numDups;
                        continue;
                    }
                    ++checkRec;
                }
                if (numDups > 0) {
                    if (writeHeader) {
                        writeHeader = false;
                        writeWarning = true;
                        context.getWorkbenchFrame().getOutputFrame().addText("\n" + sDidNotSaveSameFile + ":");
                        newLine = "\n";
                    }
                    context.getWorkbenchFrame().getOutputFrame().addText(dupLayers);
                    layerList.remove(currRec);
                    --lastRec;
                    continue;
                }
                ++currRec;
            }
            String replacedFiles = "";
            int numReplaced = 0;
            boolean fileMatches = false;
            for (int i5 = 0; i5 < layerList.size(); ++i5) {
                String destinationFile = "";
                Layer layer4 = (Layer)layerList.get(i5);
                DataSourceQuery dsq = layer4.getDataSourceQuery();
                if (dsq.getDataSource().isWritable() || !new File(destinationFile = this.pathToSaveReadOnlySources + layer4.getName() + this.extToSaveReadOnlySources).exists()) continue;
                ++numReplaced;
                replacedFiles = replacedFiles + sReadOnlyLayer + ": " + layer4.getName() + " " + sReplacesFile + ": " + destinationFile + "\n";
                if (!destinationFile.equalsIgnoreCase(chosenSaveFile)) continue;
                fileMatches = true;
            }
            if (numReplaced > 1 || numReplaced == 1 && !fileMatches) {
                int response;
                String prompt = numReplaced + " " + sReadOnlyWillReplace + "\n (" + sNoteOutputWindow + ")";
                if (numReplaced > 1) {
                    prompt = numReplaced + " " + sReadOnlyWillReplace + "\n (" + sNoteOutputWindow + ")";
                }
                if ((response = JOptionPane.showConfirmDialog((Component)workbenchContext.getLayerViewPanel(), prompt, "JUMP", 2)) == 2) {
                    if (numReplaced == 1) {
                        context.getWorkbenchFrame().getOutputFrame().addText(sWouldHaveReplaced + ":");
                    } else {
                        context.getWorkbenchFrame().getOutputFrame().addText(sWouldHaveReplaced + ":");
                    }
                    context.getWorkbenchFrame().getOutputFrame().addText(replacedFiles);
                    writeWarning = true;
                    return true;
                }
                if (numReplaced == 1) {
                    context.getWorkbenchFrame().getOutputFrame().addText(sHasReplaced + ":");
                } else {
                    context.getWorkbenchFrame().getOutputFrame().addText(sHasReplaced + ":");
                }
                context.getWorkbenchFrame().getOutputFrame().addText(replacedFiles);
            }
            for (int i6 = 0; i6 < layerList.size(); ++i6) {
                Layer layer5 = (Layer)layerList.get(i6);
                if (this.WriteLayer(context, layer5)) {
                    layer5.setFeatureCollectionModified(false);
                    context.getWorkbenchFrame().getOutputFrame().addText(sSavedLayer + ": " + layer5.getName());
                    continue;
                }
                context.getWorkbenchFrame().getOutputFrame().addText(sCouldNotSaveLayer + ": " + layer5.getName());
            }
            if (this.saveAll && context.getTask().getProjectFile() != null) {
                new SaveProjectPlugIn(new SaveProjectAsPlugIn()).execute(context);
                context.getWorkbenchFrame().getOutputFrame().addText("\n " + sSavedTask + ": " + context.getTask().getProjectFile().getName());
            }
            if (writeWarning) {
                context.getWorkbenchFrame().warnUser(sCouldNotSaveLayer + " --- " + sErrorSeeOutputWindow);
            }
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().addText("SaveDatasetsPlugIn Exception:" + e.toString());
            return false;
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public void setSaveAll() {
        this.saveAll = true;
    }

    private boolean WriteLayer(PlugInContext context, Layer layer) {
        String filename = "";
        DataSourceQuery dsq = layer.getDataSourceQuery();
        if (dsq.getDataSource().isWritable()) {
            filename = dsq.getDataSource().getProperties().get("File").toString();
        } else {
            filename = this.pathToSaveReadOnlySources + layer.getName() + this.extToSaveReadOnlySources;
            if (this.pathToSaveReadOnlySources.equals("")) {
                context.getWorkbenchFrame().getOutputFrame().addText(sNoOutputDir + ": " + layer.getName());
                context.getWorkbenchFrame().warnUser(sWarningSeeOutputWindow);
                return false;
            }
            if (this.extToSaveReadOnlySources.equals("")) {
                context.getWorkbenchFrame().getOutputFrame().addText(sNoOutputFileExt + ": " + layer.getName());
                context.getWorkbenchFrame().warnUser(sWarningSeeOutputWindow);
                return false;
            }
        }
        DriverProperties dp = new DriverProperties();
        dp.set("File", filename);
        try {
            if (filename.toLowerCase().endsWith(".shp")) {
                String path = new File(filename).getParent() + "\\";
                List newLayers = new ArrayList();
                if (!this.CompatibleFeatures(layer)) {
                    newLayers = this.splitLayer(context, layer);
                }
                new ShapefileWriter().write(layer.getFeatureCollectionWrapper(), dp);
                for (int i = 0; i < newLayers.size(); ++i) {
                    Layer newLayer = (Layer)newLayers.get(i);
                    String newFileName = path + newLayer.getName() + ".shp";
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("Coordinate System", "Unspecified");
                    properties.put("File", newFileName);
                    DataSource dataSource = (DataSource)StandardReaderWriterFileDataSource.Shapefile.class.newInstance();
                    dataSource.setProperties(properties);
                    DataSourceQuery dataSourceQuery = new DataSourceQuery(dataSource, newLayer.getName(), null);
                    newLayer.setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                    dp.set("File", newFileName);
                    new ShapefileWriter().write(newLayer.getFeatureCollectionWrapper(), dp);
                    context.getWorkbenchFrame().getOutputFrame().addText(sSavedLayer + ": " + newLayer.getName());
                }
                return true;
            }
            if (filename.toLowerCase().endsWith(".jml")) {
                new JMLWriter().write(layer.getFeatureCollectionWrapper(), dp);
                return true;
            }
            if (filename.toLowerCase().endsWith(".gml")) {
                new GMLWriter().write((FeatureCollection)layer.getFeatureCollectionWrapper(), dp);
                return true;
            }
            if (filename.toLowerCase().endsWith(".fme")) {
                new FMEGMLWriter().write(layer.getFeatureCollectionWrapper(), dp);
                return true;
            }
            if (filename.toLowerCase().endsWith(".wkt")) {
                new WKTWriter().write((FeatureCollection)layer.getFeatureCollectionWrapper(), dp);
                return true;
            }
            context.getWorkbenchFrame().getOutputFrame().addText(sUnrecognizedFileType + " --- " + sCouldNotSaveLayer + ": " + layer.getName());
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            return false;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(sErrorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("SaveDatasetsPlugIn:WriteLayer Exception:" + e.toString());
            return false;
        }
    }

    private boolean CompatibleFeatures(Layer layer) {
        BitSet bitSet = new BitSet();
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        List featureList = featureCollection.getFeatures();
        Iterator i = featureList.iterator();
        while (i.hasNext()) {
            bitSet = GeoUtils.setBit(bitSet, ((Feature)i.next()).getGeometry());
        }
        return bitSet.cardinality() < 2;
    }

    private List splitLayer(PlugInContext context, Layer layer) {
        ArrayList<Layer> newLayers = new ArrayList<Layer>();
        if (!this.CompatibleFeatures(layer)) {
            Feature feature;
            Feature feature2;
            int i;
            Geometry geometry;
            ArrayList<Feature> emptyFeatures = new ArrayList<Feature>();
            ArrayList<Feature> pointFeatures = new ArrayList<Feature>();
            ArrayList<Feature> lineFeatures = new ArrayList<Feature>();
            ArrayList<Feature> polyFeatures = new ArrayList<Feature>();
            ArrayList<Feature> groupFeatures = new ArrayList<Feature>();
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            List featureList = featureCollection.getFeatures();
            FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            for (Feature feature3 : featureList) {
                geometry = feature3.getGeometry();
                if (geometry.isEmpty()) {
                    emptyFeatures.add(feature3);
                    continue;
                }
                if (!(geometry instanceof GeometryCollection) || geometry instanceof MultiPoint || geometry instanceof MultiLineString || geometry instanceof MultiPolygon) continue;
                groupFeatures.add(feature3);
            }
            for (i = 0; i < emptyFeatures.size(); ++i) {
                featureCollection.remove((Feature)emptyFeatures.get(i));
            }
            for (i = 0; i < groupFeatures.size(); ++i) {
                Feature feature3;
                feature3 = (Feature)groupFeatures.get(i);
                geometry = (GeometryCollection)feature3.getGeometry();
                this.explodeGeometryCollection(featureSchema, pointFeatures, lineFeatures, polyFeatures, (GeometryCollection)geometry, feature3);
                featureCollection.remove(feature3);
            }
            featureCollection = layer.getFeatureCollectionWrapper();
            featureList = layer.getFeatureCollectionWrapper().getFeatures();
            BitSet layerBit = new BitSet();
            if (featureList.size() > 0) {
                Geometry firstGeo = ((Feature)featureList.iterator().next()).getGeometry();
                layerBit = GeoUtils.setBit(layerBit, firstGeo);
            }
            if (layerBit.get(3)) {
                if (polyFeatures.size() > 0) {
                    for (int i2 = 0; i2 < polyFeatures.size(); ++i2) {
                        feature2 = (Feature)polyFeatures.get(i2);
                        featureCollection.add(feature2);
                    }
                    polyFeatures.clear();
                }
            } else if (layerBit.get(2)) {
                if (lineFeatures.size() > 0) {
                    for (int i3 = 0; i3 < lineFeatures.size(); ++i3) {
                        feature2 = (Feature)lineFeatures.get(i3);
                        featureCollection.add(feature2);
                    }
                    lineFeatures.clear();
                }
            } else if (layerBit.get(1)) {
                if (pointFeatures.size() > 0) {
                    for (int i4 = 0; i4 < pointFeatures.size(); ++i4) {
                        feature2 = (Feature)pointFeatures.get(i4);
                        featureCollection.add(feature2);
                    }
                    pointFeatures.clear();
                }
            } else if (polyFeatures.size() > 0) {
                for (int i5 = 0; i5 < polyFeatures.size(); ++i5) {
                    feature2 = (Feature)polyFeatures.get(i5);
                    featureCollection.add(feature2);
                }
                polyFeatures.clear();
            } else if (lineFeatures.size() > 0) {
                for (int i6 = 0; i6 < lineFeatures.size(); ++i6) {
                    feature2 = (Feature)lineFeatures.get(i6);
                    featureCollection.add(feature2);
                }
                lineFeatures.clear();
            } else if (pointFeatures.size() > 0) {
                for (int i7 = 0; i7 < pointFeatures.size(); ++i7) {
                    feature2 = (Feature)pointFeatures.get(i7);
                    featureCollection.add(feature2);
                }
                pointFeatures.clear();
            }
            featureCollection = layer.getFeatureCollectionWrapper();
            featureList = layer.getFeatureCollectionWrapper().getFeatures();
            layerBit = new BitSet();
            if (featureList.size() > 0) {
                Geometry firstGeo = ((Feature)featureList.iterator().next()).getGeometry();
                layerBit = GeoUtils.setBit(layerBit, firstGeo);
            }
            Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
            for (Feature feature4 : featureList) {
                Geometry geo = feature4.getGeometry();
                BitSet currFeatureBit = new BitSet();
                currFeatureBit = GeoUtils.setBit(currFeatureBit, geo);
                if (!layerBit.get(1) && currFeatureBit.get(1)) {
                    pointFeatures.add(feature4);
                }
                if (!layerBit.get(2) && currFeatureBit.get(2)) {
                    lineFeatures.add(feature4);
                }
                if (layerBit.get(3) || !currFeatureBit.get(3)) continue;
                polyFeatures.add(feature4);
            }
            if (pointFeatures.size() > 0) {
                Layer pointLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer.getName() + "_point", (FeatureCollection)new FeatureDataset(featureSchema));
                FeatureCollectionWrapper pointFeatureCollection = pointLayer.getFeatureCollectionWrapper();
                newLayers.add(pointLayer);
                context.getWorkbenchFrame().getOutputFrame().addText(sNewLayerCreated + ": " + pointLayer.getName());
                context.getWorkbenchFrame().warnUser(sNewLayerCreated + " - " + sWarningSeeOutputWindow);
                for (int i8 = 0; i8 < pointFeatures.size(); ++i8) {
                    feature = (Feature)pointFeatures.get(i8);
                    featureCollection.remove(feature);
                    pointFeatureCollection.add(feature);
                }
            }
            if (lineFeatures.size() > 0) {
                Layer lineLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer.getName() + "_line", (FeatureCollection)new FeatureDataset(featureSchema));
                FeatureCollectionWrapper lineFeatureCollection = lineLayer.getFeatureCollectionWrapper();
                newLayers.add(lineLayer);
                context.getWorkbenchFrame().getOutputFrame().addText(sNewLayerCreated + ": " + lineLayer.getName());
                context.getWorkbenchFrame().warnUser(sNewLayerCreated + " - " + sErrorSeeOutputWindow);
                for (int i9 = 0; i9 < lineFeatures.size(); ++i9) {
                    feature = (Feature)lineFeatures.get(i9);
                    featureCollection.remove(feature);
                    lineFeatureCollection.add(feature);
                }
            }
            if (polyFeatures.size() > 0) {
                Layer polyLayer = context.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layer.getName() + "_area", (FeatureCollection)new FeatureDataset(featureSchema));
                FeatureCollectionWrapper polyFeatureCollection = polyLayer.getFeatureCollectionWrapper();
                newLayers.add(polyLayer);
                context.getWorkbenchFrame().getOutputFrame().addText(sNewLayerCreated + ": " + polyLayer.getName());
                context.getWorkbenchFrame().warnUser(sNewLayerCreated + " - " + sErrorSeeOutputWindow);
                for (int i10 = 0; i10 < polyFeatures.size(); ++i10) {
                    feature = (Feature)polyFeatures.get(i10);
                    featureCollection.remove(feature);
                    polyFeatureCollection.add(feature);
                }
            }
        }
        return newLayers;
    }

    private void explodeGeometryCollection(FeatureSchema fs, ArrayList pointFeatures, ArrayList lineFeatures, ArrayList polyFeatures, GeometryCollection geometryCollection, Feature feature) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            if (geometry instanceof GeometryCollection) {
                this.explodeGeometryCollection(fs, pointFeatures, lineFeatures, polyFeatures, (GeometryCollection)geometry, feature);
                continue;
            }
            Feature newFeature = feature.clone(true);
            newFeature.setGeometry(geometry);
            BitSet featureBit = new BitSet();
            featureBit = GeoUtils.setBit(featureBit, geometry);
            if (featureBit.get(1)) {
                pointFeatures.add(newFeature);
            }
            if (featureBit.get(2)) {
                lineFeatures.add(newFeature);
            }
            if (!featureBit.get(3)) continue;
            polyFeatures.add(newFeature);
        }
    }

    private void writeProjectionFile(PlugInContext context, Layer outputLayer) throws IOException, FileNotFoundException {
        String outputFileName;
        DataSourceQuery dsqOut = outputLayer.getDataSourceQuery();
        if (dsqOut != null && (outputFileName = dsqOut.getDataSource().getProperties().get("File").toString()).toLowerCase().endsWith(".shp")) {
            String outputPrjFileName = "";
            int pos = outputFileName.lastIndexOf(46);
            outputPrjFileName = outputFileName.substring(0, pos) + ".prj";
            if (!new File(outputPrjFileName).exists()) {
                List layerList = context.getLayerManager().getLayers();
                for (Layer layer : layerList) {
                    String inputFileName;
                    DataSourceQuery dsq = layer.getDataSourceQuery();
                    if (dsq == null || !(inputFileName = dsq.getDataSource().getProperties().get("File").toString()).toLowerCase().endsWith(".shp")) continue;
                    String inputPrjFileName = "";
                    pos = inputFileName.lastIndexOf(46);
                    inputPrjFileName = inputFileName.substring(0, pos) + ".prj";
                    if (!new File(inputPrjFileName).exists()) continue;
                    List prjStr = FileUtil.getContents(inputPrjFileName);
                    try {
                        FileUtil.setContents(outputPrjFileName, prjStr);
                    }
                    catch (IOException ex) {
                        context.getWorkbenchFrame().getOutputFrame().addText(sCouldNotWrite + ": " + outputPrjFileName + " --- " + ex.getMessage());
                    }
                    break;
                }
            }
        }
    }
}

