/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.objecttyperoles.RoleOutline;
import org.openjump.core.rasterimage.RasterImageLayer;

public class ExportEnvelopeAsGeometryPlugIn
extends AbstractPlugIn {
    protected static FeatureSchema defaultSchema = null;

    public ExportEnvelopeAsGeometryPlugIn() {
        if (defaultSchema == null) {
            defaultSchema = new FeatureSchema();
            defaultSchema.addAttribute("geometry", AttributeType.GEOMETRY);
        }
    }

    public String getIconString() {
        return null;
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.ExportEnvelopeAsGeometryPlugIn.Export-Envelope-As-Geometry");
    }

    public boolean execute(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return false;
        }
        Polygon geom = rLayer.getEnvelopeAsGeometry();
        if (geom == null) {
            return false;
        }
        FeatureDataset newFeaturecollection = new FeatureDataset((FeatureSchema)defaultSchema.clone());
        BasicFeature feature = new BasicFeature((FeatureSchema)defaultSchema.clone());
        feature.setAttribute("geometry", (Object)geom);
        newFeaturecollection.add(feature);
        LayerTools.addStandardResultLayer(I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.ExportEnvelopeAsGeometryPlugIn.Geometry") + "-" + rLayer.getName(), newFeaturecollection, context, new RoleOutline());
        return false;
    }
}

